/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CamelModel<T extends AbstractChestedHorse>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("ecologics", "camel"), "main");
    private final ModelPart saddle;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart leftChest;
    private final ModelPart rightChest;

    public CamelModel(ModelPart root) {
        this.saddle = root.m_171324_("saddle");
        this.body = root.m_171324_("body");
        this.head = root.m_171324_("head");
        this.rightHindLeg = root.m_171324_("rightHindLeg");
        this.leftHindLeg = root.m_171324_("leftHindLeg");
        this.rightFrontLeg = root.m_171324_("rightFrontLeg");
        this.leftFrontLeg = root.m_171324_("leftFrontLeg");
        this.leftChest = root.m_171324_("leftChest");
        this.rightChest = root.m_171324_("rightChest");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition saddle = partdefinition.m_171599_("saddle", CubeListBuilder.m_171558_().m_171514_(80, 105).m_171488_(-5.0f, -13.0f, -1.5f, 10.0f, 9.0f, 14.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)-4.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 37).m_171488_(-5.0f, -7.0f, -3.0f, 10.0f, 5.0f, 13.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-5.0f, -2.0f, -10.0f, 10.0f, 11.0f, 26.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-2.0f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(46, 16).m_171488_(-2.0f, -14.975f, -15.0f, 4.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-3.0f, -15.0f, -10.0f, 6.0f, 19.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(14, 55).m_171488_(-3.0f, -4.0f, -3.0f, 6.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)-12.0f));
        PartDefinition leftEar = head.m_171599_("leftEar", CubeListBuilder.m_171558_().m_171514_(33, 37).m_171488_(-1.5f, -2.0f, -1.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.5f, (float)-15.0f, (float)-6.0f));
        PartDefinition rightEar = head.m_171599_("rightEar", CubeListBuilder.m_171558_().m_171514_(0, 37).m_171488_(-0.5f, -2.0f, -1.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.5f, (float)-15.0f, (float)-6.0f));
        PartDefinition rightHindLeg = partdefinition.m_171599_("rightHindLeg", CubeListBuilder.m_171558_().m_171514_(0, 55).m_171480_().m_171488_(0.0f, 0.0f, -3.0f, 3.0f, 16.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-4.5f, (float)8.0f, (float)12.0f));
        PartDefinition leftHindLeg = partdefinition.m_171599_("leftHindLeg", CubeListBuilder.m_171558_().m_171514_(0, 55).m_171488_(-3.0f, 0.0f, -3.0f, 3.0f, 16.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.5f, (float)8.0f, (float)12.0f));
        PartDefinition rightFrontLeg = partdefinition.m_171599_("rightFrontLeg", CubeListBuilder.m_171558_().m_171514_(0, 55).m_171480_().m_171488_(0.0f, 0.0f, -2.0f, 3.0f, 16.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-4.5f, (float)8.0f, (float)-9.0f));
        PartDefinition leftFrontLeg = partdefinition.m_171599_("leftFrontLeg", CubeListBuilder.m_171558_().m_171514_(0, 55).m_171488_(-3.0f, 0.0f, -2.0f, 3.0f, 16.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.5f, (float)8.0f, (float)-9.0f));
        PartDefinition leftChest = partdefinition.m_171599_("leftChest", CubeListBuilder.m_171558_().m_171514_(46, 0).m_171488_(19.0f, 0.0f, 2.0f, 3.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-14.5f, (float)-1.0f, (float)-5.0f));
        PartDefinition rightChest = partdefinition.m_171599_("rightChest", CubeListBuilder.m_171558_().m_171514_(46, 0).m_171480_().m_171488_(19.0f, 0.0f, 2.0f, 3.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-26.5f, (float)-1.0f, (float)-5.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        boolean showSaddle;
        boolean showChest;
        this.head.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = pNetHeadYaw * ((float)Math.PI / 180);
        this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.3331f)) * pLimbSwingAmount;
        this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.3331f + (float)Math.PI)) * pLimbSwingAmount;
        this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.3331f + (float)Math.PI)) * pLimbSwingAmount;
        this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.3331f)) * pLimbSwingAmount;
        this.rightChest.f_104207_ = showChest = !pEntity.m_6162_() && pEntity.m_30502_();
        this.leftChest.f_104207_ = showChest;
        this.saddle.f_104207_ = showSaddle = pEntity.m_6254_();
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.saddle.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.body.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.head.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.rightHindLeg.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.leftHindLeg.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.rightFrontLeg.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.leftFrontLeg.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.leftChest.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.rightChest.m_104301_(poseStack, buffer, packedLight, packedOverlay);
    }
}

