/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.big_cannon;

import javax.annotation.Nonnull;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_6880;
import net.minecraft.class_8110;
import rbasamoyai.createbigcannons.CBCClientCommon;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.block_armor_properties.BlockArmorPropertiesHandler;
import rbasamoyai.createbigcannons.block_armor_properties.BlockArmorPropertiesProvider;
import rbasamoyai.createbigcannons.config.CBCCfgMunitions;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.effects.particles.smoke.TrailSmokeParticleData;
import rbasamoyai.createbigcannons.index.CBCDamageTypes;
import rbasamoyai.createbigcannons.index.CBCSoundEvents;
import rbasamoyai.createbigcannons.multiloader.EnvExecute;
import rbasamoyai.createbigcannons.munitions.AbstractCannonProjectile;
import rbasamoyai.createbigcannons.munitions.CannonDamageSource;
import rbasamoyai.createbigcannons.munitions.ImpactExplosion;
import rbasamoyai.createbigcannons.munitions.ProjectileContext;
import rbasamoyai.createbigcannons.munitions.big_cannon.config.BigCannonProjectilePropertiesComponent;
import rbasamoyai.createbigcannons.munitions.config.components.BallisticPropertiesComponent;
import rbasamoyai.createbigcannons.network.ClientboundPlayBlockHitEffectPacket;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public abstract class AbstractBigCannonProjectile
extends AbstractCannonProjectile {
    private static final class_2940<class_1799> TRACER = class_2945.method_12791(AbstractBigCannonProjectile.class, (class_2941)class_2943.field_13322);

    protected AbstractBigCannonProjectile(class_1299<? extends AbstractBigCannonProjectile> type, class_1937 level) {
        super(type, level);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(TRACER, (Object)class_1799.field_8037);
    }

    @Override
    public void method_5773() {
        class_1923 cpos = new class_1923(this.method_24515());
        if (this.method_37908().field_9236 || this.method_37908().method_8393(cpos.field_9181, cpos.field_9180)) {
            class_243 oldPos = this.method_19538();
            super.method_5773();
            if (!this.isInGround()) {
                TrailType trailType = (TrailType)((Object)CBCConfigs.SERVER.munitions.bigCannonTrailType.get());
                if (trailType != TrailType.NONE) {
                    int lifetime = trailType == TrailType.SHORT ? 100 : 280 + this.method_37908().field_9229.method_43048(50);
                    TrailSmokeParticleData options = new TrailSmokeParticleData(lifetime);
                    for (int i = 0; i < 10; ++i) {
                        double partial = (float)i * 0.1f;
                        double dx = class_3532.method_16436((double)partial, (double)this.field_6038, (double)this.method_23317());
                        double dy = class_3532.method_16436((double)partial, (double)this.field_5971, (double)this.method_23318());
                        double dz = class_3532.method_16436((double)partial, (double)this.field_5989, (double)this.method_23321());
                        double sx = this.method_37908().field_9229.method_43058() * 0.004 - 0.002;
                        double sy = this.method_37908().field_9229.method_43058() * 0.004 - 0.002;
                        double sz = this.method_37908().field_9229.method_43058() * 0.004 - 0.002;
                        this.method_37908().method_17452((class_2394)options, true, dx, dy, dz, sx, sy, sz);
                    }
                }
                class_243 newPos = this.method_19538();
                if (this.method_37908().field_9236 && this.localSoundCooldown == 0) {
                    class_243 displacement = newPos.method_1020(oldPos);
                    double dispLen = displacement.method_1033();
                    class_243 originPos = newPos.method_1020(displacement.method_1021(0.5));
                    double radius = Math.min(200.0, dispLen * 30.0);
                    EnvExecute.executeOnClient(() -> () -> CBCClientCommon.playShellFlyingSoundOnClient(this, CBCSoundEvents.SHELL_FLYING.getMainEvent(), player -> {
                        if (!((Boolean)CBCConfigs.CLIENT.enableBigCannonFlybySounds.get()).booleanValue()) {
                            return false;
                        }
                        if (player.method_5707(originPos) > radius * radius) {
                            return false;
                        }
                        class_243 diff = player.method_19538().method_1020(originPos);
                        return displacement.method_1029().method_1026(diff.method_1029()) >= 0.0;
                    }, radius));
                }
            }
        }
    }

    public boolean hasTracer() {
        return (!this.getTracer().method_7960() || (Boolean)CBCConfigs.SERVER.munitions.allBigCannonProjectilesAreTracers.get() != false) && !this.isInGround();
    }

    public void setTracer(class_1799 stack) {
        this.field_6011.method_12778(TRACER, (Object)(stack == null || stack.method_7960() ? class_1799.field_8037 : stack));
    }

    public class_1799 getTracer() {
        return (class_1799)this.field_6011.method_12789(TRACER);
    }

    @Override
    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        if (!this.getTracer().method_7960()) {
            tag.method_10566("Tracer", (class_2520)this.getTracer().method_7953(new class_2487()));
        }
    }

    @Override
    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setTracer(tag.method_10573("Tracer", 10) ? class_1799.method_7915((class_2487)tag.method_10562("Tracer")) : class_1799.field_8037);
    }

    @Override
    protected void onTickRotate() {
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
        if (!this.isInGround()) {
            class_243 vel = this.method_18798();
            if (vel.method_1027() > 0.005) {
                this.method_36456((float)(class_3532.method_15349((double)vel.field_1352, (double)vel.field_1350) * 57.2957763671875));
                this.method_36457((float)(class_3532.method_15349((double)vel.field_1351, (double)vel.method_37267()) * 57.2957763671875));
            }
            this.method_36456(AbstractBigCannonProjectile.method_26960((float)this.field_5982, (float)this.method_36454()));
            this.method_36457(AbstractBigCannonProjectile.method_26960((float)this.field_6004, (float)this.method_36455()));
        }
    }

    public abstract class_2680 getRenderedBlockState();

    @Override
    protected AbstractCannonProjectile.ImpactResult calculateBlockPenetration(ProjectileContext projectileContext, class_2680 state, class_3965 blockHitResult) {
        boolean blockBroken;
        class_2338 pos = blockHitResult.method_17777();
        class_243 hitLoc = blockHitResult.method_17784();
        BallisticPropertiesComponent ballistics = this.getBallisticProperties();
        BlockArmorPropertiesProvider blockArmor = BlockArmorPropertiesHandler.getProperties(state);
        boolean unbreakable = projectileContext.griefState() == CBCCfgMunitions.GriefState.NO_DAMAGE || state.method_26214((class_1922)this.method_37908(), pos) == -1.0f;
        class_243 accel = this.getForces(this.method_19538(), this.method_18798());
        class_243 curVel = this.method_18798().method_1019(accel);
        class_243 normal = CBCUtils.getSurfaceNormalVector(this.method_37908(), blockHitResult);
        double incidence = Math.max(0.0, curVel.method_1029().method_1026(normal.method_22882()));
        double velMag = curVel.method_1033();
        double mass = this.getProjectileMass();
        double bonusMomentum = 1.0 + Math.max(0.0, (velMag - (double)CBCConfigs.SERVER.munitions.minVelocityForPenetrationBonus.getF()) * (double)CBCConfigs.SERVER.munitions.penetrationBonusScale.getF());
        double incidentVel = velMag * incidence;
        double momentum = mass * incidentVel * bonusMomentum;
        double toughness = blockArmor.toughness(this.method_37908(), state, pos, true);
        double toughnessPenalty = toughness - momentum;
        double hardnessPenalty = blockArmor.hardness(this.method_37908(), state, pos, true) - (double)ballistics.penetration();
        double bounceBonus = Math.max(1.0 - hardnessPenalty, 0.0);
        double projectileDeflection = ballistics.deflection();
        double baseChance = CBCConfigs.SERVER.munitions.baseProjectileBounceChance.getF();
        double bounceChance = projectileDeflection < 0.01 || incidence > projectileDeflection ? 0.0 : Math.max(baseChance, 1.0 - incidence / projectileDeflection) * bounceBonus;
        boolean surfaceImpact = this.canHitSurface();
        boolean canBounce = (Boolean)CBCConfigs.SERVER.munitions.projectilesCanBounce.get();
        boolean bl = blockBroken = toughnessPenalty < 0.01 && !unbreakable;
        AbstractCannonProjectile.ImpactResult.KinematicOutcome outcome = surfaceImpact && canBounce && this.method_37908().method_8409().method_43058() < bounceChance ? AbstractCannonProjectile.ImpactResult.KinematicOutcome.BOUNCE : (blockBroken && !this.method_37908().field_9236 ? AbstractCannonProjectile.ImpactResult.KinematicOutcome.PENETRATE : AbstractCannonProjectile.ImpactResult.KinematicOutcome.STOP);
        boolean shatter = surfaceImpact && outcome != AbstractCannonProjectile.ImpactResult.KinematicOutcome.BOUNCE && hardnessPenalty > (double)ballistics.toughness();
        float durabilityPenalty = ((float)Math.max(0.0, hardnessPenalty) + 1.0f) * (float)toughness / (float)incidentVel;
        state.method_26175(this.method_37908(), state, blockHitResult, (class_1676)this);
        if (!this.method_37908().field_9236) {
            class_243 effectNormal;
            boolean bounced;
            boolean bl2 = bounced = outcome == AbstractCannonProjectile.ImpactResult.KinematicOutcome.BOUNCE;
            if (bounced) {
                double elasticity = 1.7f;
                effectNormal = curVel.method_1020(normal.method_1021(normal.method_1026(curVel) * elasticity));
            } else {
                effectNormal = curVel.method_22882();
            }
            for (class_2680 state1 : blockArmor.containedBlockStates(this.method_37908(), state, pos.method_10062(), true)) {
                projectileContext.addPlayedEffect(new ClientboundPlayBlockHitEffectPacket(state1, this.method_5864(), bounced, true, hitLoc.field_1352, hitLoc.field_1351, hitLoc.field_1350, (float)effectNormal.field_1352, (float)effectNormal.field_1351, (float)effectNormal.field_1350));
            }
        }
        if (blockBroken) {
            this.setProjectileMass(incidentVel < 1.0E-4 ? 0.0f : Math.max(this.getProjectileMass() - durabilityPenalty, 0.0f));
            this.method_37908().method_8652(pos, class_2246.field_10124.method_9564(), 11);
            if (surfaceImpact) {
                float overPenetrationPower;
                float f = (float)toughness / (float)momentum;
                float f2 = overPenetrationPower = f < 0.15f ? 2.0f - 2.0f * f : 0.0f;
                if (overPenetrationPower > 0.0f && outcome == AbstractCannonProjectile.ImpactResult.KinematicOutcome.PENETRATE) {
                    projectileContext.queueExplosion(pos, overPenetrationPower);
                }
            }
        } else {
            if (outcome == AbstractCannonProjectile.ImpactResult.KinematicOutcome.STOP) {
                this.setProjectileMass(0.0f);
            } else {
                this.setProjectileMass(incidentVel < 1.0E-4 ? 0.0f : Math.max(this.getProjectileMass() - durabilityPenalty / 2.0f, 0.0f));
            }
            class_243 spallLoc = hitLoc.method_1019(curVel.method_1029().method_1021(2.0));
            if (!this.method_37908().field_9236) {
                ImpactExplosion explosion = new ImpactExplosion(this.method_37908(), (class_1297)this, this.indirectArtilleryFire(false), spallLoc.field_1352, spallLoc.field_1351, spallLoc.field_1350, 2.0f, class_1937.class_7867.field_40888);
                CreateBigCannons.handleCustomExplosion(this.method_37908(), explosion);
            }
            class_2498 sound = state.method_26231();
            if (!this.method_37908().field_9236) {
                this.method_37908().method_43128(null, spallLoc.field_1352, spallLoc.field_1351, spallLoc.field_1350, sound.method_10595(), class_3419.field_15245, sound.method_10597(), sound.method_10599());
            }
        }
        shatter |= this.onImpact((class_239)blockHitResult, new AbstractCannonProjectile.ImpactResult(outcome, shatter), projectileContext);
        return new AbstractCannonProjectile.ImpactResult(outcome, shatter);
    }

    @Override
    protected class_1282 getEntityDamage(class_1297 entity) {
        return new CannonDamageSource((class_6880<class_8110>)CannonDamageSource.getDamageRegistry(this.method_37908()).method_40290(CBCDamageTypes.BIG_CANNON_PROJECTILE), this.getDamageProperties().ignoresEntityArmor());
    }

    public float addedChargePower() {
        return this.getBigCannonProjectileProperties().addedChargePower();
    }

    public float minimumChargePower() {
        return this.getBigCannonProjectileProperties().minimumChargePower();
    }

    public boolean canSquib() {
        return this.getBigCannonProjectileProperties().canSquib();
    }

    public float addedRecoil() {
        return this.getBigCannonProjectileProperties().addedRecoil();
    }

    @Nonnull
    protected abstract BigCannonProjectilePropertiesComponent getBigCannonProjectileProperties();

    public static enum TrailType {
        NONE,
        LONG,
        SHORT;

    }
}

