/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.fabric;

import io.github.fabricators_of_create.porting_lib.event.client.CameraSetupCallback;
import io.github.fabricators_of_create.porting_lib.event.client.ClientWorldEvents;
import io.github.fabricators_of_create.porting_lib.event.client.FieldOfViewEvents;
import io.github.fabricators_of_create.porting_lib.event.client.FogEvents;
import io.github.fabricators_of_create.porting_lib.event.client.LivingEntityRenderEvents;
import io.github.fabricators_of_create.porting_lib.event.client.MouseInputEvents;
import io.github.fabricators_of_create.porting_lib.event.client.ParticleManagerRegistrationCallback;
import io.github.fabricators_of_create.porting_lib.event.common.ModsLoadedCallback;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.CoreShaderRegistrationCallback;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1041;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_4184;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_634;
import net.minecraft.class_635;
import net.minecraft.class_638;
import net.minecraft.class_922;
import rbasamoyai.createbigcannons.CBCClientCommon;
import rbasamoyai.createbigcannons.compat.trinkets.CBCTrinketsClient;
import rbasamoyai.createbigcannons.fabric.CBCModsFabric;
import rbasamoyai.createbigcannons.fabric.mixin.client.KeyMappingAccessor;
import rbasamoyai.createbigcannons.fabric.network.CBCNetworkFabric;
import rbasamoyai.createbigcannons.index.CBCRenderTypes;

public class CBCClientFabric
implements ClientModInitializer {
    public void onInitializeClient() {
        CBCClientCommon.onClientSetup();
        CBCClientCommon.registerKeyMappings(KeyBindingHelper::registerKeyBinding);
        CBCClientCommon.registerOverlays("hotbar", CBCClientFabric::wrapOverlay);
        CBCClientFabric.onRegisterClientReloadListeners();
        CBCNetworkFabric.INSTANCE.initClientListener();
        ParticleManagerRegistrationCallback.EVENT.register(CBCClientFabric::onParticleRegistry);
        FogEvents.SET_COLOR.register(CBCClientFabric::setFogColor);
        FogEvents.SET_DENSITY.register(CBCClientFabric::getFogDensity);
        ClientTickEvents.END_CLIENT_TICK.register(CBCClientFabric::onClientTick);
        MouseInputEvents.BEFORE_SCROLL.register(CBCClientFabric::onScrolledMouse);
        FieldOfViewEvents.MODIFY.register(CBCClientFabric::getFov);
        ScreenEvents.BEFORE_INIT.register(CBCClientFabric::onOpenScreen);
        LivingEntityRenderEvents.PRE.register(CBCClientFabric::onBeforeRender);
        CameraSetupCallback.EVENT.register(CBCClientFabric::onSetupCamera);
        MouseInputEvents.BEFORE_BUTTON.register(CBCClientFabric::onClickMouse);
        ClientPlayConnectionEvents.DISCONNECT.register(CBCClientFabric::onPlayerLogOut);
        ClientWorldEvents.LOAD.register(CBCClientFabric::onLoadClientLevel);
        ClientLoginConnectionEvents.INIT.register(CBCClientFabric::onPlayerLogIn);
        ModsLoadedCallback.EVENT.register(CBCClientFabric::onModsLoaded);
        CoreShaderRegistrationCallback.EVENT.register(CBCClientFabric::onShaderReload);
    }

    private static void wrapOverlay(String id, CBCClientCommon.CBCGuiOverlay overlay) {
        HudRenderCallback.EVENT.register((stack, partialTicks) -> {
            class_1041 window = class_310.method_1551().method_22683();
            overlay.renderOverlay(stack, partialTicks, window.method_4486(), window.method_4502());
        });
    }

    public static void onModsLoaded(EnvType envType) {
        if (envType != EnvType.CLIENT) {
            return;
        }
        CBCModsFabric.TRINKETS.executeIfInstalled(() -> () -> CBCTrinketsClient.initClient());
    }

    public static void onParticleRegistry() {
        class_310 mc = class_310.method_1551();
        CBCClientCommon.onRegisterParticleFactories(mc, mc.field_1713);
    }

    public static float getFogDensity(class_4184 info, float currentDensity) {
        float density = CBCClientCommon.getFogDensity(info, currentDensity);
        return density == -1.0f ? currentDensity : density;
    }

    public static void setFogColor(FogEvents.ColorData data, float partialTicks) {
        CBCClientCommon.setFogColor(data.getCamera(), (r, g, b) -> {
            data.setRed(r);
            data.setGreen(g);
            data.setBlue(b);
        });
    }

    public static void onClientTick(class_310 mc) {
        CBCClientCommon.onClientGameTick(mc);
    }

    public static boolean onClickMouse(int button, int mods, MouseInputEvents.Action action) {
        if (action != MouseInputEvents.Action.PRESS) {
            return false;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1755 != null) {
            return false;
        }
        class_304 mapping = null;
        if (mc.field_1690.field_1904.method_1433(button)) {
            mapping = mc.field_1690.field_1904;
        }
        if (mc.field_1690.field_1886.method_1433(button)) {
            mapping = mc.field_1690.field_1886;
        }
        return mapping != null && CBCClientCommon.onClickMouse(mapping);
    }

    public static boolean onScrolledMouse(double deltaX, double deltaY) {
        return CBCClientCommon.onScrollMouse(class_310.method_1551(), deltaY);
    }

    public static float getFov(class_1657 player, float oldFov) {
        return CBCClientCommon.onFovModify(class_310.method_1551(), oldFov);
    }

    public static void keyInput(int key, int scancode, boolean flag) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null || mc.field_1755 != null) {
            return;
        }
        CBCClientCommon.KEYS.stream().filter(k -> k.method_1417(key, scancode)).forEach(k -> CBCClientFabric.setInput(k, flag));
    }

    public static void mouseInput(int button, boolean flag) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null || mc.field_1755 != null) {
            return;
        }
        CBCClientCommon.KEYS.stream().filter(k -> k.method_1433(button)).forEach(k -> CBCClientFabric.setInput(k, flag));
    }

    public static void onOpenScreen(class_310 client, class_437 screen, int scaledWidth, int scaledHeight) {
        CBCClientCommon.KEYS.forEach(k -> CBCClientFabric.setInput(k, false));
    }

    private static void setInput(class_304 k, boolean flag) {
        k.method_23481(flag);
        if (flag) {
            KeyMappingAccessor acc = (KeyMappingAccessor)k;
            acc.setClickCount(acc.getClickCount() + 1);
        }
    }

    public static boolean onBeforeRender(class_1309 entity, class_922<?, ?> renderer, float partialRenderTick, class_4587 matrixStack, class_4597 buffers, int light) {
        if (entity.method_5864() == class_1299.field_6097) {
            CBCClientCommon.onPlayerRenderPre(matrixStack, entity, partialRenderTick);
        }
        return false;
    }

    public static boolean onSetupCamera(CameraSetupCallback.CameraInfo info) {
        return CBCClientCommon.onCameraSetup(info.camera, info.partialTicks, () -> Float.valueOf(info.yaw), () -> Float.valueOf(info.pitch), () -> Float.valueOf(info.roll), y -> {
            info.yaw = y.floatValue();
        }, p -> {
            info.pitch = p.floatValue();
        }, r -> {
            info.roll = r.floatValue();
        });
    }

    public static void onLoadClientLevel(class_310 minecraft, class_638 level) {
        CBCClientCommon.onLoadClientLevel((class_1936)level);
    }

    public static void onPlayerLogOut(class_634 impl, class_310 client) {
        CBCClientCommon.onPlayerLogOut(client.field_1724);
    }

    public static void onPlayerLogIn(class_635 impl, class_310 client) {
        CBCClientCommon.onPlayerLogIn(client.field_1724);
    }

    public static void onRegisterClientReloadListeners() {
        CBCClientCommon.registerClientReloadListeners(CBCClientFabric::wrapAndRegisterReloadListener);
    }

    public static void wrapAndRegisterReloadListener(final class_3302 base, final class_2960 location) {
        IdentifiableResourceReloadListener listener = new IdentifiableResourceReloadListener(){

            public class_2960 getFabricId() {
                return location;
            }

            public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
                return base.method_25931(preparationBarrier, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor);
            }
        };
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener(listener);
    }

    public static void onShaderReload(CoreShaderRegistrationCallback.RegistrationContext context) throws IOException {
        for (CBCRenderTypes renderType : CBCRenderTypes.values()) {
            context.register(renderType.id(), renderType.renderType().method_23031(), renderType::setShaderInstance);
        }
    }
}

