/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.crafting;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_4013;
import rbasamoyai.createbigcannons.crafting.BlockRecipe;
import rbasamoyai.createbigcannons.crafting.BlockRecipesManager;

public class BlockRecipeFinder {
    private static Cache<Object, List<BlockRecipe>> blockRecipeCache = CacheBuilder.newBuilder().build();
    public static final class_4013 LISTENER = manager -> blockRecipeCache.invalidateAll();

    public static List<BlockRecipe> get(@Nullable Object cacheKey, class_1937 level, Predicate<BlockRecipe> predicates) {
        if (cacheKey == null) {
            return BlockRecipeFinder.startSearch(level, predicates);
        }
        try {
            return (List)blockRecipeCache.get(cacheKey, () -> BlockRecipeFinder.startSearch(level, predicates));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    private static List<BlockRecipe> startSearch(class_1937 level, Predicate<? super BlockRecipe> predicates) {
        return BlockRecipesManager.getRecipes().stream().filter(predicates).collect(Collectors.toList());
    }
}

