/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.init.ModNetwork;
import com.tiviacz.travelersbackpack.inventory.BackpackContainer;
import com.tiviacz.travelersbackpack.network.IPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public class ServerboundSpecialActionPacket
implements IPacket<ServerboundSpecialActionPacket> {
    private final byte screenID;
    private final byte typeOfAction;
    private final double scrollDelta;

    public ServerboundSpecialActionPacket(byte screenID, byte typeOfAction, double scrollDelta) {
        this.screenID = screenID;
        this.typeOfAction = typeOfAction;
        this.scrollDelta = scrollDelta;
    }

    public static ServerboundSpecialActionPacket decode(class_2540 buffer) {
        byte screenID = buffer.readByte();
        byte typeOfAction = buffer.readByte();
        double scrollDelta = buffer.readDouble();
        return new ServerboundSpecialActionPacket(screenID, typeOfAction, scrollDelta);
    }

    @Override
    public void encode(ServerboundSpecialActionPacket message, class_2540 buffer) {
        buffer.writeByte((int)message.screenID);
        buffer.writeByte((int)message.typeOfAction);
        buffer.writeDouble(message.scrollDelta);
    }

    @Override
    public class_2960 getPacketId() {
        return ModNetwork.SPECIAL_ACTION_ID;
    }

    public static void handle(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        ServerboundSpecialActionPacket message = ServerboundSpecialActionPacket.decode(buf);
        server.execute(() -> {
            if (message.typeOfAction == 0) {
                ServerActions.swapTool((class_1657)player, message.scrollDelta);
            } else if (message.typeOfAction == 1) {
                ServerActions.switchHoseMode((class_1657)player, message.scrollDelta);
            } else if (message.typeOfAction == 2) {
                ServerActions.toggleHoseTank((class_1657)player);
            } else if (message.typeOfAction == 4) {
                if (ComponentUtils.isWearingBackpack((class_1657)player)) {
                    BackpackContainer.openBackpack(player, ComponentUtils.getWearingBackpack((class_1657)player), (byte)2);
                }
            } else if (message.typeOfAction == 5) {
                ServerActions.toggleVisibility((class_1657)player);
            }
        });
    }
}

