/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.tanks;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetBase;
import com.tiviacz.travelersbackpack.inventory.FluidTank;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import com.tiviacz.travelersbackpack.inventory.SlotPositioner;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.network.ServerboundFillTankPacket;
import com.tiviacz.travelersbackpack.util.FluidStackHelper;
import com.tiviacz.travelersbackpack.util.FluidTypeHelper;
import com.tiviacz.travelersbackpack.util.FluidUtil;
import com.tiviacz.travelersbackpack.util.PacketDistributorHelper;
import com.tiviacz.travelersbackpack.util.RenderHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_1812;
import net.minecraft.class_1844;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5244;
import net.minecraft.class_5250;

public class TankWidget
extends UpgradeWidgetBase<TanksUpgrade> {
    public final int tankWidth = 18;
    public final int tankHeight;
    public final Point leftTankPos;
    public final Point rightTankPos;

    public TankWidget(BackpackScreen screen, TanksUpgrade upgrade, Point pos) {
        super(screen, upgrade, pos, new Point(0, 0), "screen.travelersbackpack.tanks_upgrade");
        this.tankHeight = 18 * screen.visibleRows;
        this.leftTankPos = upgrade.leftTankPos;
        this.rightTankPos = upgrade.rightTankPos;
    }

    @Override
    public void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.inTank(this.leftTankPos, mouseX, mouseY)) {
            guiGraphics.method_51434(((BackpackScreen)this.screen).getFont(), this.getTankTooltip(((TanksUpgrade)this.upgrade).leftTank), mouseX, mouseY);
        }
        if (this.inTank(this.rightTankPos, mouseX, mouseY)) {
            guiGraphics.method_51434(((BackpackScreen)this.screen).getFont(), this.getTankTooltip(((TanksUpgrade)this.upgrade).rightTank), mouseX, mouseY);
        }
    }

    @Override
    public void renderAboveBg(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        SlotPositioner pos = ((TanksUpgrade)this.upgrade).getUpgradeManager().getWrapper().getSlotPositioner();
        int extendedOffset = 0;
        RenderHelper.renderScreenTank(guiGraphics, ((TanksUpgrade)this.upgrade).leftTank, x + 8, (y += 10) + 8, 0.0, (((BackpackScreen)this.screen).isScrollable ? ((BackpackScreen)this.screen).visibleRows : pos.getRows()) * 18 - 2, 16.0);
        this.renderTank(guiGraphics, pos, x + 7, y);
        if (pos.isExtended()) {
            extendedOffset = 36;
        }
        RenderHelper.renderScreenTank(guiGraphics, ((TanksUpgrade)this.upgrade).rightTank, x + 196 + extendedOffset, y + 8, 0.0, (((BackpackScreen)this.screen).isScrollable ? ((BackpackScreen)this.screen).visibleRows : pos.getRows()) * 18 - 2, 16.0);
        this.renderTank(guiGraphics, pos, x + 195 + extendedOffset, y);
    }

    @Override
    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        if (this.inTank(this.leftTankPos, (int)pMouseX, (int)pMouseY) && this.isValid(((BackpackBaseMenu)((BackpackScreen)this.screen).method_17577()).method_34255())) {
            PacketDistributorHelper.sendToServer(new ServerboundFillTankPacket(true));
            return true;
        }
        if (this.inTank(this.rightTankPos, (int)pMouseX, (int)pMouseY) && this.isValid(((BackpackBaseMenu)((BackpackScreen)this.screen).method_17577()).method_34255())) {
            PacketDistributorHelper.sendToServer(new ServerboundFillTankPacket(false));
            return true;
        }
        return super.method_25402(pMouseX, pMouseY, pButton);
    }

    public boolean isValid(class_1799 stack) {
        return FluidUtil.hasFluidStorageConstant(stack) || stack.method_7909() instanceof class_1812;
    }

    public void renderTank(class_332 guiGraphics, SlotPositioner pos, int x, int y) {
        guiGraphics.method_25302(BackpackScreen.ICONS, x, y + 7, 0, 95, 18, 18);
        for (int i = 1; i <= (((BackpackScreen)this.screen).isScrollable ? ((BackpackScreen)this.screen).visibleRows : pos.getRows()) - 2; ++i) {
            guiGraphics.method_25302(BackpackScreen.ICONS, x, y + 7 + 18 * i, 0, 113, 18, 18);
        }
        guiGraphics.method_25302(BackpackScreen.ICONS, x, y + 7 + 18 * ((((BackpackScreen)this.screen).isScrollable ? ((BackpackScreen)this.screen).visibleRows : pos.getRows()) - 1), 0, 131, 18, 18);
    }

    @Environment(value=EnvType.CLIENT)
    public List<class_2561> getTankTooltip(FluidTank tank) {
        Object fluidAmount;
        FluidVariantWrapper fluidStack = tank.getFluid();
        ArrayList<class_2561> tankTips = new ArrayList<class_2561>();
        String fluidName = !fluidStack.isEmpty() ? FluidTypeHelper.getFluidVariantName(fluidStack.fluidVariant()).getString() : class_1074.method_4662((String)"screen.travelersbackpack.none", (Object[])new Object[0]);
        Object object = fluidAmount = !fluidStack.isEmpty() ? fluidStack.getAmount() + "/" + tank.getCapacity() : class_1074.method_4662((String)"screen.travelersbackpack.empty", (Object[])new Object[0]);
        if (!fluidStack.isEmpty() && fluidStack.fluidVariant().getNbt() != null) {
            float durationFactor = 1.0f;
            if (fluidStack.fluidVariant().getNbt().method_10545("Splash")) {
                tankTips.add((class_2561)class_2561.method_43471((String)"item.minecraft.splash_potion"));
            }
            if (fluidStack.fluidVariant().getNbt().method_10545("Lingering")) {
                tankTips.add((class_2561)class_2561.method_43471((String)"item.minecraft.lingering_potion"));
                durationFactor = 0.25f;
            }
            if (fluidStack.fluidVariant().getNbt().method_10545("Potion")) {
                fluidName = null;
                TankWidget.setPotionDescription(FluidStackHelper.getItemStackFromFluidStack(fluidStack.fluidVariant()), tankTips, durationFactor);
            }
        }
        if (fluidName != null) {
            tankTips.add((class_2561)class_2561.method_43470((String)fluidName));
        }
        tankTips.add((class_2561)class_2561.method_43470((String)fluidAmount));
        return tankTips;
    }

    public boolean inTank(Point tankPos, int mouseX, int mouseY) {
        return ((BackpackScreen)this.screen).getGuiLeft() + tankPos.x() <= mouseX && mouseX <= tankPos.x() + this.tankWidth + ((BackpackScreen)this.screen).getGuiLeft() && tankPos.y() + ((BackpackScreen)this.screen).getGuiTop() <= mouseY && mouseY <= tankPos.y() + this.tankHeight + ((BackpackScreen)this.screen).getGuiTop();
    }

    public static void setPotionDescription(class_1799 p_43556_, List<class_2561> p_43557_, float durationFactor) {
        List list = class_1844.method_8067((class_1799)p_43556_);
        ArrayList list1 = Lists.newArrayList();
        if (list.isEmpty()) {
            p_43557_.add((class_2561)class_2561.method_43471((String)"effect.none").method_27692(class_124.field_1080));
        } else {
            for (class_1293 mobeffectinstance : list) {
                class_5250 mutablecomponent = class_2561.method_43471((String)mobeffectinstance.method_5586());
                class_1291 mobeffect = mobeffectinstance.method_5579();
                Map map = mobeffect.method_5565();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        class_1322 attributemodifier = (class_1322)entry.getValue();
                        class_1322 attributemodifier1 = new class_1322(attributemodifier.method_6185(), mobeffect.method_5563(mobeffectinstance.method_5578(), attributemodifier), attributemodifier.method_6182());
                        list1.add(new Pair((Object)((class_1320)entry.getKey()), (Object)attributemodifier1));
                    }
                }
                if (mobeffectinstance.method_5578() > 0) {
                    mutablecomponent = class_2561.method_43469((String)"potion.withAmplifier", (Object[])new Object[]{mutablecomponent, class_2561.method_43471((String)("potion.potency." + mobeffectinstance.method_5578()))});
                }
                if (mobeffectinstance.method_5584() > 20) {
                    mutablecomponent = class_2561.method_43469((String)"potion.withDuration", (Object[])new Object[]{mutablecomponent, class_1292.method_5577((class_1293)mobeffectinstance, (float)durationFactor)});
                }
                p_43557_.add((class_2561)mutablecomponent.method_27692(mobeffect.method_18792().method_18793()));
            }
        }
        if (!list1.isEmpty()) {
            p_43557_.add(class_5244.field_39003);
            p_43557_.add((class_2561)class_2561.method_43471((String)"potion.whenDrank").method_27692(class_124.field_1064));
            for (Pair pair : list1) {
                class_1322 attributemodifier2 = (class_1322)pair.getSecond();
                double d0 = attributemodifier2.method_6186();
                double d1 = attributemodifier2.method_6182() != class_1322.class_1323.field_6330 && attributemodifier2.method_6182() != class_1322.class_1323.field_6331 ? attributemodifier2.method_6186() : attributemodifier2.method_6186() * 100.0;
                if (d0 > 0.0) {
                    p_43557_.add((class_2561)class_2561.method_43469((String)("attribute.modifier.plus." + attributemodifier2.method_6182().method_6191()), (Object[])new Object[]{class_1799.field_8029.format(d1), class_2561.method_43471((String)((class_1320)pair.getFirst()).method_26830())}).method_27692(class_124.field_1078));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                p_43557_.add((class_2561)class_2561.method_43469((String)("attribute.modifier.take." + attributemodifier2.method_6182().method_6191()), (Object[])new Object[]{class_1799.field_8029.format(d1 *= -1.0), class_2561.method_43471((String)((class_1320)pair.getFirst()).method_26830())}).method_27692(class_124.field_1061));
            }
        }
    }
}

