/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.pickup;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.filter.IFilter;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.FilterSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.pickup.AutoPickupFilterSettings;
import com.tiviacz.travelersbackpack.inventory.upgrades.pickup.AutoPickupWidget;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;

public class AutoPickupUpgrade
extends UpgradeBase
implements IFilter,
IEnable {
    public ItemStackHandler filter;
    private final AutoPickupFilterSettings filterSettings;

    public AutoPickupUpgrade(UpgradeManager manager, int dataHolderSlot, class_2371<class_1799> filter) {
        super(manager, dataHolderSlot, new Point(66, 103));
        this.filter = this.createFilter(filter);
        int activeSlotCount = TravelersBackpackConfig.getConfig().backpackUpgrades.pickupUpgradeSettings.filterSlotCount;
        this.filterSettings = new AutoPickupFilterSettings(manager.getWrapper().getStorage(), filter.stream().limit(activeSlotCount).filter(stack -> !stack.method_7960()).toList(), this.getFilter());
    }

    @Override
    public List<Integer> getFilter() {
        return NbtHelper.getOrDefault(this.getUpgradeManager().getUpgradesHandler().getStackInSlot(this.dataHolderSlot), "FilterSettings", List.of(Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(1)));
    }

    public AutoPickupFilterSettings getFilterSettings() {
        return this.filterSettings;
    }

    public boolean canPickup(class_1799 stack) {
        return this.getFilterSettings().canPickup(stack) && this.isEnabled();
    }

    @Override
    public boolean isEnabled() {
        return NbtHelper.getOrDefault(this.getUpgradeManager().getUpgradesHandler().getStackInSlot(this.dataHolderSlot), "UpgradeEnabled", true);
    }

    @Override
    public void updateSettings() {
        this.filterSettings.updateSettings(this.getFilter());
    }

    @Override
    public void remove() {
        this.upgradeManager.pickupUpgrade = Optional.empty();
    }

    @Override
    public int getFilterSlotCount() {
        return TravelersBackpackConfig.getConfig().backpackUpgrades.pickupUpgradeSettings.filterSlotCount;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public WidgetBase createWidget(BackpackScreen screen, int x, int y) {
        return new AutoPickupWidget(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y));
    }

    public List<class_1735> getUpgradeSlots(final BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y) {
        ArrayList<class_1735> slots = new ArrayList<class_1735>();
        int activeSlotCount = TravelersBackpackConfig.getConfig().backpackUpgrades.pickupUpgradeSettings.filterSlotCount;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                slots.add(new FilterSlotItemHandler(this, this, this.filter, j + i * 3, x + 7 + j * 18, y + 44 + i * 18, activeSlotCount){
                    final /* synthetic */ AutoPickupUpgrade this$0;
                    {
                        this.this$0 = this$0;
                        super(upgrade, itemHandler, index, xPosition, yPosition, activeSlotCount);
                    }

                    @Override
                    public boolean method_7682() {
                        return super.method_7682() && this.this$0.getFilter().get(0) != 2;
                    }

                    @Override
                    public boolean method_7680(class_1799 pStack) {
                        return menu.getWrapper().isOwner(menu.player) && super.method_7680(pStack);
                    }
                });
            }
        }
        return slots;
    }

    private ItemStackHandler createFilter(class_2371<class_1799> stacks) {
        return new ItemStackHandler(stacks){

            @Override
            protected void onContentsChanged(int slot) {
                class_1799 stack = AutoPickupUpgrade.this.getUpgradeManager().getUpgradesHandler().getStackInSlot(AutoPickupUpgrade.this.getDataHolderSlot());
                NbtHelper.set(stack, "Inventory", AutoPickupUpgrade.this.filter);
                AutoPickupUpgrade.this.getUpgradeManager().getUpgradesHandler().setStackInSlot(AutoPickupUpgrade.this.getDataHolderSlot(), stack);
                AutoPickupUpgrade.this.getFilterSettings().updateFilter((List)NbtHelper.get(stack, "Inventory"));
            }

            @Override
            public boolean isItemValid(int slot, class_1799 stack) {
                return true;
            }

            @Override
            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }
}

