/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.jukebox;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.SlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.jukebox.JukeboxWidget;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1813;
import net.minecraft.class_2371;

public class JukeboxUpgrade
extends UpgradeBase {
    public ItemStackHandler diskHandler;

    public JukeboxUpgrade(UpgradeManager manager, int dataHolderSlot, class_2371<class_1799> musicDiskContents) {
        super(manager, dataHolderSlot, new Point(66, 46));
        this.diskHandler = this.createHandler(musicDiskContents);
    }

    @Override
    public void remove() {
        this.upgradeManager.jukeboxUpgrade = Optional.empty();
    }

    @Override
    public void onUpgradeRemoved(class_1799 removedStack) {
        NbtHelper.set(removedStack, "IsPlaying", false);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public WidgetBase createWidget(BackpackScreen screen, int x, int y) {
        return new JukeboxWidget(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y));
    }

    public List<class_1735> getUpgradeSlots(BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y) {
        ArrayList<class_1735> slots = new ArrayList<class_1735>();
        slots.add(new SlotItemHandler(this.diskHandler, 0, x + 7, y + 23){

            public boolean method_7682() {
                return JukeboxUpgrade.this.isTabOpened();
            }

            @Override
            public boolean method_7680(class_1799 pStack) {
                return JukeboxUpgrade.this.isTabOpened() && NbtHelper.getOrDefault(JukeboxUpgrade.this.getUpgradeManager().getUpgradesHandler().getStackInSlot(JukeboxUpgrade.this.getDataHolderSlot()), "IsPlaying", false) == false;
            }

            @Override
            public boolean method_7674(class_1657 playerIn) {
                return super.method_7674(playerIn) && NbtHelper.getOrDefault(JukeboxUpgrade.this.getUpgradeManager().getUpgradesHandler().getStackInSlot(JukeboxUpgrade.this.getDataHolderSlot()), "IsPlaying", false) == false;
            }
        });
        return slots;
    }

    public boolean isPlayingRecord() {
        return NbtHelper.getOrDefault(this.getUpgradeManager().getUpgradesHandler().getStackInSlot(this.dataHolderSlot), "IsPlaying", false);
    }

    public boolean canPlayRecord() {
        return !this.isPlayingRecord() && !this.diskHandler.getStackInSlot(0).method_7960();
    }

    public void setSlotChanged(class_1799 dataHolderStack, int index, class_1799 stack) {
        NbtHelper.update(dataHolderStack, "Inventory", 1, index, stack);
    }

    private ItemStackHandler createHandler(class_2371<class_1799> stacks) {
        return new ItemStackHandler(stacks){

            @Override
            protected void onContentsChanged(int slot) {
                class_1799 stack = JukeboxUpgrade.this.getUpgradeManager().getUpgradesHandler().getStackInSlot(JukeboxUpgrade.this.getDataHolderSlot());
                JukeboxUpgrade.this.setSlotChanged(stack, slot, this.getStackInSlot(slot));
                JukeboxUpgrade.this.getUpgradeManager().getUpgradesHandler().setStackInSlot(JukeboxUpgrade.this.getDataHolderSlot(), stack);
            }

            @Override
            public boolean isItemValid(int slot, class_1799 stack) {
                return stack.method_7909() instanceof class_1813;
            }
        };
    }
}

