/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.impl.transfer.fluid.FluidVariantImpl;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public record FluidVariantWrapper(FluidVariant fluidVariant, long amount) {
    public static Optional<FluidVariantWrapper> parse(class_2487 tag) {
        FluidVariant fluidVariant = FluidVariant.fromNbt((class_2487)tag.method_10562("fluidVariant"));
        long amount = tag.method_10537("amount");
        return Optional.of(new FluidVariantWrapper(fluidVariant, amount));
    }

    public static FluidVariantWrapper parseOptional(class_2487 tag) {
        return FluidVariantWrapper.parse(tag).isPresent() ? FluidVariantWrapper.parse(tag).get() : FluidVariantWrapper.blank();
    }

    public Optional<class_2520> save() {
        class_2487 tag = new class_2487();
        FluidVariantImpl impl = new FluidVariantImpl(this.fluidVariant.getFluid(), this.fluidVariant.getNbt());
        tag.method_10566("fluidVariant", (class_2520)impl.toNbt());
        tag.method_10544("amount", this.amount);
        return Optional.of(tag);
    }

    public class_2520 saveOptional() {
        return this.save().isPresent() ? this.save().get() : new class_2487();
    }

    public boolean isEmpty() {
        return this.fluidVariant.isBlank() || this.amount <= 0L;
    }

    public long getAmount() {
        return this.amount;
    }

    public static FluidVariantWrapper blank() {
        return new FluidVariantWrapper(FluidVariant.blank(), 0L);
    }

    public FluidVariantWrapper copyWithAmount(long amount) {
        if (this.isEmpty()) {
            return FluidVariantWrapper.blank();
        }
        if (amount <= 0L) {
            return FluidVariantWrapper.blank();
        }
        FluidVariantWrapper fluidVariant = this.copy();
        fluidVariant.setAmount(amount);
        return fluidVariant;
    }

    public FluidVariantWrapper copy() {
        if (this.isEmpty()) {
            return FluidVariantWrapper.blank();
        }
        return new FluidVariantWrapper(this.fluidVariant, this.amount);
    }

    public FluidVariantWrapper setAmount(long amount) {
        return new FluidVariantWrapper(this.fluidVariant, amount);
    }

    public FluidVariantWrapper grow(long addedAmount) {
        return this.setAmount(this.getAmount() + addedAmount);
    }

    public FluidVariantWrapper shrink(long removedAmount) {
        return this.grow(-removedAmount);
    }
}

