/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.component;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.component.ITravelersBackpack;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import dev.onyxstudios.cca.api.v3.component.ComponentProvider;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class TravelersBackpackComponent
implements ITravelersBackpack {
    private final String BACKPACK = "Wearable";
    public final class_1657 player;
    public BackpackWrapper backpackWrapper;
    public class_1799 backpack = new class_1799((class_1935)class_1802.field_8162, 0);

    public TravelersBackpackComponent(class_1657 player) {
        this.player = player;
    }

    @Override
    public boolean hasBackpack() {
        return this.backpack.method_7909() instanceof TravelersBackpackItem;
    }

    @Override
    public class_1799 getBackpack() {
        return this.backpack;
    }

    @Override
    public void equipBackpack(class_1799 stack) {
        this.remove();
        if (!(stack.method_7909() instanceof TravelersBackpackItem)) {
            return;
        }
        this.backpack = stack;
        this.backpackWrapper = new BackpackWrapper(this.backpack, 2, this.player, (class_1936)this.player.method_37908());
        this.backpackWrapper.setBackpackOwner(this.player);
        this.synchronise();
    }

    @Override
    public void updateBackpack(class_1799 stack) {
        if (this.backpackWrapper != null) {
            this.backpack = stack;
            this.backpackWrapper.setBackpackStack(this.backpack);
        } else {
            this.equipBackpack(stack);
        }
    }

    @Override
    public void applyComponents(class_2487 compound) {
        if (this.backpackWrapper != null) {
            for (String key : compound.method_10541()) {
                this.backpack.method_7948().method_10566(key, compound.method_10580(key));
            }
            this.backpackWrapper.setBackpackStack(this.backpack);
        }
    }

    @Override
    public void removeBackpack() {
        this.backpack = new class_1799((class_1935)class_1802.field_8162, 0);
    }

    @Override
    public void removeWrapper() {
        if (this.backpackWrapper != null) {
            this.backpackWrapper = null;
        }
    }

    @Override
    public void remove() {
        this.removeBackpack();
        this.removeWrapper();
        if (this.player.method_37908() != null && !this.player.method_37908().field_9236) {
            ComponentUtils.WEARABLE.sync((Object)this.player, (buf, recipient) -> this.writeSyncPacket(this.getBackpack(), buf, recipient, true));
            for (class_3222 recipient2 : PlayerLookup.tracking((class_1297)this.player)) {
                if (recipient2.method_5628() == this.player.method_5628()) continue;
                ComponentUtils.WEARABLE.syncWith(recipient2, (ComponentProvider)this.player, (buf, rec) -> this.writeSyncPacket(this.getBackpack(), buf, rec, true), p -> true);
            }
        }
    }

    @Override
    public BackpackWrapper getWrapper() {
        return this.backpackWrapper;
    }

    @Override
    public void synchronise() {
        if (this.player != null && !this.player.method_37908().field_9236) {
            ComponentUtils.WEARABLE.sync((Object)this.player);
            for (class_3222 recipient : PlayerLookup.tracking((class_1297)this.player)) {
                if (recipient.method_5628() == this.player.method_5628()) continue;
                ComponentUtils.WEARABLE.syncWith(recipient, (ComponentProvider)this.player, (buf, rec) -> this.writeSyncPacket(buf, rec), p -> true);
            }
        }
    }

    @Override
    public void synchronise(class_2487 compound) {
        if (this.player != null && !this.player.method_37908().field_9236) {
            ComponentUtils.WEARABLE.sync((Object)this.player, (buf, recipient) -> this.writeComponentPacket(buf, recipient, compound));
            for (class_3222 recipient2 : PlayerLookup.tracking((class_1297)this.player)) {
                if (recipient2.method_5628() == this.player.method_5628()) continue;
                ComponentUtils.WEARABLE.syncWith(recipient2, (ComponentProvider)this.player, (buf, rec) -> this.writeComponentPacket(buf, rec, compound), p -> true);
            }
        }
    }

    public void readFromNbt(class_2487 compoundTag) {
        class_1799 backpack = class_1799.method_7915((class_2487)compoundTag);
        this.equipBackpack(backpack);
    }

    public void writeToNbt(class_2487 tag) {
        class_1799 backpack = this.getBackpack();
        backpack.method_7953(tag);
    }

    public void writeComponentPacket(class_2540 buf, class_3222 recipient, class_2487 map) {
        buf.writeInt(1);
        buf.method_10794(map);
    }

    public void writeSyncPacket(class_1799 backpack, class_2540 buf, class_3222 recipient, boolean removeData) {
        class_1799 backpackCopy = backpack.method_7972();
        if (backpackCopy.method_7985()) {
            backpackCopy.method_7969().method_10551("Inventory");
        }
        if (backpackCopy.method_7985() && backpackCopy.method_7969().method_10545("MemorySlots")) {
            List memorizedStacksHeavy = (List)NbtHelper.get(backpackCopy, "MemorySlots");
            ArrayList<Pair> reduced = new ArrayList<Pair>();
            for (Pair outerPair : memorizedStacksHeavy) {
                int index = (Integer)outerPair.getFirst();
                class_1799 innerStack = ((class_1799)((Pair)outerPair.getSecond()).getFirst()).method_7972();
                boolean matchComponents = (Boolean)((Pair)outerPair.getSecond()).getSecond();
                if (matchComponents) {
                    innerStack = new class_1799((class_1935)innerStack.method_7909(), innerStack.method_7947());
                }
                if (innerStack.method_7960()) continue;
                reduced.add(Pair.of((Object)index, (Object)Pair.of((Object)innerStack, (Object)matchComponents)));
            }
            NbtHelper.set(backpack, "MemorySlots", reduced);
        }
        buf.writeInt(0);
        buf.writeBoolean(removeData);
        buf.method_10793(backpackCopy);
    }

    public void writeSyncPacket(class_2540 buf, class_3222 recipient) {
        this.writeSyncPacket(this.getBackpack(), buf, recipient, false);
    }

    public void applySyncPacket(class_2540 buf) {
        int type = buf.readInt();
        if (type == 0) {
            boolean removeData = buf.readBoolean();
            class_1799 backpackStack = buf.method_10819();
            if (removeData) {
                this.remove();
            } else {
                this.updateBackpack(backpackStack);
            }
        } else {
            class_2487 map = buf.method_10798();
            if (map != null) {
                this.applyComponents(map);
            }
        }
    }
}

