/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.buttons;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.buttons.Button;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.network.ServerboundSleepingBagPacket;
import com.tiviacz.travelersbackpack.util.PacketDistributorHelper;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public class SleepingBagButton
extends Button {
    private final boolean isEquipped;

    public SleepingBagButton(BackpackScreen screen, boolean isEquipped, int xOffset) {
        super(screen, screen.getWidthAdditions() + 145 - xOffset, screen.getMiddleBar(), 12, 12);
        this.isEquipped = isEquipped;
    }

    @Override
    public void render(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.drawButton(guiGraphics, mouseX, mouseY, BackpackScreen.ICONS, 91, 83, 78, 82);
    }

    @Override
    public void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        if (this.inButton(mouseX, mouseY)) {
            guiGraphics.method_51438(this.screen.getFont(), (class_2561)class_2561.method_43471((String)"screen.travelersbackpack.use_sleeping_bag"), mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.inButton((int)mouseX, (int)mouseY)) {
            if (this.isEquipped && this.screen.getWrapper().getBackpackOwner() == null) {
                return false;
            }
            PacketDistributorHelper.sendToServer(new ServerboundSleepingBagPacket(this.isEquipped ? this.screen.getWrapper().getBackpackOwner().method_24515() : this.screen.getWrapper().getBackpackPos(), this.isEquipped));
            return true;
        }
        return false;
    }

    public class_1799 getSleepingBagItemFromColor(int colorId) {
        return switch (colorId) {
            case 0 -> ModItems.WHITE_SLEEPING_BAG.method_7854();
            case 1 -> ModItems.ORANGE_SLEEPING_BAG.method_7854();
            case 2 -> ModItems.MAGENTA_SLEEPING_BAG.method_7854();
            case 3 -> ModItems.LIGHT_BLUE_SLEEPING_BAG.method_7854();
            case 4 -> ModItems.YELLOW_SLEEPING_BAG.method_7854();
            case 5 -> ModItems.LIME_SLEEPING_BAG.method_7854();
            case 6 -> ModItems.PINK_SLEEPING_BAG.method_7854();
            case 7 -> ModItems.GRAY_SLEEPING_BAG.method_7854();
            case 8 -> ModItems.LIGHT_GRAY_SLEEPING_BAG.method_7854();
            case 9 -> ModItems.CYAN_SLEEPING_BAG.method_7854();
            case 10 -> ModItems.PURPLE_SLEEPING_BAG.method_7854();
            case 11 -> ModItems.BLUE_SLEEPING_BAG.method_7854();
            case 12 -> ModItems.BROWN_SLEEPING_BAG.method_7854();
            case 13 -> ModItems.GREEN_SLEEPING_BAG.method_7854();
            case 15 -> ModItems.BLACK_SLEEPING_BAG.method_7854();
            default -> ModItems.RED_SLEEPING_BAG.method_7854();
        };
    }
}

