/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.IBackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.buttons.IButton;
import com.tiviacz.travelersbackpack.client.screens.widgets.InventoryScroll;
import com.tiviacz.travelersbackpack.client.screens.widgets.SettingsWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.MemoryWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.SettingsWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.SupporterBadgeWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.UnsortablesWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.VisibilityWidget;
import com.tiviacz.travelersbackpack.handlers.KeybindHandler;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackSettingsMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import com.tiviacz.travelersbackpack.util.Supporters;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_364;
import net.minecraft.class_3936;
import net.minecraft.class_465;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class BackpackSettingsScreen
extends class_465<BackpackSettingsMenu>
implements class_3936<BackpackSettingsMenu>,
IBackpackScreen {
    public static final int TOP_BAR_OFFSET = 17;
    public int slotCount;
    boolean wider = false;
    public List<IButton> buttons = new ArrayList<IButton>();
    public SettingsWidget settingsWidget;
    public UnsortablesWidget unsortablesWidget;
    public MemoryWidget memoryWidget;
    public VisibilityWidget visibilityWidget;
    public SupporterBadgeWidget supporterBadgeWidget;
    private final BackpackWrapper wrapper;
    public List<Integer> lastUnsortableSlots;
    public List<Integer> unsortableSlots = new ArrayList<Integer>();
    public List<Pair<Integer, Pair<class_1799, Boolean>>> lastMemorySlots;
    public List<Pair<Integer, Pair<class_1799, Boolean>>> memorySlots = new ArrayList<Pair<Integer, Pair<class_1799, Boolean>>>();
    public boolean visibility;
    public InventoryScroll scroll = null;
    public int slotYPos;
    public boolean isScrollable = false;
    public int scrollAmount = 0;
    public static final int HEIGHT_WITHOUT_STORAGE = 114;
    public int slotsHeight;
    public int visibleSlots;
    public int visibleRows;

    public BackpackSettingsScreen(BackpackSettingsMenu backpackSettingsMenu, class_1661 inventory, class_2561 component) {
        super((class_1703)backpackSettingsMenu, inventory, backpackSettingsMenu.getWrapper().getBackpackScreenTitle());
        this.wrapper = backpackSettingsMenu.getWrapper();
        this.recalculate();
        this.updateBackpackSlotsPosition();
        this.updatePlayerSlotsPosition();
        this.lastUnsortableSlots = new ArrayList<Integer>(this.wrapper.getUnsortableSlots());
        this.unsortableSlots = new ArrayList<Integer>(this.lastUnsortableSlots);
        this.lastMemorySlots = new ArrayList<Pair<Integer, Pair<class_1799, Boolean>>>(this.wrapper.getMemorySlots());
        this.memorySlots = new ArrayList<Pair<Integer, Pair<class_1799, Boolean>>>(this.lastMemorySlots);
        this.visibility = NbtHelper.getOrDefault(this.wrapper.getBackpackStack(), "IsVisible", true);
        this.field_25267 = 8;
        this.field_25268 = 6;
    }

    @Override
    public BackpackWrapper getWrapper() {
        return this.wrapper;
    }

    @Override
    public class_1657 getScreenPlayer() {
        return ((BackpackSettingsMenu)this.method_17577()).player;
    }

    public int getGuiLeft() {
        return this.field_2776;
    }

    public int getGuiTop() {
        return this.field_2800;
    }

    @Override
    public void sendDataToServer() {
        this.unsortablesWidget.sendDataToServer();
        this.memoryWidget.sendDataToServer();
    }

    protected void method_25426() {
        super.method_25426();
        this.initButtons();
        this.initWidgets();
    }

    public void method_25410(class_310 minecraft, int width, int height) {
        super.method_25410(minecraft, width, height);
        this.isScrollable = false;
        this.recalculate();
        this.method_25426();
        ((BackpackSettingsMenu)this.method_17577()).updateSlots();
        this.updateBackpackSlotsPosition();
        this.updatePlayerSlotsPosition();
    }

    public void recalculate() {
        boolean wideTexture;
        this.method_37067();
        this.visibleSlots = this.slotCount = this.getWrapper().getStorage().getSlots();
        this.slotsHeight = this.calculateSlotHeight(this.slotCount > 81);
        this.field_2776 = 0;
        this.field_2800 = 0;
        this.wider = wideTexture = this.slotCount > 81;
        this.visibleRows = (int)Math.ceil((double)this.slotCount / (double)this.getSlotsInRow());
        int playerInventoryHeight = 96;
        this.field_2792 = wideTexture ? 212 : 176;
        this.field_2779 = 17 + this.slotsHeight + playerInventoryHeight;
        this.updateDimensions();
        this.field_25270 = 20 + this.visibleRows * 18;
        this.field_25269 = 8;
        this.field_25267 = 8;
        this.field_25268 = 6;
        if (wideTexture) {
            this.field_25269 += 18;
        }
        if (((BackpackSettingsMenu)this.field_2797).method_7611((int)0).field_7872 >= 0) {
            this.slotYPos = ((BackpackSettingsMenu)this.field_2797).method_7611((int)0).field_7872;
        }
    }

    public void updateDimensions() {
        int guiScaledHeight = class_310.method_1551().method_22683().method_4502();
        if (guiScaledHeight < this.field_2779) {
            int displayableNumberOfRows = Math.min((guiScaledHeight - 114) / 18, this.getRows());
            int newImageHeight = 114 + this.calculateSlotHeight(displayableNumberOfRows);
            this.slotsHeight = this.calculateSlotHeight(displayableNumberOfRows);
            this.visibleSlots = displayableNumberOfRows * (this.slotCount > 81 ? 11 : 9);
            this.field_2779 = newImageHeight;
            this.visibleRows = displayableNumberOfRows;
            this.isScrollable = true;
        }
    }

    public void renderInventoryBackground(class_332 guiGraphics, int x, int y, class_2960 texture, int xSize, int slotsHeight) {
        int halfSlotHeight = slotsHeight / 2;
        guiGraphics.method_25302(texture, x, y, 0, 0, xSize, 17 + halfSlotHeight);
        int playerInventoryHeight = 98;
        guiGraphics.method_25302(texture, x, y + 17 + halfSlotHeight, 0, 256 - (playerInventoryHeight + halfSlotHeight), xSize, playerInventoryHeight + halfSlotHeight);
    }

    public void renderSlots(class_332 guiGraphics, int x, int y, int slotCount) {
        int fullRows;
        int lastSlotRow = this.slotCount % this.getSlotsInRow();
        int visibleRows = this.visibleRows;
        int n = fullRows = this.isScrollable ? visibleRows : slotCount / this.getSlotsInRow();
        if (this.isScrollable && this.scrollAmount == this.getMaxScrollAmount() && lastSlotRow > 0) {
            --fullRows;
        }
        guiGraphics.method_25302(BackpackScreen.SLOTS, x, y, 0, 0, this.getSlotsInRow() * 18, fullRows * 18);
        if (lastSlotRow > 0) {
            if (this.isScrollable) {
                if (this.scrollAmount == this.getMaxScrollAmount()) {
                    guiGraphics.method_25302(BackpackScreen.SLOTS, x, y + fullRows * 18, 0, fullRows * 18, lastSlotRow * 18, 18);
                }
            } else {
                guiGraphics.method_25302(BackpackScreen.SLOTS, x, y + fullRows * 18, 0, fullRows * 18, lastSlotRow * 18, 18);
            }
        }
    }

    public void renderScreen(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.method_25396().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderBg(guiGraphics, x, y, mouseX, mouseY));
        boolean wideTexture = this.slotCount > 81;
        this.renderInventoryBackground(guiGraphics, x, y, wideTexture ? BackpackScreen.BACKGROUND_11 : BackpackScreen.BACKGROUND_9, this.field_2792, this.slotsHeight);
        int slotsXOffset = 7;
        this.method_25396().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderAboveBg(guiGraphics, x, y, mouseX, mouseY, partialTicks));
        this.renderSlots(guiGraphics, x + slotsXOffset, y + 17, this.slotCount);
    }

    public int calculateSlotHeight(int displayableRows) {
        return displayableRows * 18;
    }

    public int calculateSlotHeight(boolean wider) {
        int rowSlots = wider ? 11 : 9;
        int rows = (int)Math.ceil((double)this.slotCount / (double)rowSlots);
        return rows * 18;
    }

    @Override
    public class_327 getFont() {
        return this.field_22793;
    }

    public void initWidgets() {
        this.settingsWidget = new SettingsWidget(this, new Point(this.field_2776 + this.field_2792 - 3, this.field_2800 + 4), true);
        this.method_37063(this.settingsWidget);
        this.unsortablesWidget = new UnsortablesWidget(this, new Point(this.field_2776 + this.field_2792 - 3, this.field_2800 + 4 + 24 + 1));
        this.method_37063(this.unsortablesWidget);
        this.memoryWidget = new MemoryWidget(this, new Point(this.field_2776 + this.field_2792 - 3, this.field_2800 + 4 + 24 + 1 + 24 + 1), false);
        this.method_37063(this.memoryWidget);
        if (this.getWrapper().getScreenID() == 2) {
            this.visibilityWidget = new VisibilityWidget(this, new Point(this.field_2776 + this.field_2792 - 3, this.field_2800 + 4 + 24 + 1 + 24 + 1 + 24 + 1));
            this.method_37063(this.visibilityWidget);
            if (this.getWrapper().isOwner(this.getScreenPlayer()) && Supporters.SUPPORTERS_REFERENCE.contains(this.getScreenPlayer().method_7334().getName())) {
                this.supporterBadgeWidget = new SupporterBadgeWidget(this, new Point(this.field_2776 + this.field_2792 - 3, this.field_2800 + 4 + 24 + 1 + 24 + 1 + 24 + 1 + 24 + 1));
                this.method_37063(this.supporterBadgeWidget);
            }
        }
        if (this.isScrollable) {
            int scrollXPos = this.field_2776 + 7;
            this.scroll = new InventoryScroll(this, class_310.method_1551(), 4, this.visibleRows * 18, this.field_2800 + 17, scrollXPos + this.getSlotsInRow() * 18);
            if (this.scrollAmount != 0) {
                this.scroll.setScrollDistance(this.scrollAmount);
            }
            this.method_37063((class_364)this.scroll);
        }
    }

    @Override
    public void setScrollAmount(int scrollAmount) {
        this.scrollAmount = scrollAmount;
    }

    public void initButtons() {
        this.buttons.clear();
    }

    @Override
    public int getRows() {
        return (int)Math.ceil((double)this.slotCount / (double)this.getSlotsInRow());
    }

    public void closeTabs(SettingsWidgetBase openedWidget) {
        this.method_25396().stream().filter(widget -> widget instanceof SettingsWidgetBase && widget != openedWidget).forEach(widget -> {
            ((SettingsWidgetBase)widget).tabOpened = false;
        });
    }

    public void updateWidgetsPosition(SettingsWidgetBase openedWidget) {
        this.closeTabs(openedWidget);
        List<class_364> widgets = this.method_25396().stream().filter(w -> w instanceof SettingsWidgetBase).toList();
        for (int i = 0; i < widgets.size(); ++i) {
            SettingsWidgetBase previousWidget = null;
            SettingsWidgetBase currentWidget = (SettingsWidgetBase)widgets.get(i);
            if (i > 0) {
                previousWidget = (SettingsWidgetBase)widgets.get(i - 1);
            }
            if (previousWidget == null) continue;
            int[] previousWidgetPosAndSize = previousWidget.getWidgetSizeAndPos();
            currentWidget.updatePos(previousWidgetPosAndSize[1], previousWidgetPosAndSize[3] + 1);
        }
    }

    @Override
    public void updateBackpackSlotsPosition() {
        int allStorageSlots = this.slotCount;
        if (this.isScrollable) {
            int i;
            int scrollAmount = this.scrollAmount;
            int hiddenSlotsFirst = scrollAmount * this.getSlotsInRow();
            int movedSlots = this.visibleRows * this.getSlotsInRow() - hiddenSlotsFirst;
            int revealedSlots = scrollAmount * this.getSlotsInRow();
            int lastRowSlots = this.slotCount % this.getSlotsInRow();
            if (scrollAmount == this.getMaxScrollAmount() && lastRowSlots > 0) {
                revealedSlots -= this.getSlotsInRow();
                revealedSlots += lastRowSlots;
            }
            for (int i2 = 0; i2 < hiddenSlotsFirst; ++i2) {
                ((class_1735)((BackpackSettingsMenu)this.field_2797).field_7761.get((int)i2)).field_7872 = -1000;
            }
            int countSlots = 0;
            for (int i3 = hiddenSlotsFirst; i3 < hiddenSlotsFirst + movedSlots; ++i3) {
                ((class_1735)((BackpackSettingsMenu)this.field_2797).field_7761.get((int)i3)).field_7872 = this.slotYPos + (int)Math.floor((double)countSlots / (double)this.getSlotsInRow()) * 18;
                ++countSlots;
            }
            countSlots = 0;
            int lastY = this.slotYPos + (this.visibleRows - scrollAmount) * 18;
            for (i = hiddenSlotsFirst + movedSlots; i < hiddenSlotsFirst + movedSlots + revealedSlots; ++i) {
                ((class_1735)((BackpackSettingsMenu)this.field_2797).field_7761.get((int)i)).field_7872 = lastY + (int)Math.floor((double)countSlots / (double)this.getSlotsInRow()) * 18;
                ++countSlots;
            }
            for (i = hiddenSlotsFirst + movedSlots + revealedSlots; i < allStorageSlots; ++i) {
                ((class_1735)((BackpackSettingsMenu)this.field_2797).field_7761.get((int)i)).field_7872 = -1000;
            }
        }
    }

    public void updatePlayerSlotsPosition() {
        if (this.isScrollable) {
            int i;
            int firstPlayerSlotY = 32 + this.visibleRows * 18;
            int countSlots = 0;
            for (i = this.slotCount; i < this.slotCount + 27; ++i) {
                ((class_1735)((BackpackSettingsMenu)this.field_2797).field_7761.get((int)i)).field_7872 = firstPlayerSlotY + (int)Math.floor((double)countSlots / 9.0) * 18;
                ++countSlots;
            }
            for (i = this.slotCount + 27; i < this.slotCount + 36; ++i) {
                ((class_1735)((BackpackSettingsMenu)this.field_2797).field_7761.get((int)i)).field_7872 = firstPlayerSlotY + 54 + 4;
            }
        }
    }

    public int getSlotsInRow() {
        return this.wider ? 11 : 9;
    }

    public int getMaxScrollAmount() {
        return (int)Math.ceil((double)this.slotCount / (double)this.getSlotsInRow()) - (int)Math.ceil((double)this.visibleSlots / (double)this.getSlotsInRow());
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(guiGraphics);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        this.buttons.forEach(button -> button.render(guiGraphics, mouseX, mouseY, partialTicks));
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    protected void method_2380(class_332 guiGraphics, int mouseX, int mouseY) {
        super.method_2380(guiGraphics, mouseX, mouseY);
        this.buttons.forEach(button -> button.renderTooltip(guiGraphics, mouseX, mouseY));
        this.method_25396().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderTooltip(guiGraphics, mouseX, mouseY));
    }

    protected void method_2389(class_332 guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        this.renderScreen(guiGraphics, x, y, mouseX, mouseY, partialTicks);
        this.drawUnsortableSlots(guiGraphics);
        this.drawMemorySlots(guiGraphics);
    }

    public void drawUnsortableSlots(class_332 guiGraphics) {
        if (this.unsortablesWidget.isTabOpened()) {
            if (!this.unsortableSlots.isEmpty()) {
                this.unsortableSlots.forEach(i -> guiGraphics.method_25302(BackpackScreen.ICONS, this.getGuiLeft() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)i.intValue()).field_7873, this.getGuiTop() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)i.intValue()).field_7872, 25, 55, 16, 16));
            }
        } else if (!this.lastUnsortableSlots.isEmpty()) {
            this.lastUnsortableSlots.forEach(i -> guiGraphics.method_25302(BackpackScreen.ICONS, this.getGuiLeft() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)i.intValue()).field_7873, this.getGuiTop() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)i.intValue()).field_7872, 25, 55, 16, 16));
        }
    }

    public void drawMemorySlots(class_332 guiGraphics) {
        if (this.memoryWidget.isTabOpened()) {
            if (!this.memorySlots.isEmpty()) {
                this.memorySlots.forEach(pair -> {
                    if (((Boolean)((Pair)pair.getSecond()).getSecond()).booleanValue()) {
                        guiGraphics.method_25302(BackpackScreen.ICONS, this.getGuiLeft() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7873, this.getGuiTop() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7872, 25, 73, 16, 16);
                    } else {
                        guiGraphics.method_25302(BackpackScreen.ICONS, this.getGuiLeft() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7873, this.getGuiTop() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7872, 25, 91, 16, 16);
                    }
                    if (((BackpackSettingsMenu)this.method_17577()).method_7611((Integer)pair.getFirst()).method_7677().method_7960()) {
                        class_1799 itemstack = (class_1799)((Pair)pair.getSecond()).getFirst();
                        guiGraphics.method_51445(itemstack, this.getGuiLeft() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7873, this.getGuiTop() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7872);
                        guiGraphics.method_51739(class_1921.method_51787(), this.getGuiLeft() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7873, this.getGuiTop() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7872, this.getGuiLeft() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7873 + 16, this.getGuiTop() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7872 + 16, 0x30FFFFFF);
                    }
                });
            }
        } else if (!this.lastMemorySlots.isEmpty()) {
            this.lastMemorySlots.forEach(pair -> {
                if (((BackpackSettingsMenu)this.method_17577()).method_7611((Integer)pair.getFirst()).method_7677().method_7960()) {
                    class_1799 itemstack = (class_1799)((Pair)pair.getSecond()).getFirst();
                    guiGraphics.method_51445(itemstack, this.getGuiLeft() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7873, this.getGuiTop() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7872);
                    guiGraphics.method_51739(class_1921.method_51787(), this.getGuiLeft() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7873, this.getGuiTop() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7872, this.getGuiLeft() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7873 + 16, this.getGuiTop() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7872 + 16, 0x30FFFFFF);
                }
            });
        }
    }

    protected void method_2383(class_1735 slot, int slotId, int button, class_1713 type) {
        if (this.selectSlots(slot, button)) {
            return;
        }
        super.method_2383(slot, slotId, button, type);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollY) {
        if (this.scroll != null) {
            return this.scroll.method_25401(mouseX, mouseY, scrollY);
        }
        return super.method_25401(mouseX, mouseY, scrollY);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        class_1735 slot = this.field_2787;
        if (this.selectSlots(slot, button)) {
            return true;
        }
        for (class_364 child : this.method_25396()) {
            if (!child.method_25405(mouseX, mouseY) || !child.method_25403(mouseX, mouseY, button, dragX, dragY)) continue;
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean selectSlots(class_1735 slot, int button) {
        if (slot != null && slot.field_7874 >= 0 && slot.field_7874 < this.wrapper.getStorage().getSlots()) {
            if (this.unsortablesWidget.isTabOpened()) {
                if (button == 0 && !this.unsortableSlots.contains(slot.field_7874)) {
                    this.unsortableSlots.add(slot.field_7874);
                    return true;
                }
                if (button == 1 && this.unsortableSlots.contains(slot.field_7874)) {
                    this.unsortableSlots.remove((Object)slot.field_7874);
                    return true;
                }
            }
            if (this.memoryWidget.isTabOpened()) {
                if (button == 0 && !this.memoryWidget.contains(slot.field_7874, this.memorySlots)) {
                    if (slot.method_7677().method_7960()) {
                        return false;
                    }
                    this.memorySlots.add((Pair<Integer, Pair<class_1799, Boolean>>)Pair.of((Object)slot.field_7874, (Object)Pair.of((Object)(this.memoryWidget.matchComponents ? slot.method_7677() : slot.method_7677().method_7909().method_7854()), (Object)this.memoryWidget.matchComponents)));
                    return true;
                }
                if (button == 1 && this.memoryWidget.contains(slot.field_7874, this.memorySlots)) {
                    this.memorySlots.removeIf(p -> (Integer)p.getFirst() == slot.field_7874);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        class_364 focused = this.method_25399();
        if (focused != null && !focused.method_25405(mouseX, mouseY) && focused instanceof WidgetBase) {
            WidgetBase widgetBase = (WidgetBase)focused;
            widgetBase.method_25365(false);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public void playUIClickSound() {
        ((BackpackSettingsMenu)this.field_2797).getPlayerInventory().field_7546.method_37908().method_8396(((BackpackSettingsMenu)this.field_2797).getPlayerInventory().field_7546, ((BackpackSettingsMenu)this.field_2797).getPlayerInventory().field_7546.method_24515(), (class_3414)class_3417.field_15015.comp_349(), class_3419.field_15250, 0.25f, 1.0f);
    }

    public void method_25419() {
        this.sendDataToServer();
        super.method_25419();
    }

    public boolean method_25404(int pKeyCode, int pScanCode, int pModifiers) {
        if (KeybindHandler.OPEN_BACKPACK.method_1417(pKeyCode, pScanCode)) {
            class_746 playerEntity = this.field_22787.field_1724;
            if (playerEntity != null) {
                this.method_25419();
            }
            return true;
        }
        return super.method_25404(pKeyCode, pScanCode, pModifiers);
    }
}

