/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.client.renderer.BackpackBlockEntityRenderer;
import com.tiviacz.travelersbackpack.client.renderer.BackpackEntityLayer;
import com.tiviacz.travelersbackpack.client.renderer.BackpackLayer;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.BackpackSettingsScreen;
import com.tiviacz.travelersbackpack.client.screens.HudOverlay;
import com.tiviacz.travelersbackpack.client.screens.tooltip.BackpackTooltipComponent;
import com.tiviacz.travelersbackpack.client.screens.tooltip.ClientBackpackTooltipComponent;
import com.tiviacz.travelersbackpack.commands.BackpackIconCommands;
import com.tiviacz.travelersbackpack.compat.polymorph.PolymorphCompat;
import com.tiviacz.travelersbackpack.compat.trinkets.TravelersBackpackTrinketIntegration;
import com.tiviacz.travelersbackpack.fluids.potion.PotionFluidVariantAttributeHandler;
import com.tiviacz.travelersbackpack.fluids.potion.PotionFluidVariantRenderHandler;
import com.tiviacz.travelersbackpack.handlers.KeybindHandler;
import com.tiviacz.travelersbackpack.init.ModBlockEntityTypes;
import com.tiviacz.travelersbackpack.init.ModFluids;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.init.ModMenuTypes;
import com.tiviacz.travelersbackpack.init.ModNetwork;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.fabric.api.client.render.fluid.v1.SimpleFluidRenderHandler;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.LivingEntityFeatureRendererRegistrationCallback;
import net.fabricmc.fabric.api.client.rendering.v1.TooltipComponentCallback;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRenderHandler;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributeHandler;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1007;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_3929;
import net.minecraft.class_5272;
import net.minecraft.class_5616;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_742;
import net.minecraft.class_7923;
import net.minecraft.class_916;
import net.minecraft.class_922;

@Environment(value=EnvType.CLIENT)
public class TravelersBackpackClient
implements ClientModInitializer {
    public static final class_2960 STAR_MODEL = new class_2960("travelersbackpack", "item/supporter_star");

    public void onInitializeClient() {
        class_3929.method_17542(ModMenuTypes.BACKPACK_MENU, BackpackScreen::new);
        class_3929.method_17542(ModMenuTypes.BACKPACK_BLOCK_MENU, BackpackScreen::new);
        class_3929.method_17542(ModMenuTypes.BACKPACK_SETTINGS_MENU, BackpackSettingsScreen::new);
        class_5616.method_32144(ModBlockEntityTypes.BACKPACK, BackpackBlockEntityRenderer::new);
        TravelersBackpackClient.registerFeatureRenderers();
        TravelersBackpackClient.registerBuiltinItemRenderer();
        TravelersBackpackClient.registerHudOverlay();
        TravelersBackpackClient.registerTooltipComponent();
        KeybindHandler.initKeybinds();
        KeybindHandler.registerListener();
        ModNetwork.initClient();
        TravelersBackpackClient.registerModelPredicate();
        TravelersBackpackClient.setupFluidRendering();
        TravelersBackpackClient.registerBackpackItemEntityRenderer();
        TravelersBackpackClient.registerClientCommands();
        if (TravelersBackpack.polymorphLoaded) {
            PolymorphCompat.registerWidget();
        }
        if (TravelersBackpack.trinketsLoaded) {
            TravelersBackpackTrinketIntegration.initClient();
        }
    }

    public static void registerBackpackItemEntityRenderer() {
        EntityRendererRegistry.register(ModItems.BACKPACK_ITEM_ENTITY, class_916::new);
    }

    public static void registerFeatureRenderers() {
        LivingEntityFeatureRendererRegistrationCallback.EVENT.register((entityType, entityRenderer, registrationHelper, context) -> {
            if (entityRenderer instanceof class_1007) {
                class_1007 renderer = (class_1007)entityRenderer;
                registrationHelper.register((class_3887)new BackpackLayer((class_3883<class_742, class_591<class_742>>)renderer));
            }
            if (entityRenderer.method_4038() instanceof class_572 && entityRenderer instanceof class_922) {
                if (entityRenderer instanceof class_1007) {
                    return;
                }
                registrationHelper.register((class_3887)new BackpackEntityLayer((class_3883<class_1309, class_572<class_1309>>)entityRenderer));
            }
        });
    }

    public static void registerBuiltinItemRenderer() {
        class_7923.field_41178.method_10220().filter(item -> item instanceof TravelersBackpackItem).forEach(item -> BuiltinItemRendererRegistry.INSTANCE.register((class_1935)item, (stack, mode, matrices, vertexConsumers, light, overlay) -> BackpackBlockEntityRenderer.renderByItem(stack, matrices, vertexConsumers, light, overlay)));
    }

    public static void registerHudOverlay() {
        HudRenderCallback.EVENT.register(HudOverlay::render);
    }

    public static void setupFluidRendering() {
        FluidRenderHandlerRegistry.INSTANCE.register((class_3611)ModFluids.POTION_STILL, (class_3611)ModFluids.POTION_FLOWING, (FluidRenderHandler)new SimpleFluidRenderHandler(new class_2960("travelersbackpack", "block/potion_still"), new class_2960("travelersbackpack", "block/potion_flow"), 13458603));
        FluidVariantAttributes.register((class_3611)ModFluids.POTION_STILL, (FluidVariantAttributeHandler)new PotionFluidVariantAttributeHandler());
        FluidVariantAttributes.register((class_3611)ModFluids.POTION_FLOWING, (FluidVariantAttributeHandler)new PotionFluidVariantAttributeHandler());
        FluidVariantRendering.register((class_3611)ModFluids.POTION_STILL, (FluidVariantRenderHandler)new PotionFluidVariantRenderHandler());
        FluidVariantRendering.register((class_3611)ModFluids.POTION_FLOWING, (FluidVariantRenderHandler)new PotionFluidVariantRenderHandler());
        BlockRenderLayerMap.INSTANCE.putFluids(class_1921.method_23583(), new class_3611[]{ModFluids.POTION_STILL, ModFluids.POTION_FLOWING});
    }

    public static void registerTooltipComponent() {
        TooltipComponentCallback.EVENT.register(data -> {
            if (data instanceof BackpackTooltipComponent) {
                return new ClientBackpackTooltipComponent((BackpackTooltipComponent)data);
            }
            return null;
        });
    }

    public static void registerModelPredicate() {
        class_5272.method_27879((class_1792)ModItems.HOSE, (class_2960)new class_2960("travelersbackpack", "mode"), (stack, clientWorld, livingEntity, par) -> {
            List modes;
            if (NbtHelper.has(stack, "HoseModes") && !(modes = (List)NbtHelper.get(stack, "HoseModes")).isEmpty()) {
                int mode = (Integer)modes.get(0);
                return (float)mode / 10.0f;
            }
            return 0.0f;
        });
    }

    public static void registerClientCommands() {
        ClientCommandRegistrationCallback.EVENT.register(BackpackIconCommands::new);
    }
}

