/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.data;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_7094;
import net.venturecraft.gliders.data.fabric.GliderDataImpl;
import net.venturecraft.gliders.network.SyncGliderData;
import net.venturecraft.gliders.util.GliderUtil;
import org.jetbrains.annotations.NotNull;

public class GliderData {
    @NotNull
    private final class_1657 player;
    public class_7094 glideAnimation = new class_7094();
    public class_7094 fallingAnimation = new class_7094();
    public class_7094 gliderOpeningAnimation = new class_7094();
    private boolean isGliding = false;
    private int lightningTimer = 0;

    public GliderData(@NotNull class_1657 player) {
        this.player = player;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Optional<GliderData> get(class_1309 player) {
        return GliderDataImpl.get(player);
    }

    public void tick(class_1309 livingEntity) {
        this.glideAndFallLogic(livingEntity);
        GliderUtil.onTickPlayerGlide(livingEntity.method_37908(), livingEntity);
        if (!GliderUtil.isGlidingWithActiveGlider(livingEntity)) {
            this.setLightningTimer(0);
        }
        if (livingEntity.method_37908().field_9236) {
            return;
        }
        this.setGliding(GliderUtil.isGlidingWithActiveGlider(livingEntity));
        if (livingEntity.field_6012 % 40 == 0) {
            this.sync();
        }
    }

    private boolean isGliding() {
        return this.isGliding;
    }

    private void setGliding(boolean glidingWithActiveGlider) {
        this.isGliding = glidingWithActiveGlider;
    }

    private void glideAndFallLogic(class_1309 livingEntity) {
        if (this.isGliding() || GliderUtil.isGlidingWithActiveGlider(livingEntity)) {
            if (!this.glideAnimation.method_41327()) {
                this.glideAnimation.method_41322(livingEntity.field_6012);
            }
            if (!this.gliderOpeningAnimation.method_41327()) {
                this.gliderOpeningAnimation.method_41322(livingEntity.field_6012);
            }
        } else {
            this.glideAnimation.method_41325();
            this.gliderOpeningAnimation.method_41325();
        }
    }

    public void sync() {
        if (this.player.method_37908().field_9236) {
            throw new IllegalStateException("Don't sync client -> server");
        }
        new SyncGliderData(this.player.method_5628(), this.serializeNBT()).sendToTracking((class_1297)this.player);
    }

    public void syncTo(class_3222 receiver) {
        if (this.player.method_37908().field_9236) {
            throw new IllegalStateException("Don't sync client -> server");
        }
        new SyncGliderData(this.player.method_5628(), this.serializeNBT()).send(receiver);
    }

    public class_7094 getAnimation(AnimationStates animationStates) {
        return switch (animationStates) {
            default -> throw new IncompatibleClassChangeError();
            case AnimationStates.FALLING -> this.fallingAnimation;
            case AnimationStates.GLIDING -> this.glideAnimation;
            case AnimationStates.GLIDER_OPENING -> this.gliderOpeningAnimation;
        };
    }

    public class_2487 serializeNBT() {
        class_2487 compoundTag = new class_2487();
        compoundTag.method_10556("is_gliding", this.isGliding);
        compoundTag.method_10569("lightningTimer", this.lightningTimer);
        return compoundTag;
    }

    public int lightningTimer() {
        return this.lightningTimer;
    }

    public GliderData setLightningTimer(int lightningTimer) {
        this.lightningTimer = lightningTimer;
        return this;
    }

    public void deserializeNBT(class_2487 nbt) {
        this.setGliding(nbt.method_10577("is_gliding"));
        this.setLightningTimer(nbt.method_10550("lightningTimer"));
    }

    public static enum AnimationStates {
        FALLING,
        GLIDING,
        GLIDER_OPENING;

    }
}

