/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.util;

import com.tom.peripherals.api.LuaException;
import com.tom.peripherals.math.MathHelper;
import java.util.Arrays;
import java.util.stream.IntStream;

public class ParamCheck {
    public static void isNumber(Object[] a, int arg) throws LuaException {
        if (arg >= a.length || !(a[arg] instanceof Double)) {
            throw new LuaException("Bad argument #" + (arg + 1) + ": (expected Number)");
        }
    }

    public static int optionalInt(Object[] a, int arg, int def) throws LuaException {
        if (arg < a.length) {
            return ParamCheck.getInt(a, arg);
        }
        return def;
    }

    public static int getInt(Object[] a, int arg) throws LuaException {
        ParamCheck.isNumber(a, arg);
        return MathHelper.floor((Double)a[arg]);
    }

    public static double getDouble(Object[] a, int arg) throws LuaException {
        ParamCheck.isNumber(a, arg);
        return (Double)a[arg];
    }

    public static String getString(Object[] a, int arg) throws LuaException {
        if (arg >= a.length || a[arg] == null) {
            throw new LuaException("Bad argument #" + (arg + 1) + ": (expected Number)");
        }
        return a[arg].toString();
    }

    public static boolean getBoolean(Object[] a, int arg) throws LuaException {
        if (arg >= a.length || !(a[arg] instanceof Boolean)) {
            throw new LuaException("Bad argument #" + (arg + 1) + ": (expected Boolean)");
        }
        return (Boolean)a[arg];
    }

    public static IntStream ints(Object[] a, int arg) throws LuaException {
        return Arrays.stream(a, arg, a.length).mapToInt(e -> {
            if (e instanceof Double) {
                Double d = (Double)e;
                return MathHelper.floor(d);
            }
            throw new LuaException("Bad argument #" + (arg + 1) + "-" + a.length + ": (expected Number)");
        });
    }

    public static IntStream uints(Object[] a, int arg) throws LuaException {
        return Arrays.stream(a, arg, a.length).mapToInt(e -> {
            if (e instanceof Double) {
                Double d = (Double)e;
                return (int)d.longValue();
            }
            throw new LuaException("Bad argument #" + (arg + 1) + "-" + a.length + ": (expected Number)");
        });
    }

    public static int toColor(Object[] args, int start) throws LuaException {
        if (args.length == start) {
            throw new LuaException("Too few arguments expected number argb or [number r/a], [number g/r], [number b/g], [number b]");
        }
        if (args.length == start + 3) {
            if (args[start] instanceof Double && args[start + 1] instanceof Double && args[start + 2] instanceof Double) {
                int r = MathHelper.floor((Double)args[start]) & 0xFF;
                int g = MathHelper.floor((Double)args[start + 1]) & 0xFF;
                int b = MathHelper.floor((Double)args[start + 2]) & 0xFF;
                return 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
            }
            throw new LuaException("bad arguments: numbers expected");
        }
        if (args.length == start + 4) {
            if (args[start] instanceof Double && args[start + 1] instanceof Double && args[start + 2] instanceof Double && args[start + 3] instanceof Double) {
                int r = MathHelper.floor((Double)args[start]) & 0xFF;
                int g = MathHelper.floor((Double)args[start + 1]) & 0xFF;
                int b = MathHelper.floor((Double)args[start + 2]) & 0xFF;
                int a = MathHelper.floor((Double)args[start + 3]) & 0xFF;
                return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
            }
            throw new LuaException("bad arguments: numbers expected");
        }
        ParamCheck.isNumber(args, start);
        long color = ((Double)args[start]).longValue();
        return (int)color;
    }
}

