/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.screen;

import com.mojang.blaze3d.platform.TextureUtil;
import com.tom.peripherals.block.entity.MonitorBlockEntity;
import com.tom.peripherals.screen.TextureCache;
import java.nio.IntBuffer;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.lwjgl.system.MemoryUtil;

public class TextureCacheImpl
implements TextureCache {
    private final class_1043 dynTex;
    private final class_2960 loc;
    private class_1011 image;
    private IntBuffer buffer;
    private MonitorBlockEntity be;
    private boolean needsUpdate;

    public TextureCacheImpl(MonitorBlockEntity be) {
        this.be = be;
        this.needsUpdate = true;
        this.dynTex = new class_1043(16, 16, true);
        this.loc = class_310.method_1551().method_1531().method_4617("toms_peripherals", this.dynTex);
    }

    @Override
    public void invalidate() {
        this.needsUpdate = true;
    }

    @Override
    public void cleanup() {
        this.be = null;
        class_310.method_1551().method_1531().method_4615(this.loc);
    }

    @Override
    public class_2960 getTexture() {
        if (this.be == null || this.be.screen.length == 0) {
            return null;
        }
        class_310 mc = class_310.method_1551();
        if (mc.method_1531().method_4619(this.loc) == null) {
            mc.method_1531().method_4616(this.loc, (class_1044)this.dynTex);
        }
        if (this.needsUpdate) {
            this.load(this.be.width, this.be.screen);
            this.needsUpdate = false;
        }
        return this.loc;
    }

    private void load(int w, int[] img) {
        int h = img.length / w;
        if (img.length != w * h) {
            System.err.println("Attempting to load an invalid texture");
            return;
        }
        if (this.image == null) {
            this.image = new class_1011(w, h, false);
            this.getBuffer();
        } else if (this.image.method_4307() != w || this.image.method_4323() != h) {
            this.image.close();
            this.image = new class_1011(w, h, false);
            this.getBuffer();
        }
        this.buffer.rewind();
        this.buffer.put(img);
        this.dynTex.method_4524();
    }

    private void getBuffer() {
        this.dynTex.method_4526(this.image);
        TextureUtil.prepareImage((int)this.dynTex.method_4624(), (int)this.image.method_4307(), (int)this.image.method_4323());
        this.buffer = MemoryUtil.memIntBuffer((long)this.image.field_4988, (int)(this.image.method_4307() * this.image.method_4323()));
    }
}

