/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.gpu;

import com.tom.peripherals.api.LuaException;
import com.tom.peripherals.gpu.font.Font;
import com.tom.peripherals.util.ReferenceManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class VRAM {
    private final long maxMemory;
    private Map<String, Font.CustomFont> internalFonts = new HashMap<String, Font.CustomFont>();
    private Set<VRAMObject> objects = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private ReferenceManager refMngr = new ReferenceManager();

    public VRAM(long maxMemory) {
        this.maxMemory = maxMemory;
    }

    public Map<String, Font.CustomFont> getIntFonts() {
        return this.internalFonts;
    }

    public void alloc(VRAMObject o) {
        this.objects.add(o);
    }

    public long getUsedMemory() {
        return this.objects.stream().mapToLong(VRAMObject::getSize).sum();
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public boolean checkSize(long size) {
        long all = this.getUsedMemory();
        return all + size <= this.maxMemory;
    }

    public void checkSizeEx(long size) throws LuaException {
        if (!this.checkSize(size)) {
            throw new LuaException("Alloc failed: Out of VRAM");
        }
    }

    public boolean tryAlloc(VRAMObject o, long size) {
        if (this.checkSize(size)) {
            this.alloc(o);
            return true;
        }
        return false;
    }

    public void allocEx(VRAMObject o, long size) throws LuaException {
        if (!this.tryAlloc(o, size)) {
            throw new LuaException("Alloc failed: Out of VRAM");
        }
    }

    public boolean realloc(VRAMObject o, long size) {
        long all = this.objects.stream().filter(e -> e != o).mapToLong(VRAMObject::getSize).sum();
        return all + size <= this.maxMemory;
    }

    public void reallocEx(VRAMObject o, long size) throws LuaException {
        if (!this.realloc(o, size)) {
            throw new LuaException("Realloc failed: Out of VRAM");
        }
    }

    public void free(VRAMObject o) {
        this.objects.remove(o);
    }

    public ReferenceManager getRefMngr() {
        return this.refMngr;
    }

    public static interface VRAMObject {
        public long getSize();
    }
}

