/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.block.entity;

import com.tom.peripherals.api.LuaException;
import com.tom.peripherals.api.LuaMethod;
import com.tom.peripherals.api.ObjectWrapper;
import com.tom.peripherals.api.TMLuaObject;
import com.tom.peripherals.cc.ComputerControl;
import com.tom.peripherals.platform.AbstractPeripheralBlockEntity;
import com.tom.peripherals.platform.Platform;
import com.tom.peripherals.util.ParamCheck;
import com.tom.peripherals.util.TickerUtil;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;

public class WatchDogTimerBlockEntity
extends AbstractPeripheralBlockEntity
implements TickerUtil.TickableServer {
    private ObjectWrapper peripheral;
    private boolean enabled;
    private int timeLimit;
    private int timer;

    public WatchDogTimerBlockEntity(class_2591<?> p_155228_, class_2338 p_155229_, class_2680 p_155230_) {
        super(p_155228_, p_155229_, p_155230_);
    }

    @Override
    public void updateServer() {
        if (!this.enabled) {
            return;
        }
        if (this.timer > this.timeLimit) {
            this.enabled = false;
            class_2350 facting = (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12525);
            class_2338 onPos = this.method_11016().method_10093(facting);
            ComputerControl.restartComputerAt(this.field_11863, onPos);
        } else {
            ++this.timer;
        }
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.enabled = tag.method_10577("enabled");
        this.timeLimit = tag.method_10550("timeLimit");
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10556("enabled", this.enabled);
        tag.method_10569("timeLimit", this.timeLimit);
    }

    @Override
    public ObjectWrapper getPeripheral() {
        if (this.peripheral == null) {
            this.peripheral = new ObjectWrapper("tm_wdt", new WDT());
        }
        return this.peripheral;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public int getTimer() {
        return this.timer;
    }

    public class WDT
    extends TMLuaObject {
        @LuaMethod
        public boolean isEnabled() {
            return WatchDogTimerBlockEntity.this.enabled;
        }

        @LuaMethod
        public int getTimeout() {
            return WatchDogTimerBlockEntity.this.timeLimit;
        }

        @LuaMethod
        public void setEnabled(Object[] a) throws LuaException {
            if (a.length < 1) {
                throw new LuaException("Too few arguments (expected enable)");
            }
            boolean enable = ParamCheck.getBoolean(a, 0);
            Platform.getServer().execute(() -> {
                WatchDogTimerBlockEntity.this.enabled = enable;
                WatchDogTimerBlockEntity.this.timer = 0;
                WatchDogTimerBlockEntity.this.method_5431();
            });
        }

        @LuaMethod
        public void setTimeout(Object[] a) throws LuaException {
            if (WatchDogTimerBlockEntity.this.enabled) {
                throw new LuaException("Can't edit timeout value while the timer is enabled");
            }
            if (a.length < 1) {
                throw new LuaException("Too few arguments (expected enable)");
            }
            int time = ParamCheck.getInt(a, 0);
            if (time < 20) {
                throw new LuaException("Bad argument #1 (expected value must be larger than 20 ticks)");
            }
            Platform.getServer().execute(() -> {
                WatchDogTimerBlockEntity.this.timeLimit = time;
                WatchDogTimerBlockEntity.this.timer = 0;
                WatchDogTimerBlockEntity.this.method_5431();
            });
        }

        @LuaMethod
        public void reset() throws LuaException {
            Platform.getServer().execute(() -> {
                WatchDogTimerBlockEntity.this.timer = 0;
            });
        }
    }
}

