/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.block.entity;

import com.tom.peripherals.block.entity.GPUBlockEntity;
import com.tom.peripherals.math.Vec2i;
import com.tom.peripherals.screen.TextureCache;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3532;

public class MonitorBlockEntity
extends class_2586 {
    private class_2338 gpuPos;
    public TextureCache clientCache;
    public int[] screen = new int[0];
    public int width;

    public MonitorBlockEntity(class_2591<?> p_155228_, class_2338 p_155229_, class_2680 p_155230_) {
        super(p_155228_, p_155229_, p_155230_);
    }

    public class_2350 getDirection() {
        return (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12525);
    }

    public class_2338 getOffset(int x, int y, class_2350 d) {
        int xCoord = this.field_11867.method_10263();
        int yCoord = this.field_11867.method_10264();
        int zCoord = this.field_11867.method_10260();
        switch (d) {
            case field_11033: {
                return new class_2338(xCoord + x, yCoord, zCoord + y);
            }
            case field_11036: {
                return new class_2338(xCoord + x, yCoord, zCoord - y);
            }
            case field_11043: {
                return new class_2338(xCoord - x, yCoord + y, zCoord);
            }
            case field_11035: {
                return new class_2338(xCoord + x, yCoord + y, zCoord);
            }
            case field_11039: {
                return new class_2338(xCoord, yCoord + y, zCoord + x);
            }
            case field_11034: {
                return new class_2338(xCoord, yCoord + y, zCoord - x);
            }
        }
        return new class_2338(xCoord, yCoord, zCoord);
    }

    public MonitorBlockEntity connect(class_2338 gpuPos) {
        this.gpuPos = gpuPos;
        return this;
    }

    public void sync() {
        if (this.method_10997() != null) {
            class_2680 state = this.method_10997().method_8320(this.method_11016());
            this.method_10997().method_8413(this.method_11016(), state, state, 3);
        }
    }

    public void onBlockActivated(class_2350 side, double x, double y, double z, boolean sneak) {
        class_2586 tile;
        if (this.getDirection() == side && this.gpuPos != null && (tile = this.field_11863.method_8321(this.gpuPos)) != null && tile instanceof GPUBlockEntity) {
            GPUBlockEntity gpu = (GPUBlockEntity)tile;
            Vec2i c = this.getMonitorPixel(side, x, y, z);
            gpu.monitorClick(this, c.x, c.y, sneak);
        }
    }

    public Vec2i getMonitorPixel(class_2350 side, double x, double y, double z) {
        int yP;
        int xP;
        if (side.method_10166() != class_2350.class_2351.field_11052) {
            double yPos = 1.0 - y;
            double xPos = (double)Math.abs(side.method_10165()) * x + (double)Math.abs(side.method_10148()) * z;
            if (side.method_10171() == class_2350.class_2352.field_11060 != (side.method_10166() == class_2350.class_2351.field_11048)) {
                xPos = 1.0 - xPos;
            }
            xP = class_3532.method_15357((double)(xPos * (double)this.width));
            yP = class_3532.method_15357((double)(yPos * (double)this.width));
        } else {
            double yPos = side == class_2350.field_11033 ? 1.0 - z : z;
            xP = class_3532.method_15357((double)(x * (double)this.width));
            yP = class_3532.method_15357((double)(yPos * (double)this.width));
        }
        return new Vec2i(xP, yP);
    }

    public class_2487 method_16887() {
        class_2487 tag = new class_2487();
        tag.method_10539("s", this.screen);
        tag.method_10575("w", (short)this.width);
        return tag;
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public void method_11014(class_2487 compoundTag) {
        super.method_11014(compoundTag);
        if (compoundTag.method_10545("s")) {
            this.screen = compoundTag.method_10561("s");
            this.width = compoundTag.method_10568("w");
            if (this.clientCache != null) {
                this.clientCache.invalidate();
            }
        }
    }

    public void method_11012() {
        super.method_11012();
        if (this.clientCache != null) {
            this.clientCache.cleanup();
        }
        this.clientCache = null;
    }

    public void event(String ev, int x, int y, Integer param) {
        if (this.gpuPos == null) {
            return;
        }
        class_2586 tile = this.field_11863.method_8321(this.gpuPos);
        if (tile != null && tile instanceof GPUBlockEntity) {
            GPUBlockEntity gpu = (GPUBlockEntity)tile;
            gpu.monitorEvent(this, ev, x, y, param);
        }
    }
}

