/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals;

import com.mojang.logging.LogUtils;
import com.tom.peripherals.Config;
import com.tom.peripherals.Content;
import com.tom.peripherals.gpu.font.FontManager;
import com.tom.peripherals.network.Network;
import com.tom.peripherals.platform.AbstractPeripheralBlockEntity;
import com.tom.peripherals.platform.Platform;
import dan200.computercraft.api.peripheral.PeripheralLookup;
import fuzs.forgeconfigapiport.api.config.v2.ForgeConfigRegistry;
import fuzs.forgeconfigapiport.api.config.v2.ModConfigEvents;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_2591;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.slf4j.Logger;

public class PeripheralsMod
implements ModInitializer {
    public static final String ID = "toms_peripherals";
    public static final Logger LOGGER = LogUtils.getLogger();

    public void onInitialize() {
        Content.init();
        Platform.register();
        ForgeConfigRegistry.INSTANCE.register(ID, ModConfig.Type.COMMON, (IConfigSpec)Config.commonSpec);
        ForgeConfigRegistry.INSTANCE.register(ID, ModConfig.Type.SERVER, (IConfigSpec)Config.serverSpec);
        ModConfigEvents.loading((String)ID).register(c -> {
            LOGGER.info("Loaded Tom's Peripherals config file {}", (Object)c.getFileName());
            Config.load(c);
        });
        ModConfigEvents.reloading((String)ID).register(c -> {
            LOGGER.info("Tom's Peripherals config just got changed on the file system!");
            Config.load(c);
        });
        PeripheralLookup.get().registerForBlockEntities((b, side) -> {
            if (b instanceof AbstractPeripheralBlockEntity) {
                AbstractPeripheralBlockEntity be = (AbstractPeripheralBlockEntity)b;
                return be.getCCPeripheral();
            }
            return null;
        }, new class_2591[]{Content.gpuBE.get(), Content.redstonePortBE.get(), Content.wdtBE.get(), Content.keyboardBE.get()});
        Network.initCommon();
        FontManager.init();
    }
}

