/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;
    static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;
    public static int maxScreenSize;
    public static int maxVRAMSize;

    public static void load(ModConfig modConfig) {
        if (modConfig.getType() == ModConfig.Type.SERVER) {
            maxScreenSize = (Integer)Config.SERVER.maxScreenSize.get();
            maxVRAMSize = (Integer)Config.SERVER.maxVRAMSize.get();
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public ForgeConfigSpec.IntValue maxScreenSize;
        public ForgeConfigSpec.IntValue maxVRAMSize;

        private Server(ForgeConfigSpec.Builder builder) {
            this.maxScreenSize = builder.comment("Max Screen Size").translation("config.toms_peripherals.maxScreenSize").defineInRange("maxScreenSize", 16, 1, 64);
            this.maxVRAMSize = builder.comment("Maximum VRAM Size in GPU peripherals").translation("config.toms_peripherals.maxVRAMSize").defineInRange("maxVRAMSize", 0x1000000, 16384, Integer.MAX_VALUE);
        }
    }

    public static class Common {
        public Common(ForgeConfigSpec.Builder builder) {
            builder.comment(new String[]{"IMPORTANT NOTICE:", "THIS IS ONLY THE COMMON CONFIG. It does not contain all the values adjustable for Tom's Peripherals", "The settings have been moved to toms-peripherals-server.toml", "That file is PER WORLD, meaning you have to go into 'saves/<world name>/serverconfig' to adjust it. Those changes will then only apply for THAT WORLD.", "You can then take that config file and put it in the 'defaultconfigs' folder to make it apply automatically to all NEW worlds you generate FROM THERE ON.", "This may appear confusing to many of you, but it is a new sensible way to handle configuration, because the server configuration is synced when playing multiplayer."}).define("importantInfo", true);
        }
    }
}

