/*
 * Decompiled with CFR 0.152.
 */
package net.birchfolks.wetlands.entity.custom;

import net.birchfolks.wetlands.WetlandsSounds;
import net.birchfolks.wetlands.config.WetlandsConfig;
import net.birchfolks.wetlands.entity.WetlandsEntities;
import net.birchfolks.wetlands.entity.custom.AbstractGearGolemEntity;
import net.birchfolks.wetlands.entity.custom.GearGolem;
import net.birchfolks.wetlands.entity.custom.RustClump;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1427;
import net.minecraft.class_1613;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3213;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4836;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5398;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ElderGearGolem
extends AbstractGearGolemEntity
implements GeoEntity {
    private static final class_2940<Integer> SHOOT = class_2945.method_12791(ElderGearGolem.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> SLAM = class_2945.method_12791(ElderGearGolem.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> ISSHOOT = class_2945.method_12791(ElderGearGolem.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> ISSLAM = class_2945.method_12791(ElderGearGolem.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> INVUL_TIMER = class_2945.method_12791(ElderGearGolem.class, (class_2941)class_2943.field_13327);
    public static final int DEFAULT_INVUL_TIMER = 80;
    private final class_3213 bossBar;
    private final int DEFAULT_WAITING_BEFORE = 60;
    private final int DEFAULT_SHOOT = 70;
    private final int DEFAULT_SLAM = 70;
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public ElderGearGolem(class_1299<? extends class_1427> entityType, class_1937 world) {
        super(entityType, world);
        this.bossBar = (class_3213)new class_3213(this.method_5476(), class_1259.class_1260.field_5785, class_1259.class_1261.field_5791).method_5406(false);
        this.bossBar.method_14091(WetlandsConfig.enableGolemBossBar);
        this.method_49477(1.2f);
    }

    public boolean method_5973(class_1299<?> type) {
        if (type == class_1299.field_6097) {
            return true;
        }
        return type == class_1299.field_6046 ? false : super.method_5973(type);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new AttackGoal());
        this.field_6201.method_6277(5, (class_1352)new class_1379((class_1314)this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(2, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1657.class, 10, true, false, entity -> true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1613.class, 10, true, false, entity -> true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_4836.class, 10, true, false, entity -> true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, GearGolem.class, 10, true, false, entity -> true));
        this.field_6185.method_6277(5, (class_1352)new class_5398((class_1308)this, true));
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 200.0).method_26868(class_5134.field_23719, 0.2).method_26868(class_5134.field_23718, 1.0).method_26868(class_5134.field_23717, 64.0).method_26868(class_5134.field_23721, 15.0);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller1", 0, this::predicate1)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getState() == AbstractGearGolemEntity.AnimState.getId(AbstractGearGolemEntity.AnimState.SPAWN)) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("spawn"));
            return PlayState.CONTINUE;
        }
        if (this.getState() == AbstractGearGolemEntity.AnimState.getId(AbstractGearGolemEntity.AnimState.SLAM)) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("slam"));
            return PlayState.CONTINUE;
        }
        if (this.getState() == AbstractGearGolemEntity.AnimState.getId(AbstractGearGolemEntity.AnimState.SHOOT)) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("shoot"));
            return PlayState.CONTINUE;
        }
        if (this.getState() == AbstractGearGolemEntity.AnimState.getId(AbstractGearGolemEntity.AnimState.STUN)) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("stun"));
        } else if (event.isMoving()) {
            if (this.method_6510()) {
                event.getController().setAnimation(RawAnimation.begin().thenLoop("walk"));
            } else {
                event.getController().setAnimation(RawAnimation.begin().thenLoop("walk"));
            }
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.CONTINUE;
    }

    private PlayState predicate1(AnimationState<ElderGearGolem> event) {
        if (this.getState() != AbstractGearGolemEntity.AnimState.getId(AbstractGearGolemEntity.AnimState.ATTACK)) {
            return PlayState.STOP;
        }
        event.getController().setAnimation(RawAnimation.begin().thenLoop("attack"));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public boolean method_6094() {
        return true;
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setInvulTimer(nbt.method_10550("Invul"));
        this.setShoot(nbt.method_10550("Shoot"));
        this.setSlam(nbt.method_10550("Slam"));
        this.setIsShoot(nbt.method_10577("IsShoot"));
        this.setIsSlam(nbt.method_10577("IsSlam"));
        this.method_29512(this.method_37908(), nbt);
        if (this.method_16914()) {
            this.bossBar.method_5413(this.method_5476());
        }
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Invul", this.getInvulnerableTimer());
        nbt.method_10569("Slam", this.getSlam());
        nbt.method_10569("Shoot", this.getShoot());
        nbt.method_10556("IsShoot", this.isShoot());
        nbt.method_10556("IsSlam", this.isSlam());
        this.method_29517(nbt);
    }

    public boolean isSlam() {
        return (Boolean)this.field_6011.method_12789(ISSLAM);
    }

    public void setIsSlam(boolean slam) {
        this.field_6011.method_12778(ISSLAM, (Object)slam);
    }

    public boolean isShoot() {
        return (Boolean)this.field_6011.method_12789(ISSHOOT);
    }

    public void setIsShoot(boolean shooting) {
        this.field_6011.method_12778(ISSHOOT, (Object)shooting);
    }

    public int getShoot() {
        return (Integer)this.field_6011.method_12789(SHOOT);
    }

    public void setShoot(int shoot) {
        this.field_6011.method_12778(SHOOT, (Object)shoot);
    }

    public int getSlam() {
        return (Integer)this.field_6011.method_12789(SLAM);
    }

    public void setSlam(int slam) {
        this.field_6011.method_12778(SLAM, (Object)slam);
    }

    @Override
    public boolean afterStunEffect() {
        return true;
    }

    protected float method_6120() {
        return 0.5f;
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SHOOT, (Object)0);
        this.field_6011.method_12784(SLAM, (Object)0);
        this.field_6011.method_12784(INVUL_TIMER, (Object)0);
        this.field_6011.method_12784(ISSHOOT, (Object)false);
        this.field_6011.method_12784(ISSLAM, (Object)false);
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (this.getInvulnerableTimer() > 0) {
            return false;
        }
        if (source.method_5526() instanceof GearGolem) {
            return super.method_5643(source, amount * 0.5f);
        }
        return super.method_5643(source, amount);
    }

    public static double getY(class_243 pos, double delta, double vel) {
        double x = delta;
        double y = pos.method_10216() + delta;
        double z = delta;
        double y0 = pos.field_1351 + 0.5;
        double g = 5.5;
        double v = vel * 10.0;
        double res = y0 - g * x * z / (2.0 * v * v);
        return res;
    }

    public int getInvulnerableTimer() {
        return (Integer)this.field_6011.method_12789(INVUL_TIMER);
    }

    public void setInvulTimer(int ticks) {
        this.field_6011.method_12778(INVUL_TIMER, (Object)ticks);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.getInvulnerableTimer() > 0) {
            this.spawnInitParticles();
            int invul = this.getInvulnerableTimer() - 1;
            if (invul > 0) {
                this.setState(AbstractGearGolemEntity.AnimState.getId(AbstractGearGolemEntity.AnimState.SPAWN));
            } else {
                this.setState(AbstractGearGolemEntity.AnimState.getId(AbstractGearGolemEntity.AnimState.NONE));
            }
            this.setInvulTimer(invul);
            if (invul == 15) {
                this.damageTargets(5.0f);
                this.spawnHitParticles(0.0);
                this.method_5783(class_3417.field_21076, 1.2f, 0.1f);
            }
        } else if (!this.method_37908().method_8608()) {
            if (this.getState() != AbstractGearGolemEntity.AnimState.getId(AbstractGearGolemEntity.AnimState.STUN)) {
                if (this.method_5968() != null) {
                    if (this.getState() == AbstractGearGolemEntity.AnimState.getId(AbstractGearGolemEntity.AnimState.SLAM)) {
                        this.setIsShoot(false);
                        this.setShoot(0);
                        this.setSlam(this.getSlam() + 1);
                        if (this.getSlam() == 20) {
                            this.damageTargets(5.0f);
                            this.method_5783(class_3417.field_21076, 1.2f, 0.1f);
                        }
                        if (this.getSlam() == 34) {
                            this.damageTargets(5.0f);
                            this.method_5783(class_3417.field_21076, 1.2f, 0.1f);
                        }
                        if (this.getSlam() == 47) {
                            this.damageTargets(5.0f);
                            this.method_5783(class_3417.field_21076, 1.2f, 0.1f);
                        }
                        if (this.getSlam() >= 70) {
                            this.setSlam(0);
                            this.setState(AbstractGearGolemEntity.AnimState.getId(AbstractGearGolemEntity.AnimState.NONE));
                        }
                    }
                    if (this.isShoot()) {
                        double m;
                        this.setShoot(this.getShoot() + 1);
                        this.method_5988().method_6226((class_1297)this.method_5968(), 360.0f, 360.0f);
                        double g = (double)(this.field_6283 * ((float)Math.PI / 180)) + Math.cos((float)this.field_6012 * 0.6662f) * 0.25;
                        double g1 = (double)(this.field_6283 * ((float)Math.PI / 180)) + 1.5707963267948966;
                        double h = Math.cos(g);
                        double i = Math.sin(g);
                        double vel = 0.5;
                        if (this.getShoot() == 20) {
                            this.method_37908().method_45445((class_1297)this, this.method_24515(), WetlandsSounds.RUST_CANNON_SHOOT, class_3419.field_15250, 0.6f, 0.5f);
                        }
                        if (this.getShoot() == 25) {
                            this.method_37908().method_45445((class_1297)this, this.method_24515(), WetlandsSounds.RUST_CANNON_SHOOT, class_3419.field_15250, 0.6f, 0.5f);
                        }
                        if (this.getShoot() == 50) {
                            m = Math.sqrt(this.method_47922(this.method_5968())) / 7.0;
                            RustClump clump = new RustClump(WetlandsEntities.RUST_CLUMP, this.method_37908());
                            clump.method_18800(vel * Math.cos(g1 - this.method_5968().method_18798().method_10216()) * m, vel * 0.3 * m, vel * Math.sin(g1 - this.method_5968().method_18798().method_10215()) * m);
                            clump.method_23327(this.method_19538().method_10216() + h * 0.4 + Math.cos(g1) * 2.0, this.method_19538().method_10214() + 2.6, this.method_19538().method_10215() + i * 0.4 + Math.sin(g1) * 2.0);
                            this.method_37908().method_8649((class_1297)clump);
                        }
                        if (this.getShoot() == 55) {
                            m = Math.sqrt(this.method_47922(this.method_5968())) / 7.0;
                            RustClump clump1 = new RustClump(WetlandsEntities.RUST_CLUMP, this.method_37908());
                            clump1.method_18800(vel * Math.cos(g1 - this.method_5968().method_18798().method_10216()) * m, vel * 0.3 * m, vel * Math.sin(g1 - this.method_5968().method_18798().method_10215()) * m);
                            clump1.method_23327(this.method_19538().method_10216() - h * 0.4 + Math.cos(g1) * 2.0, this.method_19538().method_10214() + 2.6, this.method_19538().method_10215() - i * 0.4 + Math.sin(g1) * 2.0);
                            this.method_37908().method_8649((class_1297)clump1);
                        }
                        if (this.getShoot() >= 70) {
                            this.setIsShoot(false);
                            this.setShoot(0);
                            this.setState(AbstractGearGolemEntity.AnimState.getId(AbstractGearGolemEntity.AnimState.NONE));
                        }
                    } else {
                        if (this.method_5858((class_1297)this.method_5968()) >= 12.0) {
                            this.setShoot(this.getShoot() + 1);
                        }
                        if (this.getShoot() >= 60) {
                            this.setIsShoot(true);
                            this.setShoot(0);
                            this.setState(AbstractGearGolemEntity.AnimState.getId(AbstractGearGolemEntity.AnimState.SHOOT));
                            this.method_5988().method_6226((class_1297)this.method_5968(), 180.0f, 180.0f);
                        }
                    }
                } else if (this.getState() == AbstractGearGolemEntity.AnimState.getId(AbstractGearGolemEntity.AnimState.SHOOT) || this.getState() == AbstractGearGolemEntity.AnimState.getId(AbstractGearGolemEntity.AnimState.SLAM) && this.getSlam() <= 0) {
                    this.setState(AbstractGearGolemEntity.AnimState.getId(AbstractGearGolemEntity.AnimState.NONE));
                }
            }
            this.bossBar.method_5408(this.method_6032() / this.method_6063());
        } else if (this.getState() == AbstractGearGolemEntity.AnimState.getId(AbstractGearGolemEntity.AnimState.SLAM)) {
            if (this.getSlam() == 20) {
                this.spawnHitParticles(0.0);
            }
            if (this.getSlam() == 34) {
                this.spawnHitParticles(0.6283185307179586);
            }
            if (this.getSlam() == 47) {
                this.spawnHitParticles(-0.6283185307179586);
            }
        }
    }

    public void onSummoned() {
        this.bossBar.method_5408(0.0f);
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        this.bossBar.method_14088(player);
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        this.bossBar.method_14089(player);
    }

    private class AttackGoal
    extends class_1366 {
        private final ElderGearGolem entity;

        public AttackGoal() {
            super((class_1314)ElderGearGolem.this, 1.0, true);
            this.entity = ElderGearGolem.this;
        }

        public void method_6269() {
            super.method_6269();
        }

        public boolean method_6264() {
            return super.method_6264();
        }

        protected void method_6288(class_1309 p_29589_, double p_29590_) {
            if (!AbstractGearGolemEntity.AnimState.stopAI(ElderGearGolem.this.getState()) && ElderGearGolem.this.getState() != AbstractGearGolemEntity.AnimState.getId(AbstractGearGolemEntity.AnimState.SHOOT)) {
                super.method_6288(p_29589_, p_29590_);
                double d = this.method_6289(p_29589_);
                if (p_29590_ <= d && this.method_28347()) {
                    this.method_28346();
                    boolean bl = this.field_6503.method_6121((class_1297)p_29589_);
                    if (bl) {
                        ElderGearGolem.this.setShoot(0);
                    }
                } else if (p_29590_ <= d * 3.0) {
                    if (this.method_28347()) {
                        this.method_28346();
                    }
                    if (this.method_28348() <= 5) {
                        ElderGearGolem.this.setState(AbstractGearGolemEntity.AnimState.getId(AbstractGearGolemEntity.AnimState.ATTACK));
                    }
                } else {
                    this.method_28346();
                    ElderGearGolem.this.setState(AbstractGearGolemEntity.AnimState.getId(AbstractGearGolemEntity.AnimState.NONE));
                }
            }
        }

        protected double method_6289(class_1309 entity) {
            return 4.0f + entity.method_17681();
        }

        public void method_6270() {
            super.method_6270();
            if (AbstractGearGolemEntity.AnimState.from(ElderGearGolem.this.getState()) == AbstractGearGolemEntity.AnimState.ATTACK) {
                ElderGearGolem.this.setState(AbstractGearGolemEntity.AnimState.getId(AbstractGearGolemEntity.AnimState.NONE));
            }
        }

        public void method_6268() {
            super.method_6268();
            if (this.entity.method_5968() != null) {
                // empty if block
            }
        }
    }
}

