/*
 * Decompiled with CFR 0.152.
 */
package net.birchfolks.wetlands.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_3505;
import net.minecraft.class_5321;
import net.minecraft.class_6880;

public class WetlandsConfig {
    private static Path configFilePath;
    private static Gson gson;
    public static List<String> biomes;
    public static boolean enableGolemBossBar;
    public static final ThreadLocal<Map<class_5321<?>, Map<class_2960, Collection<class_6880<?>>>>> LOADED_TAGS;

    public static void setTags(List<class_3505.class_6863<?>> tags) {
        HashMap<class_5321, Map> tagMap = new HashMap<class_5321, Map>();
        for (class_3505.class_6863<?> rTags : tags) {
            tagMap.put(rTags.comp_328(), rTags.comp_329());
            System.out.println(rTags.comp_329());
        }
        LOADED_TAGS.set(tagMap);
    }

    public static void setDefaulBiomes() {
        biomes = new ArrayList<String>();
        biomes.add("minecraft:swamp");
        biomes.add("minecraft:mangrove_swamp");
    }

    public static void load() {
        biomes.add("minecraft:swamp");
        biomes.add("minecraft:mangrove_swamp");
        if (WetlandsConfig.getFilePath().toFile().exists()) {
            try {
                BufferedReader reader = Files.newBufferedReader(WetlandsConfig.getFilePath());
                Data data = (Data)gson.fromJson((Reader)reader, Data.class);
                if (data.common.biomes != null) {
                    biomes = data.common.biomes;
                } else {
                    WetlandsConfig.setDefaulBiomes();
                }
                enableGolemBossBar = data.common.enableGolemBossBar;
                ((Reader)reader).close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (biomes.isEmpty()) {
            WetlandsConfig.setDefaulBiomes();
        }
        WetlandsConfig.save();
    }

    public static void save() {
        try {
            BufferedWriter writer = Files.newBufferedWriter(WetlandsConfig.getFilePath(), new OpenOption[0]);
            Data data = new Data(new Data.Common(biomes, enableGolemBossBar));
            gson.toJson((Object)data, (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Path getFilePath() {
        if (configFilePath == null) {
            configFilePath = FabricLoader.getInstance().getConfigDir().resolve("wetlands.json");
        }
        return configFilePath;
    }

    static {
        gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        biomes = new ArrayList<String>();
        enableGolemBossBar = true;
        LOADED_TAGS = new ThreadLocal();
    }

    private static class Data {
        private Common common;

        public Data(Common common) {
            this.common = common;
        }

        private static class Common {
            private boolean enableGolemBossBar = true;
            private List<String> biomes = new ArrayList<String>();

            private Common(List<String> biomes, boolean enableGolemBossBar) {
                this.biomes = biomes;
                this.enableGolemBossBar = enableGolemBossBar;
            }
        }
    }
}

