/*
 * Decompiled with CFR 0.152.
 */
package net.birchfolks.wetlands.block;

import net.birchfolks.wetlands.block.WetlandsBlocks;
import net.birchfolks.wetlands.item.WetlandsItems;
import net.birchfolks.wetlands.particles.WetlandsParticles;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class BrokenGearBlock
extends class_2318
implements class_3737 {
    public static final class_2753 FACING = class_2318.field_10927;
    public static final class_2746 ATTACHED = class_2741.field_12493;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    protected static final float field_31106 = 3.0f;
    protected static final class_265 EAST_SHAPE;
    protected static final class_265 WEST_SHAPE;
    protected static final class_265 SOUTH_SHAPE;
    protected static final class_265 NORTH_SHAPE;
    protected static final class_265 UP_SHAPE;
    protected static final class_265 DOWN_SHAPE;

    public BrokenGearBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11036)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)ATTACHED, (Comparable)Boolean.valueOf(false)));
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        switch ((class_2350)state.method_11654((class_2769)FACING)) {
            case field_11043: {
                return NORTH_SHAPE;
            }
            case field_11036: {
                return UP_SHAPE;
            }
            case field_11033: {
                return DOWN_SHAPE;
            }
            case field_11035: {
                return SOUTH_SHAPE;
            }
            case field_11039: {
                return WEST_SHAPE;
            }
        }
        return EAST_SHAPE;
    }

    public void method_19286(class_1937 world, class_2680 state, class_3965 hit, class_1676 projectile) {
        if (state.method_27852(WetlandsBlocks.BROKEN_GEAR_BLOCK_ACTIVE)) {
            BrokenGearBlock.trigger((class_1936)world, state, hit, (class_1297)projectile);
        }
    }

    private static int trigger(class_1936 world, class_2680 state, class_3965 hitResult, class_1297 entity) {
        int j;
        int i = BrokenGearBlock.calculatePower(hitResult, hitResult.method_17784());
        int n = j = entity instanceof class_1665 ? 20 : 8;
        if (i > 12 && !world.method_8397().method_8674(hitResult.method_17777(), (Object)state.method_26204())) {
            world.method_8652(hitResult.method_17777(), WetlandsBlocks.BROKEN_GEAR_BLOCK.method_34725(state), 3);
            world.method_8396((class_1657)null, hitResult.method_17777(), class_3417.field_15081, class_3419.field_15245, 1.0f, 1.0f);
            class_2350 dir = hitResult.method_17780();
            for (int b = 0; b < 5; ++b) {
                world.method_8406((class_2394)WetlandsParticles.WISP_PARTICLES, hitResult.method_17784().method_10216() + world.method_8409().method_43058() * (double)0.1f, hitResult.method_17784().method_10214() + world.method_8409().method_43058() * (double)0.1f, hitResult.method_17784().method_10215() + world.method_8409().method_43058() * (double)0.1f, world.method_8409().method_43058() * 0.25 * (double)dir.method_10163().method_10263(), (double)(-0.08f + 0.15f * (float)dir.method_10163().method_10264()), world.method_8409().method_43058() * 0.25 * (double)dir.method_10163().method_10260());
            }
        }
        return i;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return state.method_27852(WetlandsBlocks.BROKEN_GEAR_BLOCK_ACTIVE) ? 15 : 0;
    }

    private static int calculatePower(class_3965 hitResult, class_243 pos) {
        class_2350 direction = hitResult.method_17780();
        double d = Math.abs(class_3532.method_15385((double)pos.field_1352) - 0.5);
        double e = Math.abs(class_3532.method_15385((double)pos.field_1351) - 0.5);
        double f = Math.abs(class_3532.method_15385((double)pos.field_1350) - 0.5);
        class_2350.class_2351 axis = direction.method_10166();
        double g = axis == class_2350.class_2351.field_11052 ? Math.max(d, f) : (axis == class_2350.class_2351.field_11051 ? Math.max(d, e) : Math.max(e, f));
        return Math.max(1, class_3532.method_15384((double)(15.0 * class_3532.method_15350((double)((0.5 - g) / 0.5), (double)0.0, (double)1.0))));
    }

    private boolean canPlaceOn(class_1922 world, class_2338 pos, class_2350 side) {
        class_2680 blockState = world.method_8320(pos);
        return blockState.method_26206(world, pos, side);
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        return this.canPlaceOn((class_1922)world, pos.method_10093(direction.method_10153()), direction);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (direction.method_10153() == state.method_11654((class_2769)FACING) && !state.method_26184((class_4538)world, pos)) {
            return class_2246.field_10124.method_9564();
        }
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public boolean isRot(class_2338 pos) {
        return (pos.method_10263() + pos.method_10260() + pos.method_10264()) % 2 == 0;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (state.method_26204() != WetlandsBlocks.BROKEN_GEAR_BLOCK_ACTIVE && player.method_5998(hand).method_31574(WetlandsItems.BOTTLED_WISP)) {
            if (!player.method_7337()) {
                player.method_6122(hand, new class_1799((class_1935)class_1802.field_8469, 1));
            }
            world.method_8652(pos, WetlandsBlocks.BROKEN_GEAR_BLOCK_ACTIVE.method_34725(state), 3);
            return class_1269.field_5812;
        }
        return super.method_9534(state, world, pos, player, hand, hit);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 blockState;
        if (!ctx.method_7717() && (blockState = ctx.method_8045().method_8320(ctx.method_8037().method_10093(ctx.method_8038().method_10153()))).method_27852((class_2248)this) && blockState.method_11654((class_2769)FACING) == ctx.method_8038()) {
            return null;
        }
        blockState = this.method_9564();
        class_1937 worldView = ctx.method_8045();
        class_2338 blockPos = ctx.method_8037();
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        for (class_2350 direction : ctx.method_7718()) {
            if (!(blockState = (class_2680)blockState.method_11657((class_2769)FACING, (Comparable)direction.method_10153())).method_26184((class_4538)worldView, blockPos)) continue;
            return (class_2680)((class_2680)blockState.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910))).method_11657((class_2769)ATTACHED, (Comparable)Boolean.valueOf(this.isRot(ctx.method_8037())));
        }
        return null;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, WATERLOGGED, ATTACHED});
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    static {
        UP_SHAPE = class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);
        DOWN_SHAPE = class_2248.method_9541((double)2.0, (double)14.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
        EAST_SHAPE = class_2248.method_9541((double)0.0, (double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0);
        WEST_SHAPE = class_2248.method_9541((double)14.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
        SOUTH_SHAPE = class_2248.method_9541((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)2.0);
        NORTH_SHAPE = class_2248.method_9541((double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0, (double)16.0);
    }
}

