/*
 * Decompiled with CFR 0.152.
 */
package net.birchfolks.wetlands.api;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.birchfolks.wetlands.block.WetlandsBlocks;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2778;
import org.joml.Vector3f;

public class WetlandsAPI {
    public static HashMap<class_2248, class_2248> EXTINGUISHABLE_BLOCKS = new HashMap();
    private static final List<class_2248> CopperBlocks = Arrays.asList(class_2246.field_27119, class_2246.field_27118, class_2246.field_27117, class_2246.field_27116);
    private static final List<class_2248> CutCopperBlocks = Arrays.asList(class_2246.field_27124, class_2246.field_27123, class_2246.field_27122, class_2246.field_27121);
    private static final List<class_2248> CutCopperBlockSlabs = Arrays.asList(class_2246.field_27132, class_2246.field_27131, class_2246.field_27130, class_2246.field_27129);
    private static final List<class_2248> CutCopperBlockStairs = Arrays.asList(class_2246.field_27128, class_2246.field_27127, class_2246.field_27126, class_2246.field_27125);

    public static void registerAPI() {
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_27099, class_2246.field_27099);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_27100, class_2246.field_27100);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_27101, class_2246.field_27101);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_27102, class_2246.field_27102);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_27103, class_2246.field_27103);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_27104, class_2246.field_27104);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_27105, class_2246.field_27105);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_27106, class_2246.field_27106);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_27107, class_2246.field_27107);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_27108, class_2246.field_27108);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_27109, class_2246.field_27109);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_27110, class_2246.field_27110);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_27111, class_2246.field_27111);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_27112, class_2246.field_27112);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_27113, class_2246.field_27113);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_27140, class_2246.field_27140);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_27141, class_2246.field_27141);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_27142, class_2246.field_27142);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_27143, class_2246.field_27143);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_27144, class_2246.field_27144);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_27145, class_2246.field_27145);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_27146, class_2246.field_27146);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_27147, class_2246.field_27147);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_27148, class_2246.field_27148);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_27149, class_2246.field_27149);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_27150, class_2246.field_27150);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_27151, class_2246.field_27151);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_27152, class_2246.field_27152);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_27153, class_2246.field_27153);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_27154, class_2246.field_27154);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_27155, class_2246.field_27155);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_27156, class_2246.field_27156);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_27157, class_2246.field_27157);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_27158, class_2246.field_27158);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_17350, class_2246.field_17350);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_23860, class_2246.field_23860);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_10036, class_2246.field_10124);
        EXTINGUISHABLE_BLOCKS.put(class_2246.field_22089, class_2246.field_10124);
    }

    public static void setFumeFrom(class_1937 world, class_2338 pos, class_2350 dir, class_2394 particle, double power, double spray) {
        Vector3f vec = dir.method_23955();
        for (int i = 0; i < 6; ++i) {
            world.method_8406(particle, (double)pos.method_10263() + 0.5 + 0.5 * (double)vec.x(), (double)pos.method_10264() + 0.5 + 0.5 * (double)vec.y(), (double)pos.method_10260() + 0.5 + 0.5 * (double)vec.z(), power * (double)i * (double)vec.x() + (world.field_9229.method_43058() * 2.0 * spray - spray), power * (double)i * (double)vec.y() + (world.field_9229.method_43058() * 2.0 * spray - spray), power * (double)i * (double)vec.z() + (world.field_9229.method_43058() * 2.0 * spray - spray));
        }
    }

    public static boolean isPlayerInMire(class_1657 player) {
        class_2338 pos = player.method_24515();
        class_1937 world = player.method_37908();
        return world.method_8320(new class_2338(pos.method_10263(), (int)player.method_23320(), pos.method_10260())).method_27852(WetlandsBlocks.MIRE_BLOCK);
    }

    public static float mireAlpha() {
        return 0.4f;
    }

    public static void setCondansate(class_1937 world, class_2338 pos, double spray) {
        world.method_8406((class_2394)class_2398.field_11232, (double)pos.method_10263() + 0.5 + (world.field_9229.method_43058() * 2.0 * spray - spray), (double)pos.method_10264() - 0.02, (double)pos.method_10260() + 0.5 + (world.field_9229.method_43058() * 2.0 * spray - spray), 0.0, 0.0, 0.0);
    }

    public static class_2338 getFrontBlockPos(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        class_2350 dir = (class_2350)state.method_11654((class_2769)class_2741.field_12525);
        Vector3f vec = dir.method_23955();
        return pos.method_10069((int)vec.x(), (int)vec.y(), (int)vec.z());
    }

    public static class_2338 getFrontBlockPos(class_1937 world, class_2338 pos, class_2350 dir) {
        class_2680 state = world.method_8320(pos);
        Vector3f vec = dir.method_23955();
        return pos.method_10069((int)vec.x(), (int)vec.y(), (int)vec.z());
    }

    public static boolean isExtinguishable(class_2248 block) {
        return EXTINGUISHABLE_BLOCKS.containsKey(block);
    }

    public static class_2680 getExtinguishable(class_2680 block) {
        if (WetlandsAPI.isExtinguishable(block.method_26204())) {
            if (EXTINGUISHABLE_BLOCKS.get(block.method_26204()) == class_2246.field_10124) {
                return class_2246.field_10124.method_9564();
            }
            return (class_2680)block.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(false));
        }
        return block;
    }

    private static class_2680 cloneStairsOf(class_2510 block, class_2680 state) {
        return (class_2680)((class_2680)((class_2680)((class_2680)block.method_9564().method_11657((class_2769)class_2510.field_11571, (Comparable)((class_2350)state.method_11654((class_2769)class_2510.field_11571)))).method_11657((class_2769)class_2510.field_11572, (Comparable)((class_2760)state.method_11654((class_2769)class_2510.field_11572)))).method_11657((class_2769)class_2510.field_11573, (Comparable)((Boolean)state.method_11654((class_2769)class_2510.field_11573)))).method_11657((class_2769)class_2510.field_11565, (Comparable)((class_2778)state.method_11654((class_2769)class_2510.field_11565)));
    }

    private static class_2680 cloneSlabOf(class_2482 block, class_2680 state) {
        return (class_2680)((class_2680)block.method_9564().method_11657((class_2769)class_2482.field_11502, (Comparable)((Boolean)state.method_11654((class_2769)class_2482.field_11502)))).method_11657((class_2769)class_2482.field_11501, (Comparable)((class_2771)state.method_11654((class_2769)class_2482.field_11501)));
    }

    private static class_2248 getBlockFromLevel(class_2248 block, int level) {
        if (level > 3 || level < 0) {
            return block;
        }
        if (CopperBlocks.contains(block)) {
            return CopperBlocks.get(Math.min(CopperBlocks.size() - 1, Math.max(0, CopperBlocks.indexOf(block) + level)));
        }
        if (CutCopperBlocks.contains(block)) {
            return CutCopperBlocks.get(Math.min(CutCopperBlocks.size() - 1, Math.max(0, CutCopperBlocks.indexOf(block) + level)));
        }
        if (CutCopperBlockSlabs.contains(block)) {
            return CutCopperBlockSlabs.get(Math.min(CutCopperBlockSlabs.size() - 1, Math.max(0, CutCopperBlockSlabs.indexOf(block) + level)));
        }
        if (CutCopperBlockStairs.contains(block)) {
            return CutCopperBlockStairs.get(Math.min(CutCopperBlockStairs.size() - 1, Math.max(0, CutCopperBlockStairs.indexOf(block) + level)));
        }
        return block;
    }

    private static boolean isCopper(class_2248 block) {
        return CopperBlocks.contains(block) || CutCopperBlocks.contains(block) || CutCopperBlockStairs.contains(block) || CutCopperBlockSlabs.contains(block);
    }

    private static class_2680 checkAndGetBlock(class_2680 state, int level) {
        class_2680 blockState = state;
        if (WetlandsAPI.isCopper(state.method_26204())) {
            blockState = state.method_26204() instanceof class_2482 ? WetlandsAPI.cloneSlabOf((class_2482)WetlandsAPI.getBlockFromLevel(state.method_26204(), level), state) : (state.method_26204() instanceof class_2510 ? WetlandsAPI.cloneStairsOf((class_2510)WetlandsAPI.getBlockFromLevel(state.method_26204(), level), state) : WetlandsAPI.getBlockFromLevel(state.method_26204(), level).method_9564());
            return blockState;
        }
        return blockState;
    }

    public static class_2680 getOxidizedBlock(class_2680 block, int oxidizeLevel) {
        if (oxidizeLevel < 0) {
            return block;
        }
        return WetlandsAPI.checkAndGetBlock(block, oxidizeLevel);
    }
}

