/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.registry;

import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_2960;
import net.minecraft.class_4081;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.satisfy.brewery.Brewery;
import net.satisfy.brewery.effect.BlackoutEffect;
import net.satisfy.brewery.effect.DrunkEffect;
import net.satisfy.brewery.effect.HaleyEffect;
import net.satisfy.brewery.effect.HarddrinkingEffect;
import net.satisfy.brewery.effect.HealingTouchEffect;
import net.satisfy.brewery.effect.PartystarterEffect;
import net.satisfy.brewery.effect.PintCharismaEffect;
import net.satisfy.brewery.effect.ProtectiveTouchEffect;
import net.satisfy.brewery.effect.RenewingTouchEffect;
import net.satisfy.brewery.effect.SaturatedEffect;
import net.satisfy.brewery.effect.SnowWhiteEffect;
import net.satisfy.brewery.effect.ToxicTouchEffect;
import net.satisfy.brewery.util.BreweryIdentifier;

public class MobEffectRegistry {
    private static final DeferredRegister<class_1291> MOB_EFFECTS = DeferredRegister.create((String)"brewery", (class_5321)class_7924.field_41208);
    private static final Registrar<class_1291> MOB_EFFECTS_REGISTRAR = MOB_EFFECTS.getRegistrar();
    public static final RegistrySupplier<class_1291> DRUNK = MobEffectRegistry.registerEffect("drunk", DrunkEffect::new);
    public static final RegistrySupplier<class_1291> BLACKOUT;
    public static final RegistrySupplier<class_1291> SATURATED;
    public static final RegistrySupplier<class_1291> RENEWINGTOUCH;
    public static final RegistrySupplier<class_1291> TOXICTOUCH;
    public static final RegistrySupplier<class_1291> HEALINGTOUCH;
    public static final RegistrySupplier<class_1291> PROTECTIVETOUCH;
    public static final RegistrySupplier<class_1291> HARDDRINKING;
    public static final RegistrySupplier<class_1291> PARTYSTARTER;
    public static final RegistrySupplier<class_1291> SNOWWHITE;
    public static final RegistrySupplier<class_1291> PINTCHARISMA;
    public static final RegistrySupplier<class_1291> HALEY;

    private static RegistrySupplier<class_1291> registerEffect(String name, Supplier<class_1291> effect) {
        if (Platform.isForge()) {
            return MOB_EFFECTS.register(name, effect);
        }
        return MOB_EFFECTS_REGISTRAR.register((class_2960)new BreweryIdentifier(name), effect);
    }

    public static void init() {
        Brewery.LOGGER.debug("Mob effects");
        MOB_EFFECTS.register();
    }

    static {
        HARDDRINKING = MobEffectRegistry.registerEffect("harddrinking", HarddrinkingEffect::new);
        BLACKOUT = MobEffectRegistry.registerEffect("blackout", () -> new BlackoutEffect().method_42126(() -> new class_1293.class_7247(22)));
        SATURATED = MobEffectRegistry.registerEffect("saturated", SaturatedEffect::new);
        TOXICTOUCH = MobEffectRegistry.registerEffect("toxictouch", () -> new ToxicTouchEffect(class_4081.field_18271, 9500817));
        RENEWINGTOUCH = MobEffectRegistry.registerEffect("renewingtouch", () -> new RenewingTouchEffect(class_4081.field_18271, 9500817));
        HEALINGTOUCH = MobEffectRegistry.registerEffect("healingtouch", () -> new HealingTouchEffect(class_4081.field_18271, 9500817));
        PROTECTIVETOUCH = MobEffectRegistry.registerEffect("protectivetouch", () -> new ProtectiveTouchEffect(class_4081.field_18271, 9500817));
        PARTYSTARTER = MobEffectRegistry.registerEffect("partystarter", () -> new PartystarterEffect(class_4081.field_18271, 9500817));
        SNOWWHITE = MobEffectRegistry.registerEffect("snowwhite", () -> new SnowWhiteEffect(class_4081.field_18271, 9500817));
        PINTCHARISMA = MobEffectRegistry.registerEffect("pintcharisma", () -> new PintCharismaEffect(class_4081.field_18271, 9500817));
        HALEY = MobEffectRegistry.registerEffect("haley", () -> new HaleyEffect(class_4081.field_18271, 9500817));
    }
}

