/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import java.util.Objects;
import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector4f;

public final class CelestialUniforms {
    private final float sunPathRotation;

    public CelestialUniforms(float f) {
        this.sunPathRotation = f;
    }

    public void addCelestialUniforms(UniformHolder uniformHolder) {
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "sunAngle", CelestialUniforms::getSunAngle).uniformTruncated3f(UniformUpdateFrequency.PER_FRAME, "sunPosition", this::getSunPosition).uniformTruncated3f(UniformUpdateFrequency.PER_FRAME, "moonPosition", this::getMoonPosition).uniform1f(UniformUpdateFrequency.PER_FRAME, "shadowAngle", CelestialUniforms::getShadowAngle).uniformTruncated3f(UniformUpdateFrequency.PER_FRAME, "shadowLightPosition", this::getShadowLightPosition).uniformTruncated3f(UniformUpdateFrequency.PER_FRAME, "upPosition", CelestialUniforms::getUpPosition);
    }

    public static float getSunAngle() {
        float f = CelestialUniforms.getSkyAngle();
        if (f < 0.75f) {
            return f + 0.25f;
        }
        return f - 0.75f;
    }

    private static float getShadowAngle() {
        float f = CelestialUniforms.getSunAngle();
        if (!CelestialUniforms.isDay()) {
            f -= 0.5f;
        }
        return f;
    }

    private Vector4f getSunPosition() {
        return this.getCelestialPosition(100.0f);
    }

    private Vector4f getMoonPosition() {
        return this.getCelestialPosition(-100.0f);
    }

    public Vector4f getShadowLightPosition() {
        return CelestialUniforms.isDay() ? this.getSunPosition() : this.getMoonPosition();
    }

    public Vector4f getShadowLightPositionInWorldSpace() {
        return CelestialUniforms.isDay() ? this.getCelestialPositionInWorldSpace(100.0f) : this.getCelestialPositionInWorldSpace(-100.0f);
    }

    private Vector4f getCelestialPositionInWorldSpace(float f) {
        Vector4f vector4f = new Vector4f(0.0f, f, 0.0f, 0.0f);
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.identity();
        matrix4f.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(-90.0f));
        matrix4f.rotate((Quaternionfc)class_7833.field_40718.rotationDegrees(this.sunPathRotation));
        matrix4f.rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(CelestialUniforms.getSkyAngle() * 360.0f));
        matrix4f.transform(vector4f);
        return vector4f;
    }

    private Vector4f getCelestialPosition(float f) {
        Vector4f vector4f = new Vector4f(0.0f, f, 0.0f, 0.0f);
        Matrix4f matrix4f = new Matrix4f((Matrix4fc)CapturedRenderingState.INSTANCE.getGbufferModelView());
        matrix4f.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(-90.0f));
        matrix4f.rotate((Quaternionfc)class_7833.field_40718.rotationDegrees(this.sunPathRotation));
        matrix4f.rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(CelestialUniforms.getSkyAngle() * 360.0f));
        vector4f = matrix4f.transform(vector4f);
        return vector4f;
    }

    private static Vector4f getUpPosition() {
        Vector4f vector4f = new Vector4f(0.0f, 100.0f, 0.0f, 0.0f);
        Matrix4f matrix4f = new Matrix4f((Matrix4fc)CapturedRenderingState.INSTANCE.getGbufferModelView());
        matrix4f.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(-90.0f));
        vector4f = matrix4f.transform(vector4f);
        return vector4f;
    }

    public static boolean isDay() {
        return (double)CelestialUniforms.getSunAngle() <= 0.5;
    }

    private static class_638 getWorld() {
        return Objects.requireNonNull(class_310.method_1551().field_1687);
    }

    private static float getSkyAngle() {
        return CelestialUniforms.getWorld().method_30274(CapturedRenderingState.INSTANCE.getTickDelta());
    }
}

