/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.texture.pbr;

import com.mojang.blaze3d.platform.TextureUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.coderbot.iris.Iris;
import net.coderbot.iris.mixin.texture.SpriteContentsAnimatedTextureAccessor;
import net.coderbot.iris.mixin.texture.SpriteContentsFrameInfoAccessor;
import net.coderbot.iris.mixin.texture.SpriteContentsTickerAccessor;
import net.coderbot.iris.texture.SpriteContentsExtension;
import net.coderbot.iris.texture.pbr.PBRAtlasHolder;
import net.coderbot.iris.texture.pbr.PBRDumpable;
import net.coderbot.iris.texture.pbr.PBRType;
import net.coderbot.iris.texture.pbr.TextureAtlasExtension;
import net.coderbot.iris.texture.pbr.loader.AtlasPBRLoader;
import net.coderbot.iris.texture.util.TextureManipulationUtil;
import net.minecraft.class_1044;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_7764;
import org.jetbrains.annotations.Nullable;

public class PBRAtlasTexture
extends class_1044
implements PBRDumpable {
    protected final class_1059 atlasTexture;
    protected final PBRType type;
    protected final class_2960 id;
    protected final Map<class_2960, AtlasPBRLoader.PBRTextureAtlasSprite> texturesByName = new HashMap<class_2960, AtlasPBRLoader.PBRTextureAtlasSprite>();
    protected final List<class_1058.class_7770> animatedTextures = new ArrayList<class_1058.class_7770>();
    protected int width;
    protected int height;
    protected int mipLevel;

    public PBRAtlasTexture(class_1059 class_10592, PBRType pBRType) {
        this.atlasTexture = class_10592;
        this.type = pBRType;
        this.id = new class_2960(class_10592.method_24106().method_12836(), class_10592.method_24106().method_12832().replace(".png", "") + pBRType.getSuffix() + ".png");
    }

    public PBRType getType() {
        return this.type;
    }

    public class_2960 getAtlasId() {
        return this.id;
    }

    public void addSprite(AtlasPBRLoader.PBRTextureAtlasSprite pBRTextureAtlasSprite) {
        this.texturesByName.put(pBRTextureAtlasSprite.method_45851().method_45816(), pBRTextureAtlasSprite);
    }

    @Nullable
    public AtlasPBRLoader.PBRTextureAtlasSprite getSprite(class_2960 class_29602) {
        return this.texturesByName.get(class_29602);
    }

    public void clear() {
        this.animatedTextures.forEach(class_1058.class_7770::close);
        this.texturesByName.clear();
        this.animatedTextures.clear();
    }

    public void upload(int n, int n2, int n3) {
        int n4 = this.method_4624();
        TextureUtil.prepareImage((int)n4, (int)n3, (int)n, (int)n2);
        TextureManipulationUtil.fillWithColor(n4, n3, this.type.getDefaultValue());
        this.width = n;
        this.height = n2;
        this.mipLevel = n3;
        for (AtlasPBRLoader.PBRTextureAtlasSprite pBRTextureAtlasSprite : this.texturesByName.values()) {
            try {
                this.uploadSprite(pBRTextureAtlasSprite);
            }
            catch (Throwable throwable) {
                class_128 class_1282 = class_128.method_560((Throwable)throwable, (String)"Stitching texture atlas");
                class_129 class_1292 = class_1282.method_562("Texture being stitched together");
                class_1292.method_578("Atlas path", (Object)this.id);
                class_1292.method_578("Sprite", (Object)pBRTextureAtlasSprite);
                throw new class_148(class_1282);
            }
        }
        PBRAtlasHolder pBRAtlasHolder = ((TextureAtlasExtension)this.atlasTexture).getOrCreatePBRHolder();
        switch (this.type) {
            case NORMAL: {
                pBRAtlasHolder.setNormalAtlas(this);
                break;
            }
            case SPECULAR: {
                pBRAtlasHolder.setSpecularAtlas(this);
            }
        }
    }

    public boolean tryUpload(int n, int n2, int n3) {
        try {
            this.upload(n, n2, n3);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    protected void uploadSprite(AtlasPBRLoader.PBRTextureAtlasSprite pBRTextureAtlasSprite) {
        class_1058.class_7770 class_77702 = pBRTextureAtlasSprite.method_33437();
        if (class_77702 != null) {
            this.animatedTextures.add(class_77702);
            class_7764.class_7765 class_77652 = ((SpriteContentsExtension)pBRTextureAtlasSprite.getBaseSprite().method_45851()).getCreatedTicker();
            class_7764.class_7765 class_77653 = ((SpriteContentsExtension)pBRTextureAtlasSprite.method_45851()).getCreatedTicker();
            if (class_77652 != null && class_77653 != null) {
                PBRAtlasTexture.syncAnimation(class_77652, class_77653);
                SpriteContentsTickerAccessor spriteContentsTickerAccessor = (SpriteContentsTickerAccessor)class_77653;
                SpriteContentsAnimatedTextureAccessor spriteContentsAnimatedTextureAccessor = (SpriteContentsAnimatedTextureAccessor)spriteContentsTickerAccessor.getAnimationInfo();
                spriteContentsAnimatedTextureAccessor.invokeUploadFrame(pBRTextureAtlasSprite.method_35806(), pBRTextureAtlasSprite.method_35807(), ((SpriteContentsFrameInfoAccessor)spriteContentsAnimatedTextureAccessor.getFrames().get(spriteContentsTickerAccessor.getFrame())).getIndex());
                return;
            }
        }
        pBRTextureAtlasSprite.method_4584();
    }

    public static void syncAnimation(class_7764.class_7765 class_77652, class_7764.class_7765 class_77653) {
        int n;
        int n2;
        SpriteContentsTickerAccessor spriteContentsTickerAccessor = (SpriteContentsTickerAccessor)class_77652;
        List<class_7764.class_5791> list = ((SpriteContentsAnimatedTextureAccessor)spriteContentsTickerAccessor.getAnimationInfo()).getFrames();
        int n3 = 0;
        for (int i = 0; i < spriteContentsTickerAccessor.getFrame(); ++i) {
            n3 += ((SpriteContentsFrameInfoAccessor)list.get(i)).getTime();
        }
        SpriteContentsTickerAccessor spriteContentsTickerAccessor2 = (SpriteContentsTickerAccessor)class_77653;
        List<class_7764.class_5791> list2 = ((SpriteContentsAnimatedTextureAccessor)spriteContentsTickerAccessor2.getAnimationInfo()).getFrames();
        int n4 = 0;
        int n5 = list2.size();
        for (n2 = 0; n2 < n5; ++n2) {
            n4 += ((SpriteContentsFrameInfoAccessor)list2.get(n2)).getTime();
        }
        n3 %= n4;
        n2 = 0;
        while (n3 >= (n = ((SpriteContentsFrameInfoAccessor)list2.get(n2)).getTime())) {
            ++n2;
            n3 -= n;
        }
        spriteContentsTickerAccessor2.setFrame(n2);
        spriteContentsTickerAccessor2.setSubFrame(n3 + spriteContentsTickerAccessor.getSubFrame());
    }

    public void cycleAnimationFrames() {
        this.method_23207();
        for (class_1058.class_7770 class_77702 : this.animatedTextures) {
            class_77702.method_45853();
        }
    }

    public void close() {
        PBRAtlasHolder pBRAtlasHolder = ((TextureAtlasExtension)this.atlasTexture).getPBRHolder();
        if (pBRAtlasHolder != null) {
            switch (this.type) {
                case NORMAL: {
                    pBRAtlasHolder.setNormalAtlas(null);
                    break;
                }
                case SPECULAR: {
                    pBRAtlasHolder.setSpecularAtlas(null);
                }
            }
        }
        this.clear();
    }

    public void method_4625(class_3300 class_33002) {
    }

    public void method_49712(class_2960 class_29602, Path path) throws IOException {
        String string = class_29602.method_36181();
        TextureUtil.writeAsPNG((Path)path, (String)string, (int)this.method_4624(), (int)this.mipLevel, (int)this.width, (int)this.height);
        PBRAtlasTexture.dumpSpriteNames(path, string, this.texturesByName);
    }

    protected static void dumpSpriteNames(Path path, String string, Map<class_2960, AtlasPBRLoader.PBRTextureAtlasSprite> map) {
        Path path2 = path.resolve(string + ".txt");
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path2, new OpenOption[0]);){
            for (Map.Entry entry : map.entrySet().stream().sorted(Map.Entry.comparingByKey()).toList()) {
                AtlasPBRLoader.PBRTextureAtlasSprite pBRTextureAtlasSprite = (AtlasPBRLoader.PBRTextureAtlasSprite)((Object)entry.getValue());
                bufferedWriter.write(String.format(Locale.ROOT, "%s\tx=%d\ty=%d\tw=%d\th=%d%n", entry.getKey(), pBRTextureAtlasSprite.method_35806(), pBRTextureAtlasSprite.method_35807(), pBRTextureAtlasSprite.method_45851().method_45807(), pBRTextureAtlasSprite.method_45851().method_45815()));
            }
        }
        catch (IOException iOException) {
            Iris.logger.warn("Failed to write file {}", path2, iOException);
        }
    }

    @Override
    public class_2960 getDefaultDumpLocation() {
        return this.id;
    }
}

