/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.epherolib.networking;

import com.epherical.epherolib.networking.AbstractNetworking;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class FabricNetworking
extends AbstractNetworking<ClientPlayNetworking.PlayChannelHandler, ServerPlayNetworking.PlayChannelHandler> {
    private boolean client;
    private class_2960 modChannel;
    private final Int2ObjectArrayMap<PacketWrapper<?, ?>> indices;
    private final Object2ObjectArrayMap<Class<?>, PacketWrapper<?, ?>> classToResponseMap;

    public FabricNetworking(class_2960 modChannel, boolean client) {
        this.modChannel = modChannel;
        this.client = client;
        this.indices = new Int2ObjectArrayMap();
        this.classToResponseMap = new Object2ObjectArrayMap();
        this.registerDecode();
    }

    private <T> void registerDecode() {
        if (this.client) {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)this.modChannel, (client1, handler, buf, responseSender) -> {
                PacketWrapper packetWrapper = (PacketWrapper)this.indices.get(buf.method_10816());
                Object apply = packetWrapper.decoder.apply(buf);
                packetWrapper.consumer.accept(apply, new AbstractNetworking.Context(AbstractNetworking.Side.CLIENT, null));
            });
        }
        ServerPlayNetworking.registerGlobalReceiver((class_2960)this.modChannel, (server, player, handler, buf, responseSender) -> {
            PacketWrapper packetWrapper = (PacketWrapper)this.indices.get(buf.method_10816());
            Object apply = packetWrapper.decoder.apply(buf);
            packetWrapper.consumer.accept(apply, new AbstractNetworking.Context(AbstractNetworking.Side.SERVER, player));
        });
    }

    @Override
    public <T> void registerServerToClient(int id, Class<T> type, BiConsumer<T, class_2540> encoder, Function<class_2540, T> decoder, BiConsumer<T, AbstractNetworking.Context<ClientPlayNetworking.PlayChannelHandler>> consumer) {
        this.classToResponseMap.put(type, new PacketWrapper<T, ClientPlayNetworking.PlayChannelHandler>(id, encoder, decoder, consumer));
    }

    @Override
    public <T> void registerClientToServer(int id, Class<T> type, BiConsumer<T, class_2540> encoder, Function<class_2540, T> decoder, BiConsumer<T, AbstractNetworking.Context<ServerPlayNetworking.PlayChannelHandler>> consumer) {
        this.classToResponseMap.put(type, new PacketWrapper<T, ServerPlayNetworking.PlayChannelHandler>(id, encoder, decoder, consumer));
    }

    @Override
    public <T> void sendToClient(T type, class_3222 serverPlayer) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        this.assemblePacket(type, buf);
        ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)this.modChannel, (class_2540)buf);
    }

    @Override
    public <T> void sendToServer(T type) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        this.assemblePacket(type, buf);
        ClientPlayNetworking.send((class_2960)this.modChannel, (class_2540)buf);
    }

    private <T> void assemblePacket(T type, class_2540 buf) {
        PacketWrapper packetWrapper = (PacketWrapper)this.classToResponseMap.get(type.getClass());
        if (packetWrapper == null) {
            System.out.println("NULL MESSAGE, NOT REGISTERED WOOPSIES");
            throw new IllegalArgumentException();
        }
        buf.method_10804(packetWrapper.id);
        packetWrapper.encoder.accept(type, buf);
    }

    private class PacketWrapper<T, CON> {
        private int id;
        private BiConsumer<T, AbstractNetworking.Context<CON>> consumer;
        private BiConsumer<T, class_2540> encoder;
        private Function<class_2540, T> decoder;

        public PacketWrapper(int id, BiConsumer<T, class_2540> encoder, Function<class_2540, T> decoder, BiConsumer<T, AbstractNetworking.Context<CON>> consumer) {
            this.encoder = encoder;
            this.decoder = decoder;
            this.consumer = consumer;
            this.id = id;
            FabricNetworking.this.indices.put(id, (Object)this);
        }
    }
}

