/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import dev.itsmeow.whisperwoods.particle.WispParticleData;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;

public class WispAttackPacket {
    public Vec3 fromPos;
    public int color;

    public WispAttackPacket(Vec3 fromPos, int color) {
        this.fromPos = fromPos;
        this.color = color;
    }

    public static void encode(WispAttackPacket pkt, FriendlyByteBuf buf) {
        buf.writeDouble(pkt.fromPos.m_7096_());
        buf.writeDouble(pkt.fromPos.m_7098_());
        buf.writeDouble(pkt.fromPos.m_7094_());
        buf.writeInt(pkt.color);
    }

    public static WispAttackPacket decode(FriendlyByteBuf buf) {
        return new WispAttackPacket(new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble()), buf.readInt());
    }

    public static void handle(WispAttackPacket msg, Supplier<NetworkManager.PacketContext> ctx) {
        if (ctx.get().getEnvironment() == Env.CLIENT) {
            ctx.get().queue(() -> {
                if (Minecraft.m_91087_().f_91073_ != null && msg != null) {
                    Vec3 pos = msg.fromPos;
                    int color = msg.color;
                    float r = color >> 16 & 0xFF;
                    float g = color >> 8 & 0xFF;
                    float b = color & 0xFF;
                    LocalPlayer player = Minecraft.m_91087_().f_91074_;
                    if (player != null) {
                        Vec3 destPos = player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0);
                        double stops = Math.round(3.0 * pos.m_82554_(destPos));
                        double dirX = (destPos.m_7096_() - pos.m_7096_()) / stops;
                        double dirY = (destPos.m_7098_() - pos.m_7098_()) / stops;
                        double dirZ = (destPos.m_7094_() - pos.m_7094_()) / stops;
                        Vec3 dir = new Vec3(dirX, dirY, dirZ);
                        for (double i = 1.0; i <= stops; i += 1.0) {
                            Vec3 posOff = dir.m_82490_(i).m_82549_(pos);
                            double sin = Math.sin(i / stops * (Math.PI * 2)) / 4.0;
                            double cos = Math.cos(i / stops * (Math.PI * 2)) / 4.0;
                            player.m_9236_().m_7106_((ParticleOptions)new WispParticleData(r, g, b, 0.5f), posOff.m_7096_() + sin, posOff.m_7098_() + sin, posOff.m_7094_() - cos, 0.0, 0.0, 0.0);
                        }
                    }
                }
            });
        }
    }
}

