/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import dev.itsmeow.whisperwoods.particle.WispParticleData;
import dev.itsmeow.whisperwoods.util.TaskQueue;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import org.joml.Vector3f;

public class HOFEffectPacket {
    public HOFEffectType type;
    public Vector3f pos;
    public int color;

    public HOFEffectPacket(HOFEffectType type, Vector3f pos, int color) {
        this.type = type;
        this.pos = pos;
        this.color = color;
    }

    public static void encode(HOFEffectPacket pkt, FriendlyByteBuf buf) {
        buf.writeInt(pkt.type.ordinal());
        buf.writeFloat(pkt.pos.x());
        buf.writeFloat(pkt.pos.y());
        buf.writeFloat(pkt.pos.z());
        buf.writeInt(pkt.color);
    }

    public static HOFEffectPacket decode(FriendlyByteBuf buf) {
        int i = buf.readInt();
        if (i < 0 || i >= HOFEffectType.values().length) {
            return null;
        }
        return new HOFEffectPacket(HOFEffectType.values()[i], new Vector3f(buf.readFloat(), buf.readFloat(), buf.readFloat()), buf.readInt());
    }

    public static void handle(HOFEffectPacket msg, Supplier<NetworkManager.PacketContext> ctx) {
        if (ctx.get().getEnvironment() == Env.CLIENT) {
            ctx.get().queue(() -> {
                if (Minecraft.m_91087_().f_91073_ != null && msg != null) {
                    HOFEffectType type = msg.type;
                    Vector3f pos = msg.pos;
                    int color = msg.color;
                    float r = color >> 16 & 0xFF;
                    float g = color >> 8 & 0xFF;
                    float b = color & 0xFF;
                    int amt = 90;
                    float angle = 4.0f;
                    float speed = 0.5f;
                    WispParticleData data = new WispParticleData(r, g, b, 1.0f);
                    for (int i = 0; i < 90; ++i) {
                        float pAngle = (float)Math.toRadians(4.0f * (float)i);
                        Minecraft.m_91087_().f_91073_.m_7106_((ParticleOptions)data, (double)pos.x(), (double)pos.y(), (double)pos.z(), 0.5 * Math.cos(pAngle), 0.0, 0.5 * Math.sin(pAngle));
                    }
                    if (type == HOFEffectType.HIRSCHGEIST) {
                        TaskQueue.QUEUE_CLIENT.schedule(21, () -> {
                            for (int i = 0; i < 90; ++i) {
                                float pAngle = (float)Math.toRadians(4.0f * (float)i);
                                Minecraft.m_91087_().f_91073_.m_7106_((ParticleOptions)data, (double)pos.x() + 8.0 * Math.cos(pAngle), (double)pos.y(), (double)pos.z() + 8.0 * Math.sin(pAngle), -0.5 * Math.cos(pAngle), 0.0, -0.5 * Math.sin(pAngle));
                            }
                            TaskQueue.QUEUE_CLIENT.schedule(25, () -> {
                                Minecraft.m_91087_().f_91073_.m_7785_((double)pos.x(), (double)pos.y(), (double)pos.z(), SoundEvents.f_12363_, SoundSource.BLOCKS, 1.0f, 0.25f, false);
                                WispParticleData data2 = new WispParticleData(r, g, b, 0.25f);
                                for (int i = 0; i < 500; ++i) {
                                    float xOff = (float)((Math.random() - 0.5) * 5.0);
                                    float yOff = (float)(Math.random() * 2.5);
                                    float zOff = (float)((Math.random() - 0.5) * 5.0);
                                    Minecraft.m_91087_().f_91073_.m_7106_((ParticleOptions)data2, (double)(pos.x() + xOff), Math.floor(pos.y()) - 1.0 + (double)yOff, (double)(pos.z() + zOff), (double)(xOff / 16.0f), (double)(yOff / 16.0f), (double)(zOff / 16.0f));
                                }
                            });
                        });
                    }
                }
            });
        }
    }

    public static enum HOFEffectType {
        CIRCLE,
        HIRSCHGEIST;

    }
}

