/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.item;

import dev.architectury.platform.Platform;
import dev.itsmeow.whisperwoods.client.renderer.tile.model.ModelHGSkullMask;
import dev.itsmeow.whisperwoods.item.ItemBlockModeledArmor;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemBlockHirschgeistSkull
extends ItemBlockModeledArmor {
    public ItemBlockHirschgeistSkull(Block blockIn) {
        super(blockIn, HGArmorMaterial.get(), ArmorItem.Type.HELMET, new Item.Properties());
        this.addToBlockToItemMap(Item.f_41373_, (Item)this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected <A extends HumanoidModel<?>> A getBaseModelInstance() {
        if (ModelHGSkullMask.INSTANCE == null) {
            ModelHGSkullMask.INSTANCE = new ModelHGSkullMask(new EntityRendererProvider.Context(Minecraft.m_91087_().m_91290_(), Minecraft.m_91087_().m_91291_(), Minecraft.m_91087_().m_91289_(), Minecraft.m_91087_().m_91290_().m_234586_(), Minecraft.m_91087_().m_91098_(), Minecraft.m_91087_().m_167973_(), Minecraft.m_91087_().f_91062_).m_174023_(new ModelLayerLocation(new ResourceLocation("whisperwoods", "hirschgeist_skull_mask"), "main")));
        }
        return (A)((Object)ModelHGSkullMask.INSTANCE);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected <A extends HumanoidModel<?>> A displays(A armorModel, EquipmentSlot slot) {
        armorModel.f_102808_.f_104207_ = true;
        armorModel.f_102809_.f_104207_ = true;
        armorModel.f_102810_.f_104207_ = false;
        armorModel.f_102811_.f_104207_ = false;
        armorModel.f_102812_.f_104207_ = false;
        armorModel.f_102813_.f_104207_ = false;
        armorModel.f_102814_.f_104207_ = false;
        return armorModel;
    }

    @Override
    protected BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState returnedState = null;
        Level world = ctx.m_43725_();
        BlockPos clickPos = ctx.m_8083_();
        for (Direction side : ctx.m_6232_()) {
            BlockState newState = this.getBlock().m_5573_(ctx);
            if (newState == null || !newState.m_60710_((LevelReader)world, clickPos)) continue;
            returnedState = newState;
            break;
        }
        return returnedState;
    }

    @Override
    public InteractionResult tryPlace(BlockPlaceContext ctx) {
        if (!ctx.m_7059_()) {
            return InteractionResult.FAIL;
        }
        if (ctx.m_43719_() == Direction.DOWN) {
            return InteractionResult.FAIL;
        }
        BlockState placementState = this.getStateForPlacement(ctx);
        if (placementState == null) {
            return InteractionResult.FAIL;
        }
        if (!this.placeBlock(ctx, placementState)) {
            return InteractionResult.FAIL;
        }
        BlockPos blockpos = ctx.m_8083_();
        Level world = ctx.m_43725_();
        Player player = ctx.m_43723_();
        ItemStack stack = ctx.m_43722_();
        BlockState newState = world.m_8055_(blockpos);
        Block block = newState.m_60734_();
        if (block == placementState.m_60734_()) {
            this.onBlockPlaced(blockpos, world, player, stack, newState);
            block.m_6402_(world, blockpos, newState, (LivingEntity)player, stack);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)player, blockpos, stack);
            }
        }
        SoundType soundtype = newState.m_60827_();
        world.m_5594_(player, blockpos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        stack.m_41774_(1);
        return InteractionResult.SUCCESS;
    }

    public static class HGArmorMaterial
    implements ArmorMaterial {
        private static HGArmorMaterial INSTANCE;
        private static final int[] MAX_DAMAGE_ARRAY;
        private static final int[] DAMAGE_REDUCTION_AMOUNT_ARRAY;

        public static HGArmorMaterial get() {
            if (INSTANCE == null) {
                INSTANCE = new HGArmorMaterial();
            }
            return INSTANCE;
        }

        public int m_266425_(ArmorItem.Type type) {
            return MAX_DAMAGE_ARRAY[type.m_266308_().m_20749_()] * 15;
        }

        public int m_7366_(ArmorItem.Type type) {
            return DAMAGE_REDUCTION_AMOUNT_ARRAY[type.m_266308_().m_20749_()];
        }

        public int m_6646_() {
            return 9;
        }

        public SoundEvent m_7344_() {
            return SoundEvents.f_11675_;
        }

        public Ingredient m_6230_() {
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42500_});
        }

        public String m_6082_() {
            return (Platform.isForge() ? "whisperwoods:" : "") + "hirschgeist";
        }

        public float m_6651_() {
            return 0.0f;
        }

        public float m_6649_() {
            return 0.0f;
        }

        static {
            MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
            DAMAGE_REDUCTION_AMOUNT_ARRAY = new int[]{2, 5, 6, 2};
        }
    }
}

