/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.imdlib.util;

import dev.itsmeow.whisperwoods.imdlib.IMDLib;
import dev.itsmeow.whisperwoods.imdlib.entity.util.BiomeTypes;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;

public class BiomeListBuilder {
    private final Set<ResourceKey<Biome>> extras = new HashSet<ResourceKey<Biome>>();
    private final Set<BiomeTypes.Type> list = new HashSet<BiomeTypes.Type>();
    private final Set<BiomeTypes.Type> blacklist = new HashSet<BiomeTypes.Type>();
    private final Set<ResourceKey<Biome>> blacklistBiome = new HashSet<ResourceKey<Biome>>();
    private final Set<BiomeTypes.Type> required = new HashSet<BiomeTypes.Type>();
    private boolean onlyOverworld = false;

    private BiomeListBuilder() {
    }

    public static BiomeListBuilder create() {
        return new BiomeListBuilder();
    }

    @SafeVarargs
    public final BiomeListBuilder extra(ResourceKey<Biome> ... extraBiomes) {
        this.extras.addAll(Arrays.asList(extraBiomes));
        return this;
    }

    public BiomeListBuilder extra(BiomeTypes.Type ... types) {
        this.list.addAll(Arrays.asList(types));
        return this;
    }

    public BiomeListBuilder withoutTypes(BiomeTypes.Type ... types) {
        this.blacklist.addAll(Arrays.asList(types));
        return this;
    }

    public BiomeListBuilder withTypes(BiomeTypes.Type ... types) {
        this.required.addAll(Arrays.asList(types));
        return this;
    }

    @SafeVarargs
    public final BiomeListBuilder withoutBiomes(ResourceKey<Biome> ... biomes) {
        this.blacklistBiome.addAll(Arrays.asList(biomes));
        return this;
    }

    public BiomeListBuilder onlyOverworld() {
        this.onlyOverworld = true;
        return this;
    }

    public ResourceKey<Biome>[] collect() {
        HashSet<ResourceKey<Biome>> set = new HashSet<ResourceKey<Biome>>(this.extras);
        for (BiomeTypes.Type extraT : this.list) {
            set.addAll(BiomeTypes.getBiomes(extraT));
        }
        if (this.required.size() > 0 || this.blacklist.size() > 0) {
            Registry registry = null;
            try {
                registry = IMDLib.getStaticServerInstance().m_206579_().m_175515_(Registries.f_256952_);
            }
            catch (RuntimeException e) {
                return new ResourceKey[0];
            }
            for (Biome biome : registry) {
                Optional biomeKeyOpt = registry.m_7854_((Object)biome);
                biomeKeyOpt.ifPresent(biomeKey -> {
                    Set<BiomeTypes.Type> types = BiomeTypes.getTypes((ResourceKey<Biome>)biomeKey);
                    if (types.size() > 0) {
                        boolean pass = true;
                        for (BiomeTypes.Type type : this.required) {
                            if (types.contains(type)) continue;
                            pass = false;
                            break;
                        }
                        for (BiomeTypes.Type type : this.blacklist) {
                            if (!types.contains(type)) continue;
                            pass = false;
                            break;
                        }
                        if (this.blacklistBiome.contains(biomeKey)) {
                            pass = false;
                        }
                        if (this.onlyOverworld && !types.contains(BiomeTypes.OVERWORLD)) {
                            pass = false;
                        }
                        if (pass) {
                            set.add((ResourceKey<Biome>)biomeKey);
                        }
                    }
                });
            }
        }
        return set.toArray(new ResourceKey[0]);
    }
}

