/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.imdlib.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.itsmeow.whisperwoods.imdlib.block.GenericSkullBlock;
import dev.itsmeow.whisperwoods.imdlib.blockentity.HeadBlockEntity;
import dev.itsmeow.whisperwoods.imdlib.client.render.HeadModel;
import dev.itsmeow.whisperwoods.imdlib.item.ItemBlockHeadType;
import dev.itsmeow.whisperwoods.imdlib.util.HeadType;
import java.util.HashMap;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class RenderGenericHead
implements BlockEntityRenderer<HeadBlockEntity> {
    public HashMap<HeadType, HashMap<String, EntityModel<?>>> modelMap = new HashMap();

    public RenderGenericHead(BlockEntityRendererProvider.Context ctx) {
        for (HeadType type : HeadType.values()) {
            if (!this.modelMap.containsKey(type)) {
                this.modelMap.put(type, new HashMap());
            }
            HashMap<String, EntityModel<?>> typeMap = this.modelMap.get(type);
            for (RegistrySupplier<ItemBlockHeadType> regObj : type.getItemObjects()) {
                ItemBlockHeadType headItem = (ItemBlockHeadType)((Object)regObj.getOrNull());
                if (headItem == null) continue;
                typeMap.put(headItem.id, type.getModelSupplier().get().apply(headItem.id).apply(ctx.m_173582_(new ModelLayerLocation(new ResourceLocation(type.getMod(), type.getModelLocation().apply(headItem.id)), "main"))));
            }
        }
    }

    public void render(HeadBlockEntity te, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BlockState state = te.m_58900_();
        if (!(state.m_60734_() instanceof GenericSkullBlock)) {
            return;
        }
        Direction dir = te.getDirection();
        dir = dir == null ? Direction.NORTH : dir;
        float rotation = -dir.m_122435_();
        rotation = dir == Direction.NORTH || dir == Direction.SOUTH ? dir.m_122424_().m_122435_() : rotation;
        rotation = dir == Direction.UP ? te.getTopRotation() : rotation;
        GenericSkullBlock block = (GenericSkullBlock)state.m_60734_();
        this.render(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, dir, rotation, te.getTexture(), this.modelMap.get(te.getHeadType()).get(block.id));
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, int packedOverlayIn, @Nullable Direction facing, float skullRotation, ResourceLocation texture, EntityModel<? extends Entity> model) {
        matrixStackIn.m_85836_();
        if (model instanceof HeadModel) {
            matrixStackIn.m_252880_(0.0f, ((HeadModel)model).globalOffsetY() * 0.0625f, 0.0f);
        }
        if (facing == Direction.UP) {
            matrixStackIn.m_85837_(0.5, 0.0, 0.5);
        } else if (model instanceof HeadModel) {
            HeadModel m = (HeadModel)model;
            matrixStackIn.m_85837_((double)(0.5f - (float)facing.m_122429_() * 0.25f - (float)facing.m_122429_() * m.wallOffsetX() * 0.0625f), 0.25 + (double)(m.wallOffsetY() * 0.0625f), (double)(0.5f - (float)facing.m_122431_() * 0.25f - (float)facing.m_122431_() * m.wallOffsetZ() * 0.0625f));
        } else {
            matrixStackIn.m_85837_((double)(0.5f - (float)facing.m_122429_() * 0.25f), 0.25, (double)(0.5f - (float)facing.m_122431_() * 0.25f));
        }
        matrixStackIn.m_85841_(-1.0f, -1.0f, 1.0f);
        float rotX = 0.0f;
        if (facing != null) {
            rotX = facing == Direction.UP ? -90.0f : 0.0f;
        }
        model.m_6973_(null, skullRotation, rotX, 0.0f, 0.0f, 0.0f);
        model.m_7695_(matrixStackIn, bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)texture)), packedLightIn, packedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.m_85849_();
    }
}

