/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.imdlib.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.itsmeow.whisperwoods.imdlib.client.render.BaseRenderer;
import dev.itsmeow.whisperwoods.imdlib.entity.interfaces.IVariantTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Mob;
import org.apache.commons.lang3.tuple.Pair;

public class ImplRenderer<T extends Mob, A extends EntityModel<T>>
extends BaseRenderer<T, A> {
    private final TextureContainer<T, A> textureContainer;
    private final ModelContainer<T, A> modelContainer;
    private final PreRenderCallback<T> preRenderCallback;
    private final HandleRotation<T> handleRotation;
    private final ApplyRotations<T> applyRotations;
    private final SuperCallApplyRotations applyRotationsSuper;
    private final RenderLayer<T> renderLayer;
    private final BlockLightLevel<T> blockLightLevel;

    public ImplRenderer(EntityRendererProvider.Context ctx, float shadow, TextureContainer<T, A> textureContainer, ModelContainer<T, A> modelContainer, PreRenderCallback<T> preRenderCallback, HandleRotation<T> handleRotation, ApplyRotations<T> applyRotations, SuperCallApplyRotations applyRotationsSuper, RenderLayer<T> renderLayer, BlockLightLevel<T> blockLightLevel) {
        super(ctx, modelContainer.getBaseModel(ctx), shadow);
        this.textureContainer = textureContainer;
        this.modelContainer = modelContainer;
        this.preRenderCallback = preRenderCallback;
        this.handleRotation = handleRotation;
        this.applyRotations = applyRotations;
        this.applyRotationsSuper = applyRotationsSuper;
        this.renderLayer = renderLayer;
        this.blockLightLevel = blockLightLevel;
    }

    public static <T extends Mob, A extends EntityModel<T>> Builder<T, A> factory(String modid, float shadow) {
        return new Builder(modid, shadow);
    }

    private static ResourceLocation tex(String modid, String location) {
        return new ResourceLocation(modid, "textures/entity/" + location + ".png");
    }

    private static ModelLayerLocation mll(String modid, String location) {
        return new ModelLayerLocation(new ResourceLocation(modid, location), "main");
    }

    protected void setupRotations(T e, PoseStack s, float a, float y, float p) {
        if (this.applyRotations == null) {
            super.m_7523_(e, s, a, y, p);
        } else {
            if (this.applyRotationsSuper == SuperCallApplyRotations.PRE) {
                super.m_7523_(e, s, a, y, p);
            }
            this.applyRotations.applyRotations(e, s, a, y, p);
            if (this.applyRotationsSuper == SuperCallApplyRotations.POST) {
                super.m_7523_(e, s, a, y, p);
            }
        }
    }

    protected void scale(T e, PoseStack s, float p) {
        if (this.preRenderCallback != null) {
            this.preRenderCallback.preRenderCallback(e, s, p);
        }
    }

    protected float getBob(T e, float p) {
        return this.handleRotation == null ? super.m_6930_(e, p) : this.handleRotation.handleRotation(e, p);
    }

    protected RenderType getRenderType(T entity, boolean visible, boolean visibleToPlayer, boolean glowing) {
        return this.renderLayer == null ? super.m_7225_(entity, visible, visibleToPlayer, glowing) : this.renderLayer.renderLayer(entity, visible, visibleToPlayer, glowing, this.getTextureLocation(entity));
    }

    protected int getBlockLightLevel(T entity, BlockPos blockPos) {
        return this.blockLightLevel == null ? super.m_6086_(entity, blockPos) : this.blockLightLevel.blockLightLevel(entity, blockPos);
    }

    public void m_7392_(T e, float p_225623_2_, float p_225623_3_, PoseStack p_225623_4_, MultiBufferSource p_225623_5_, int p_225623_6_) {
        this.f_115290_ = this.modelContainer.getModel(e);
        super.m_7392_(e, p_225623_2_, p_225623_3_, p_225623_4_, p_225623_5_, p_225623_6_);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return this.textureContainer.getTexture(entity);
    }

    public static class ModelContainer<T extends Mob, A extends EntityModel<T>> {
        private final String modId;
        private final Strategy strategy;
        private final Function<EntityRendererProvider.Context, A> baseModelProvider;
        private final Set<Pair<String, Function<EntityRendererProvider.Context, EntityModel<T>>>> modelEntries = new HashSet<Pair<String, Function<EntityRendererProvider.Context, EntityModel<T>>>>();
        private final Map<String, EntityModel<T>> builtModelMap = new HashMap<String, EntityModel<T>>();
        private Function<T, String> modelKeyMapper;
        private Function<EntityRendererProvider.Context, EntityModel<T>> falseModelProvider;
        private Predicate<T> condition;
        private A baseModel;
        private A trueModel;
        private EntityModel<T> falseModel;

        public ModelContainer(String modid, Function<ModelPart, A> baseModel, String modelLayerLocation) {
            this.modId = modid;
            this.strategy = Strategy.SINGLE;
            this.baseModelProvider = ctx -> (EntityModel)baseModel.apply(ctx.m_174023_(this.mll(modelLayerLocation)));
        }

        public ModelContainer(String modid, Function<T, String> modelMapper, Function<ModelPart, A> baseModel, String baseModelLocation) {
            this.modId = modid;
            this.strategy = Strategy.MAPPER;
            this.modelKeyMapper = modelMapper;
            this.baseModelProvider = this.convert(baseModel, baseModelLocation);
        }

        public ModelContainer(String modid, Predicate<T> condition, Function<ModelPart, A> trueModel, String trueLayerLocation, Function<ModelPart, EntityModel<T>> falseModel, String falseLayerLocation) {
            this.modId = modid;
            this.strategy = Strategy.CONDITION;
            this.condition = condition;
            this.baseModelProvider = this.convert(trueModel, trueLayerLocation);
            this.falseModelProvider = this.convert(falseModel, falseLayerLocation);
        }

        private <Z extends EntityModel<T>> Function<EntityRendererProvider.Context, Z> convert(Function<ModelPart, Z> m, String location) {
            return ctx -> (EntityModel)m.apply(ctx.m_174023_(this.mll(location)));
        }

        public void addMapperEntry(Function<ModelPart, EntityModel<T>> modelSupplier, String modelLayerLocation) {
            this.modelEntries.add(Pair.of((Object)modelLayerLocation, this.convert(modelSupplier, modelLayerLocation)));
        }

        public void provideContext(EntityRendererProvider.Context ctx) {
            this.baseModel = (EntityModel)this.baseModelProvider.apply(ctx);
            if (this.strategy == Strategy.MAPPER) {
                for (Pair<String, Function<EntityRendererProvider.Context, EntityModel<T>>> pair : this.modelEntries) {
                    this.builtModelMap.put((String)pair.getLeft(), (EntityModel)((Function)pair.getRight()).apply(ctx));
                }
            } else if (this.strategy == Strategy.CONDITION) {
                this.trueModel = this.baseModel;
                this.falseModel = this.falseModelProvider.apply(ctx);
            }
        }

        public EntityModel<T> getModel(T entity) {
            if (this.baseModel == null) {
                throw new RuntimeException("getModel called before provideContext!");
            }
            switch (this.strategy) {
                case SINGLE: {
                    return this.baseModel;
                }
                case MAPPER: {
                    return this.getModelForKey(this.modelKeyMapper.apply(entity));
                }
                case CONDITION: {
                    return this.condition.test(entity) ? this.trueModel : this.falseModel;
                }
            }
            return this.baseModel;
        }

        public EntityModel<T> getModelForKey(String key) {
            return this.builtModelMap.getOrDefault(key, (EntityModel<T>)this.baseModel);
        }

        public A getBaseModel(EntityRendererProvider.Context ctx) {
            if (this.baseModel == null) {
                this.provideContext(ctx);
            }
            return this.baseModel;
        }

        private ModelLayerLocation mll(String loc) {
            return ImplRenderer.mll(this.modId, loc);
        }
    }

    public static class TextureContainer<T extends Mob, A extends EntityModel<T>> {
        private final Strategy strategy;
        private ResourceLocation singleTexture;
        private Function<T, ResourceLocation> texMapper;
        private ResourceLocation trueTex;
        private ResourceLocation falseTex;
        private Predicate<T> condition;
        private ResourceLocation conditionTex;

        public TextureContainer(ResourceLocation singleTexture) {
            this.strategy = Strategy.SINGLE;
            this.singleTexture = singleTexture;
        }

        public TextureContainer(Function<T, ResourceLocation> texMapper) {
            this.strategy = Strategy.MAPPER;
            this.texMapper = texMapper;
        }

        public TextureContainer(Predicate<T> condition, Function<T, ResourceLocation> texMapper, ResourceLocation conditionTex) {
            this.strategy = Strategy.MAPPER_CONDITION;
            this.texMapper = texMapper;
            this.condition = condition;
            this.conditionTex = conditionTex;
        }

        public TextureContainer(Predicate<T> condition, ResourceLocation trueTex, ResourceLocation falseTex) {
            this.strategy = Strategy.CONDITION;
            this.condition = condition;
            this.trueTex = trueTex;
            this.falseTex = falseTex;
        }

        public ResourceLocation getTexture(T entity) {
            switch (this.strategy) {
                case SINGLE: {
                    return this.singleTexture;
                }
                case MAPPER: {
                    return this.texMapper.apply(entity);
                }
                case CONDITION: {
                    return this.condition.test(entity) ? this.trueTex : this.falseTex;
                }
                case MAPPER_CONDITION: {
                    return this.condition.test(entity) ? this.conditionTex : this.texMapper.apply(entity);
                }
            }
            return null;
        }
    }

    @FunctionalInterface
    public static interface PreRenderCallback<T extends Mob> {
        public void preRenderCallback(T var1, PoseStack var2, float var3);
    }

    @FunctionalInterface
    public static interface HandleRotation<T extends Mob> {
        public float handleRotation(T var1, float var2);
    }

    @FunctionalInterface
    public static interface ApplyRotations<T extends Mob> {
        public void applyRotations(T var1, PoseStack var2, float var3, float var4, float var5);
    }

    public static enum SuperCallApplyRotations {
        PRE,
        NONE,
        POST;

    }

    @FunctionalInterface
    public static interface RenderLayer<T extends Mob> {
        public RenderType renderLayer(T var1, boolean var2, boolean var3, boolean var4, ResourceLocation var5);
    }

    @FunctionalInterface
    public static interface BlockLightLevel<T extends Mob> {
        public int blockLightLevel(T var1, BlockPos var2);
    }

    public static class Builder<T extends Mob, A extends EntityModel<T>> {
        private final String modid;
        private final float shadow;
        private final ArrayList<Function<BaseRenderer<T, A>, net.minecraft.client.renderer.entity.layers.RenderLayer<T, A>>> layers = new ArrayList();
        private final Map<String, ResourceLocation> texMapper = new HashMap<String, ResourceLocation>();
        private TextureContainer<T, A> tex;
        private ModelContainer<T, A> model;
        private PreRenderCallback<T> preRender;
        private HandleRotation<T> handleRotation;
        private ApplyRotations<T> applyRotations;
        private SuperCallApplyRotations superCallApplyRotations = SuperCallApplyRotations.NONE;
        private RenderLayer<T> renderLayer;
        private BlockLightLevel<T> blockLightLevel;

        protected Builder(String modid, float shadow) {
            this.modid = modid;
            this.shadow = shadow;
        }

        public Builder<T, A> layer(Function<BaseRenderer<T, A>, net.minecraft.client.renderer.entity.layers.RenderLayer<T, A>> layer) {
            this.layers.add(layer);
            return this;
        }

        public Builder<T, A> tSingle(String texture) {
            this.tex = new TextureContainer(ImplRenderer.tex(this.modid, texture));
            return this;
        }

        public Builder<T, A> tCondition(Predicate<T> condition, String trueTex, String falseTex) {
            this.tex = new TextureContainer(condition, ImplRenderer.tex(this.modid, trueTex), ImplRenderer.tex(this.modid, falseTex));
            return this;
        }

        public Builder<T, A> tMapped(Function<T, String> texMapper) {
            this.tex = new TextureContainer(entity -> this.texStored((String)texMapper.apply(entity)));
            return this;
        }

        public Builder<T, A> tSingleRaw(ResourceLocation texture) {
            this.tex = new TextureContainer(texture);
            return this;
        }

        public Builder<T, A> tConditionRaw(Predicate<T> condition, ResourceLocation trueTex, ResourceLocation falseTex) {
            this.tex = new TextureContainer(condition, trueTex, falseTex);
            return this;
        }

        public Builder<T, A> tMappedRaw(Function<T, ResourceLocation> texMapper) {
            this.tex = new TextureContainer(texMapper);
            return this;
        }

        public Builder<T, A> tVariant() {
            return this.tMappedRaw(e -> {
                if (e instanceof IVariantTypes) {
                    return ((IVariantTypes)e).getVariantTextureOrNull();
                }
                return null;
            });
        }

        public Builder<T, A> tMappedConditionRaw(Predicate<T> condition, Function<T, ResourceLocation> texMapper, String conditionTex) {
            return this.tMappedConditionRaw(condition, texMapper, ImplRenderer.tex(this.modid, conditionTex));
        }

        public Builder<T, A> tMappedConditionRaw(Predicate<T> condition, Function<T, ResourceLocation> texMapper, ResourceLocation conditionTex) {
            this.tex = new TextureContainer(condition, texMapper, conditionTex);
            return this;
        }

        public Builder<T, A> tVariantCondition(Predicate<T> condition, String conditionTex) {
            return this.tVariantCondition(condition, ImplRenderer.tex(this.modid, conditionTex));
        }

        public Builder<T, A> tVariantCondition(Predicate<T> condition, ResourceLocation conditionTex) {
            this.tex = new TextureContainer(condition, e -> {
                if (e instanceof IVariantTypes) {
                    return ((IVariantTypes)e).getVariantTextureOrNull();
                }
                return null;
            }, conditionTex);
            return this;
        }

        public Builder<T, A> tBabyVariant(String babyTex) {
            return this.tVariantCondition((T e) -> {
                if (e instanceof AgeableMob) {
                    return e.m_6162_();
                }
                return false;
            }, ImplRenderer.tex(this.modid, babyTex));
        }

        public Builder<T, A> mSingle(Function<ModelPart, A> modelSupplier, String layerLocation) {
            this.model = new ModelContainer(this.modid, modelSupplier, layerLocation);
            return this;
        }

        public Builder<T, A> mMapped(Function<T, String> modelLocationMapper, Function<ModelPart, A> baseModelSupplier, String baseModelLayerLocation) {
            this.model = new ModelContainer<T, A>(this.modid, modelLocationMapper, baseModelSupplier, baseModelLayerLocation);
            return this;
        }

        public Builder<T, A> mEntry(Function<ModelPart, EntityModel<T>> modelSupplier, String modelLayerLocation) {
            if (this.model == null || this.model.strategy != Strategy.MAPPER) {
                throw new RuntimeException("Must call mMapped before mEntry!");
            }
            this.model.addMapperEntry(modelSupplier, modelLayerLocation);
            return this;
        }

        public Builder<T, A> mCondition(Predicate<T> condition, Function<ModelPart, A> trueModelSupplier, String trueLayerLocation, Function<ModelPart, EntityModel<T>> falseModelSupplier, String falseLayerLocation) {
            this.model = new ModelContainer<T, A>(this.modid, condition, trueModelSupplier, trueLayerLocation, falseModelSupplier, falseLayerLocation);
            return this;
        }

        public Builder<T, A> preRender(PreRenderCallback<T> preRender) {
            this.preRender = preRender;
            return this;
        }

        public Builder<T, A> simpleScale(Function<T, Float> function) {
            this.preRender((e, s, p) -> {
                float scale = ((Float)function.apply(e)).floatValue();
                s.m_85841_(scale, scale, scale);
            });
            return this;
        }

        public Builder<T, A> condScale(Predicate<T> cond, float xScale, float yScale, float zScale) {
            this.preRender((e, s, p) -> {
                if (cond.test(e)) {
                    s.m_85841_(xScale, yScale, zScale);
                }
            });
            return this;
        }

        public Builder<T, A> condScale(Predicate<T> cond, float scale) {
            return this.condScale(cond, scale, scale, scale);
        }

        public Builder<T, A> condDualScale(Predicate<T> cond, float truexScale, float trueyScale, float truezScale, float falsexScale, float falseyScale, float falsezScale) {
            this.preRender((e, s, p) -> {
                if (cond.test(e)) {
                    s.m_85841_(truexScale, trueyScale, truezScale);
                } else {
                    s.m_85841_(falsexScale, falseyScale, falsezScale);
                }
            });
            return this;
        }

        public Builder<T, A> condDualScale(Predicate<T> cond, float trueScale, float falseScale) {
            return this.condDualScale(cond, trueScale, trueScale, trueScale, falseScale, falseScale, falseScale);
        }

        public Builder<T, A> childScale(float xScale, float yScale, float zScale) {
            this.preRender((e, s, p) -> {
                if (e instanceof AgeableMob && e.m_6162_()) {
                    s.m_85841_(xScale, yScale, zScale);
                }
            });
            return this;
        }

        public Builder<T, A> childScale(float scale) {
            return this.childScale(scale, scale, scale);
        }

        public Builder<T, A> ageScale(float adultxScale, float adultyScale, float adultzScale, float childxScale, float childyScale, float childzScale) {
            this.preRender((e, s, p) -> {
                if (e instanceof AgeableMob) {
                    if (e.m_6162_()) {
                        s.m_85841_(childxScale, childyScale, childzScale);
                    } else {
                        s.m_85841_(adultxScale, adultyScale, adultzScale);
                    }
                }
            });
            return this;
        }

        public Builder<T, A> ageScale(float adultScale, float childScale) {
            return this.ageScale(adultScale, adultScale, adultScale, childScale, childScale, childScale);
        }

        public Builder<T, A> handleRotation(HandleRotation<T> handleRotationFunc) {
            this.handleRotation = handleRotationFunc;
            return this;
        }

        public Builder<T, A> applyRotations(ApplyRotations<T> applyRotationsFunc, SuperCallApplyRotations superCall) {
            this.superCallApplyRotations = superCall;
            return this.applyRotations(applyRotationsFunc);
        }

        public Builder<T, A> applyRotations(ApplyRotations<T> applyRotationsFunc) {
            this.applyRotations = applyRotationsFunc;
            return this;
        }

        public Builder<T, A> renderLayer(RenderLayer<T> renderLayerFunc) {
            this.renderLayer = renderLayerFunc;
            return this;
        }

        public Builder<T, A> blockLightLevel(BlockLightLevel<T> blockLightLevel) {
            this.blockLightLevel = blockLightLevel;
            return this;
        }

        public EntityRendererProvider done() {
            if (this.tex == null || this.model == null) {
                throw new IllegalArgumentException("Must define both a texture and a model before calling build()!");
            }
            return ctx -> new ImplRenderer<T, A>(ctx, this.shadow, this.tex, this.model, this.preRender, this.handleRotation, this.applyRotations, this.superCallApplyRotations, this.renderLayer, this.blockLightLevel).layers(this.layers);
        }

        private ResourceLocation texStored(String location) {
            return this.texMapper.computeIfAbsent(location, l -> ImplRenderer.tex(this.modid, l));
        }
    }

    @FunctionalInterface
    public static interface RenderDef<T extends Mob, A extends EntityModel<T>> {
        public Builder<T, A> apply(Builder<T, A> var1);
    }

    public static enum Strategy {
        SINGLE,
        MAPPER,
        MAPPER_CONDITION,
        CONDITION;

    }
}

