/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.entity;

import dev.itsmeow.whisperwoods.entity.EntityMonsterWithTypes;
import dev.itsmeow.whisperwoods.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.whisperwoods.imdlib.entity.util.BiomeTypes;
import dev.itsmeow.whisperwoods.init.ModEntities;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityZotzpyre
extends EntityMonsterWithTypes
implements FlyingAnimal {
    private static final EntityDataAccessor<Boolean> HANGING = SynchedEntityData.m_135353_(EntityZotzpyre.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected FastFlyingMoveControl moveSwoop;
    protected FlyingMoveControl moveNormal;

    public EntityZotzpyre(EntityType<? extends EntityZotzpyre> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.m_20242_(true);
        this.moveSwoop = new FastFlyingMoveControl((Mob)this);
        this.moveNormal = new FlyingMoveControl((Mob)this, 20, false);
        this.f_21342_ = this.moveNormal;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, new SwoopingAttackGoal<EntityZotzpyre>(this));
        this.f_21345_.m_25352_(1, new HangFromCeilingGoal<EntityZotzpyre>(this));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 0, false, false, e -> true));
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new FlyingPathNavigation((Mob)this, worldIn);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(HANGING, (Object)false);
    }

    public boolean isHanging() {
        return (Boolean)this.m_20088_().m_135370_(HANGING);
    }

    public void setHanging(boolean hanging) {
        this.m_20088_().m_135381_(HANGING, (Object)hanging);
    }

    protected float m_6121_() {
        return 0.5f;
    }

    public float m_6100_() {
        return super.m_6100_() * 0.05f;
    }

    public SoundEvent m_7515_() {
        return SoundEvents.f_11731_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11733_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11732_;
    }

    public static boolean canSpawn(EntityType<EntityZotzpyre> type, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource rand) {
        if (pos.m_123342_() >= world.m_5736_() && !BiomeTypes.getTypes((ResourceKey<Biome>)((ResourceKey)world.m_204166_(pos).m_203543_().get())).contains(BiomeTypes.JUNGLE)) {
            return false;
        }
        return EntityZotzpyre.m_219019_(type, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)rand);
    }

    public boolean m_7327_(Entity entityIn) {
        float f = (float)this.m_21051_(Attributes.f_22281_).m_22135_();
        boolean flag = entityIn.m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), f);
        if (flag) {
            if (entityIn instanceof Player) {
                Player player = (Player)entityIn;
                int slowTicks = 0;
                if (this.m_9236_().m_46791_() == Difficulty.EASY) {
                    slowTicks = 200;
                } else if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                    slowTicks = 300;
                } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                    slowTicks = 600;
                }
                if (slowTicks > 0) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, slowTicks, 1, false, false));
                }
            }
            this.m_21335_(entityIn);
        }
        return flag;
    }

    public boolean m_7337_(Entity entity) {
        return entity != this.m_5448_() && super.m_7337_(entity);
    }

    public boolean m_142535_(float f, float g, DamageSource damageSource) {
        return false;
    }

    protected void m_7840_(double d, boolean bl, BlockState blockState, BlockPos blockPos) {
    }

    public void m_7023_(Vec3 vec3) {
        if (this.isHanging() || this.f_21342_ == this.moveSwoop) {
            if (this.m_20069_()) {
                this.m_19920_(0.02f, vec3);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
            } else if (this.m_20077_()) {
                this.m_19920_(0.02f, vec3);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_(0.5));
            } else {
                float f = 0.91f;
                if (this.m_20096_()) {
                    f = this.m_9236_().m_8055_(BlockPos.m_274561_((double)this.m_20185_(), (double)(this.m_20186_() - 1.0), (double)this.m_20189_())).m_60734_().m_49958_() * 0.91f;
                }
                float g = 0.16277137f / (f * f * f);
                this.m_19920_(this.m_20096_() ? 0.1f * g : 0.02f, vec3);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)f));
            }
            this.m_267651_(false);
        } else {
            super.m_7023_(vec3);
        }
    }

    public boolean m_6147_() {
        return !this.isHanging();
    }

    @Override
    public EntityTypeContainer<EntityZotzpyre> getContainer() {
        return ModEntities.ZOTZPYRE;
    }

    public boolean m_29443_() {
        return this.m_20068_() && !this.isHanging();
    }

    public static class FastFlyingMoveControl
    extends MoveControl {
        private boolean cantReach = false;

        public FastFlyingMoveControl(Mob mob) {
            super(mob);
        }

        public void m_6849_(double d, double e, double f, double g) {
            super.m_6849_(d, e, f, g);
            this.cantReach = false;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                this.f_24974_.m_20242_(true);
                Vec3 diff = new Vec3(this.f_24975_ - this.f_24974_.m_20185_(), this.f_24976_ - this.f_24974_.m_20186_(), this.f_24977_ - this.f_24974_.m_20189_());
                Vec3 diffNorm = diff.m_82541_();
                if (this.canReach(diffNorm, Mth.m_14165_((double)diff.m_82553_()))) {
                    this.f_24974_.m_20256_(this.f_24974_.m_20184_().m_82549_(diffNorm.m_82490_(0.1)));
                } else {
                    this.cantReach = true;
                    this.stop();
                }
                double yawAngle = Math.atan2(diff.m_7094_(), diff.m_7096_()) * 57.29577951308232 - 90.0;
                this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), (float)yawAngle, 35.0f));
                double pitchAngle = -Math.atan2(diff.m_7098_(), Math.sqrt(diff.m_7096_() * diff.m_7096_() + diff.m_7094_() * diff.m_7094_())) * 57.29577951308232;
                this.f_24974_.m_146926_(this.m_24991_(this.f_24974_.m_146909_(), (float)pitchAngle, 35.0f));
            } else {
                this.f_24974_.m_20242_(false);
            }
        }

        public boolean cantReach() {
            return this.cantReach;
        }

        public void stop() {
            this.f_24981_ = MoveControl.Operation.WAIT;
        }

        private boolean canReach(Vec3 vec3, int i) {
            AABB box = this.f_24974_.m_20191_();
            for (int j = 1; j < i; ++j) {
                box = box.m_82383_(vec3);
                if (!this.f_24974_.m_9236_().m_186434_((Entity)this.f_24974_, box).iterator().hasNext()) continue;
                return false;
            }
            return true;
        }
    }

    public static class SwoopingAttackGoal<T extends PathfinderMob>
    extends Goal {
        protected MovementPhase phase;
        protected T parentEntity;
        private int phaseTicks;
        private Vec3 startPos;
        private Vec3 targetPosition;

        public SwoopingAttackGoal(T parentEntity) {
            this.parentEntity = parentEntity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.phase = MovementPhase.SWOOP_TO;
            this.phaseTicks = 0;
            this.startPos = null;
            this.targetPosition = null;
        }

        public void m_8041_() {
            T t;
            this.phase = MovementPhase.SWOOP_TO;
            this.phaseTicks = 0;
            this.startPos = null;
            this.targetPosition = null;
            if (this.parentEntity.m_21566_() instanceof FastFlyingMoveControl) {
                ((FastFlyingMoveControl)this.parentEntity.m_21566_()).stop();
            }
            if ((t = this.parentEntity) instanceof EntityZotzpyre) {
                EntityZotzpyre zotzpyre = (EntityZotzpyre)t;
                zotzpyre.f_21342_ = (MoveControl)zotzpyre.moveNormal;
            }
        }

        public boolean m_8036_() {
            return this.parentEntity.m_5448_() != null && this.parentEntity.m_6779_(this.parentEntity.m_5448_());
        }

        public void m_8056_() {
            T t = this.parentEntity;
            if (t instanceof EntityZotzpyre) {
                EntityZotzpyre zotzpyre = (EntityZotzpyre)t;
                zotzpyre.f_21342_ = zotzpyre.moveSwoop;
            }
            this.startPos = this.parentEntity.m_20182_();
            this.phaseTicks = 0;
            LivingEntity target = this.parentEntity.m_5448_();
            if ((double)this.parentEntity.m_20270_((Entity)target) < 1.0) {
                this.phase = MovementPhase.HIT;
                this.startPos = null;
            }
            this.targetPosition = target.m_20299_(1.0f);
        }

        private boolean isAtPosition() {
            return this.targetPosition != null ? this.parentEntity.m_20182_().m_82554_(this.targetPosition) < 1.5 : false;
        }

        /*
         * Unable to fully structure code
         */
        public void m_8037_() {
            block17: {
                block16: {
                    target = this.parentEntity.m_5448_();
                    if (this.phase != MovementPhase.SWOOP_TO) break block16;
                    this.targetPosition = target.m_20299_(1.0f);
                    if (this.targetPosition == null || this.isAtPosition()) ** GOTO lbl-1000
                    v0 = this.phaseTicks++;
                    if ((float)v0 > 20.0f && this.parentEntity.m_20184_().m_82553_() < 0.01) {
                        this.parentEntity.m_21573_().m_26519_(this.targetPosition.m_7096_(), this.targetPosition.m_7098_(), this.targetPosition.m_7094_(), 1.0);
                    } else lbl-1000:
                    // 2 sources

                    {
                        this.parentEntity.m_21573_().m_26573_();
                    }
                    this.parentEntity.m_21391_((Entity)target, 30.0f, 30.0f);
                    if (this.isAtPosition()) {
                        this.phase = MovementPhase.HIT;
                        this.phaseTicks = 0;
                    }
                    break block17;
                }
                if (this.phase == MovementPhase.HIT) {
                    this.targetPosition = target.m_20299_(1.0f);
                    this.parentEntity.m_21391_((Entity)target, 30.0f, 30.0f);
                    if (this.parentEntity.f_19797_ - this.parentEntity.m_21215_() > 40 && this.parentEntity.m_7327_((Entity)target) || this.phaseTicks++ > 45) {
                        this.phaseTicks = 0;
                        this.phase = MovementPhase.SWOOP_AWAY;
                        this.targetPosition = null;
                    }
                } else if (this.phase == MovementPhase.SWOOP_AWAY) {
                    if (this.targetPosition != null) {
                        if (this.isAtPosition() || this.phaseTicks++ > 45 || this.parentEntity.m_21573_().m_26524_(this.targetPosition.m_7096_(), this.targetPosition.m_7098_(), this.targetPosition.m_7094_(), 1) == null) {
                            this.phase = MovementPhase.SWOOP_TO;
                            this.phaseTicks = 0;
                            this.startPos = this.parentEntity.m_20182_();
                            this.targetPosition = null;
                        }
                    } else if (this.startPos != null) {
                        oScale = this.startPos.m_82546_(target.m_20182_()).m_82542_(-2.0, 1.0, -2.0);
                        if (oScale.m_82553_() > 10.0) {
                            oScale = oScale.m_82542_(0.5, 1.0, 0.5);
                        }
                        if (oScale.m_7098_() > 5.0) {
                            oScale = oScale.m_82492_(0.0, 2.5, 0.0);
                        }
                        this.targetPosition = opposite = target.m_20182_().m_82549_(oScale);
                    } else {
                        this.targetPosition = newPos = DefaultRandomPos.m_148403_(this.parentEntity, (int)10, (int)10);
                    }
                } else {
                    this.phase = MovementPhase.SWOOP_TO;
                    this.phaseTicks = 0;
                    this.startPos = null;
                    this.targetPosition = null;
                }
            }
            if (this.targetPosition != null && !this.isAtPosition()) {
                this.parentEntity.m_21566_().m_6849_(this.targetPosition.m_7096_(), this.targetPosition.m_7098_(), this.targetPosition.m_7094_(), 1.0);
            }
        }

        public static enum MovementPhase {
            SWOOP_TO,
            HIT,
            SWOOP_AWAY;

        }
    }

    public static class HangFromCeilingGoal<T extends Mob>
    extends Goal {
        protected T parentEntity;

        public HangFromCeilingGoal(T parentEntity) {
            this.parentEntity = parentEntity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return this.parentEntity.m_5448_() == null && this.parentEntity.m_9236_().m_8055_(this.parentEntity.m_20183_().m_7494_()).m_60783_((BlockGetter)this.parentEntity.m_9236_(), this.parentEntity.m_20183_().m_7494_(), Direction.DOWN);
        }

        public void m_8037_() {
            this.parentEntity.m_21573_().m_26519_(this.parentEntity.m_20185_(), (double)this.parentEntity.m_20183_().m_123342_(), this.parentEntity.m_20189_(), 1.0);
        }

        public void m_8056_() {
            if (this.parentEntity instanceof EntityZotzpyre) {
                ((EntityZotzpyre)this.parentEntity).setHanging(true);
            }
        }

        public void m_8041_() {
            ((EntityZotzpyre)this.parentEntity).setHanging(false);
        }
    }
}

