/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.entity;

import dev.itsmeow.whisperwoods.entity.EntityWisp;
import dev.itsmeow.whisperwoods.entity.projectile.EntityHirschgeistFireball;
import dev.itsmeow.whisperwoods.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.whisperwoods.init.ModEntities;
import dev.itsmeow.whisperwoods.init.ModSounds;
import dev.itsmeow.whisperwoods.util.IOverrideCollisions;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityHirschgeist
extends Monster
implements Enemy,
IOverrideCollisions<EntityHirschgeist> {
    protected int flameIndex = 0;
    public static final EntityDataAccessor<Float> DISTANCE_TO_TARGET = SynchedEntityData.m_135353_(EntityHirschgeist.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Boolean> DAYTIME = SynchedEntityData.m_135353_(EntityHirschgeist.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS).m_7003_(false);
    private boolean wasSummoned = false;

    public EntityHirschgeist(EntityType<? extends EntityHirschgeist> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.f_21364_ = 150;
        this.m_274367_(1.5f);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.7, true){

            public boolean m_8036_() {
                return !EntityHirschgeist.this.isDaytime() && super.m_8036_();
            }

            public boolean m_8045_() {
                return !EntityHirschgeist.this.isDaytime() && super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new FlameAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new SummonWispsGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 20.0f));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        if (reason == MobSpawnType.EVENT || reason == MobSpawnType.MOB_SUMMONED) {
            this.setWasSummoned();
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new GroundPathNavigation((Mob)this, worldIn){

            protected PathFinder m_5532_(int i1) {
                this.f_26508_ = new WalkNodeEvaluator(){

                    protected BlockPathTypes m_264405_(BlockGetter reader, BlockPos pos, BlockPathTypes typeIn) {
                        return typeIn == BlockPathTypes.LEAVES || reader.m_8055_(pos).m_204336_(BlockTags.f_13106_) || reader.m_8055_(pos).m_204336_(BlockTags.f_13035_) ? BlockPathTypes.OPEN : super.m_264405_(reader, pos, typeIn);
                    }
                };
                this.f_26508_.m_77351_(true);
                return new PathFinder(this.f_26508_, i1);
            }
        };
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DISTANCE_TO_TARGET, (Object)Float.valueOf(-1.0f));
        this.m_20088_().m_135372_(DAYTIME, (Object)true);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
        if (compound.m_128471_("summoned")) {
            this.setWasSummoned();
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("summoned", this.wasSummoned());
    }

    public void m_6593_(Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public float getTargetDistance() {
        return ((Float)this.m_20088_().m_135370_(DISTANCE_TO_TARGET)).floatValue();
    }

    public boolean m_7327_(Entity entityIn) {
        if (super.m_7327_(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).m_147240_(2.0, this.m_20185_() - entityIn.m_20185_(), this.m_20189_() - entityIn.m_20189_());
                entityIn.m_20254_(2 + this.m_217043_().m_188503_(2));
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123745_, this.m_20182_().m_7096_() + (entityIn.m_20182_().m_7096_() - this.m_20182_().m_7096_()) / 2.0, this.m_20182_().m_7098_() + (entityIn.m_20182_().m_7098_() - this.m_20182_().m_7098_()) / 2.0, this.m_20182_().m_7094_() + (entityIn.m_20182_().m_7094_() - this.m_20182_().m_7094_()) / 2.0, 500, Math.abs((entityIn.m_20182_().m_7096_() - this.m_20182_().m_7096_()) / 25.0), 0.0, Math.abs((entityIn.m_20182_().m_7094_() - this.m_20182_().m_7094_()) / 25.0), 0.1);
                }
            }
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getFlameAnimationIndex() {
        return this.flameIndex;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 2 == 0) {
            this.flameIndex = this.flameIndex >= 7 ? 0 : ++this.flameIndex;
        }
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
        if (!this.m_9236_().f_46443_) {
            this.m_20088_().m_135381_(DISTANCE_TO_TARGET, (Object)Float.valueOf(this.m_5448_() == null ? -1.0f : this.m_5448_().m_20270_((Entity)this)));
            this.m_20088_().m_135381_(DAYTIME, (Object)this.isDaytime());
        }
    }

    public boolean isDaytime() {
        return this.m_9236_().m_46461_();
    }

    public boolean isDaytimeClient() {
        return (Boolean)this.m_20088_().m_135370_(DAYTIME);
    }

    public boolean m_5789_() {
        return !this.isDaytime();
    }

    public boolean m_20147_() {
        return this.isDaytime();
    }

    public boolean m_6673_(DamageSource source) {
        return this.isDaytime() && !source.m_276093_(DamageTypes.f_268724_) && !source.m_276093_(DamageTypes.f_286973_) && !source.m_19390_() || source.m_7639_() instanceof EntityHirschgeist || source.m_276093_(DamageTypes.f_268515_) || source.m_276093_(DamageTypes.f_268631_) || source.m_276093_(DamageTypes.f_268468_) || source.m_276093_(DamageTypes.f_268546_);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.m_9236_().f_46443_ && source.m_7639_() instanceof Player && !source.m_19390_()) {
            if (this.isDaytime()) {
                Player player = (Player)source.m_7639_();
                player.m_213846_((Component)Component.m_237115_((String)"entity.whisperwoods.hirschgeist.message.invulnerable"));
                return false;
            }
            if (this.m_217043_().m_188503_(4) == 0) {
                this.m_9236_().m_6269_(null, source.m_7639_(), SoundEvents.f_11783_, SoundSource.MASTER, 1.0f, 2.0f);
                return false;
            }
        }
        return super.m_6469_(source, amount);
    }

    public void m_6710_(LivingEntity entityIn) {
        super.m_6710_(this.isDaytime() ? null : entityIn);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.HIRSCHGEIST_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ModSounds.HIRSCHGEIST_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.HIRSCHGEIST_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12345_, 0.5f, 0.6f);
    }

    public boolean m_5830_() {
        return this.insideOpaque();
    }

    @Override
    public boolean canPassThrough(BlockState state) {
        return state.m_204336_(BlockTags.f_13035_) || state.m_204336_(BlockTags.f_13106_);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return this.despawn(distanceToClosestPlayer) && !this.wasSummoned();
    }

    public boolean wasSummoned() {
        return this.wasSummoned;
    }

    public void setWasSummoned() {
        this.wasSummoned = true;
    }

    @Override
    public EntityTypeContainer<EntityHirschgeist> getContainer() {
        return ModEntities.HIRSCHGEIST;
    }

    @Override
    public EntityHirschgeist getImplementation() {
        return this;
    }

    public static class FlameAttackGoal
    extends Goal {
        private final EntityHirschgeist attacker;

        public FlameAttackGoal(EntityHirschgeist creature) {
            this.attacker = creature;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.attacker.m_5448_() != null && this.attacker.m_217043_().m_188503_(500) == 0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            this.attacker.m_21391_((Entity)this.attacker.m_5448_(), 20.0f, 20.0f);
            LivingEntity target = this.attacker.m_5448_();
            double d0 = target.m_20185_() - this.attacker.m_20185_();
            double d1 = target.m_20186_() - this.attacker.m_20188_() - 0.1;
            double d2 = target.m_20189_() - this.attacker.m_20189_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            EntityHirschgeistFireball ball = new EntityHirschgeistFireball((EntityType<? extends EntityHirschgeistFireball>)((EntityType)ModEntities.PROJECTILE_HIRSCHGEIST_FIREBALL.get()), this.attacker.m_9236_(), (LivingEntity)this.attacker);
            ball.m_6034_(target.m_20185_(), target.m_20188_() - 0.1, target.m_20189_());
            ball.m_6686_(d0, d1 + d3 * 0.2, d2, 0.5f, 2.0f);
            this.attacker.m_9236_().m_6269_(null, (Entity)this.attacker, SoundEvents.f_11862_, SoundSource.HOSTILE, 1.0f, 1.0f);
            this.attacker.m_9236_().m_7967_((Entity)ball);
        }
    }

    public static class SummonWispsGoal
    extends Goal {
        private final EntityHirschgeist parent;

        public SummonWispsGoal(EntityHirschgeist parent) {
            this.parent = parent;
        }

        public boolean m_8036_() {
            return this.parent.m_5448_() != null && this.parent.m_217043_().m_188503_(500) == 0 && this.parent.m_9236_().m_6443_(EntityWisp.class, this.parent.m_20191_().m_82400_(10.0), EntityWisp::isHirschgeistSummon).isEmpty();
        }

        public void m_8056_() {
            if (this.parent.m_9236_() instanceof ServerLevel) {
                this.parent.m_9236_().m_6269_(null, (Entity)this.parent, SoundEvents.f_11862_, SoundSource.HOSTILE, 1.0f, 1.0f);
                for (int i = 0; i < 3; ++i) {
                    EntityWisp wisp = (EntityWisp)ModEntities.WISP.getEntityType().m_262451_((ServerLevel)this.parent.m_9236_(), null, null, this.parent.m_20183_().m_7918_(Mth.m_14107_((double)((double)(this.parent.m_217043_().m_188503_(8) - 4) + 0.5)), Mth.m_14107_((double)((double)(this.parent.m_217043_().m_188503_(4) + 1) + 0.5)), Mth.m_14107_((double)((double)(this.parent.m_217043_().m_188503_(8) - 4) + 0.5))), MobSpawnType.REINFORCEMENT, false, false);
                    wisp.setHirschgeistSummon(true);
                    if (this.parent.m_5448_() != null) {
                        wisp.m_6710_(this.parent.m_5448_());
                    }
                    this.parent.m_9236_().m_7967_((Entity)wisp);
                }
            }
        }

        public boolean m_8045_() {
            return false;
        }
    }
}

