/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.entity;

import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import dev.itsmeow.whisperwoods.entity.EntityCreatureWithSelectiveTypes;
import dev.itsmeow.whisperwoods.entity.EntityCreatureWithTypes;
import dev.itsmeow.whisperwoods.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.whisperwoods.imdlib.entity.util.BiomeTypes;
import dev.itsmeow.whisperwoods.imdlib.entity.util.variant.EntityVariant;
import dev.itsmeow.whisperwoods.init.ModEntities;
import dev.itsmeow.whisperwoods.init.ModSounds;
import dev.itsmeow.whisperwoods.util.IOverrideCollisions;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;

public class EntityHidebehind
extends EntityCreatureWithSelectiveTypes
implements IOverrideCollisions<EntityCreatureWithTypes> {
    public static final ResourceKey<DamageType> HIDEBEHIND = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("whisperwoods", "hidebehind"));
    protected static final EntityDataAccessor<Integer> HIDING = SynchedEntityData.m_135353_(EntityHidebehind.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Boolean> OPEN = SynchedEntityData.m_135353_(EntityHidebehind.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Integer> ATTACK_SEQUENCE_TICKS = SynchedEntityData.m_135353_(EntityHidebehind.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Optional<UUID>> TARGET_UUID = SynchedEntityData.m_135353_(EntityHidebehind.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    public EntityHidebehind(EntityType<? extends EntityHidebehind> type, Level world) {
        super((EntityType<? extends EntityCreatureWithSelectiveTypes>)type, world);
        this.m_274367_(2.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new HideFromTargetGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new StalkTargetGoal(this, 0.5, 35.0f));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 0, false, false, this::isEntityAttackable));
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.HIDEBEHIND_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ModSounds.HIDEBEHIND_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.HIDEBEHIND_DEATH.get();
    }

    public boolean hasTargetUUID() {
        return ((Optional)this.m_20088_().m_135370_(TARGET_UUID)).isPresent();
    }

    public boolean isSequenceTarget(Player player) {
        Optional opt = (Optional)this.m_20088_().m_135370_(TARGET_UUID);
        return player != null && player.m_36316_().getId() != null && opt.isPresent() && player.m_36316_().getId().equals(opt.get());
    }

    public void setSequenceTarget(Player player) {
        this.m_20088_().m_135381_(TARGET_UUID, player == null || player.m_36316_().getId() == null ? Optional.empty() : Optional.of(player.m_36316_().getId()));
    }

    public int attackSequenceTicks() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_SEQUENCE_TICKS);
    }

    public void attackSequenceTicksDecrement() {
        this.f_19804_.m_135381_(ATTACK_SEQUENCE_TICKS, (Object)(this.attackSequenceTicks() - 1));
    }

    public void setAttackSequenceTicks(int value) {
        this.f_19804_.m_135381_(ATTACK_SEQUENCE_TICKS, (Object)value);
        if (value == 0) {
            this.setSequenceTarget(null);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7639_() == this.m_5448_() && this.attackSequenceTicks() > 0) {
            this.setAttackSequenceTicks(0);
        }
        if (!this.m_9236_().m_5776_()) {
            Player player;
            boolean isImmediate = source.m_7640_() instanceof Player;
            Object object = isImmediate ? (Player)source.m_7640_() : (player = source.m_7639_() instanceof Player ? (Player)source.m_7639_() : null);
            if (player != null) {
                int hiding = this.getHidingInt();
                boolean attackable = this.isEntityAttackable((LivingEntity)player);
                if (!attackable || hiding > 0) {
                    if (!player.m_7500_()) {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 15 * (hiding == 1 ? 5 : 20), 0));
                        if (player.m_20270_((Entity)this) < 3.0f) {
                            player.m_6469_(this.hideBehindDamageSource(), 1.0f);
                        }
                    }
                    HideFromTargetGoal.doTreeTick(this);
                    return super.m_6469_(source, amount * (hiding == 1 ? 0.5f : 0.25f));
                }
            }
        }
        return super.m_6469_(source, amount);
    }

    private DamageSource hideBehindDamageSource() {
        return new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(HIDEBEHIND), (Entity)this);
    }

    public void m_8119_() {
        BlockPos.MutableBlockPos bp;
        super.m_8119_();
        if (this.m_5448_() != null && !this.m_5448_().m_6084_()) {
            this.m_6710_(null);
        }
        if (this.m_20069_()) {
            int i = 12;
            int j = 2;
            bp = new BlockPos.MutableBlockPos();
            BlockPos destinationBlock = null;
            int k = 0;
            while (k <= j) {
                for (int l = 0; l < i; ++l) {
                    int i1 = 0;
                    while (i1 <= l) {
                        int j1;
                        int n = j1 = i1 < l && i1 > -l ? l : 0;
                        while (j1 <= l) {
                            bp.m_122190_((Vec3i)this.m_20183_()).m_122184_(i1, k - 1, j1);
                            if (this.m_9236_().m_8055_((BlockPos)bp).m_204336_(BlockTags.f_13106_)) {
                                destinationBlock = bp.m_7949_();
                            }
                            j1 = j1 > 0 ? -j1 : 1 - j1;
                        }
                        i1 = i1 > 0 ? -i1 : 1 - i1;
                    }
                }
                k = k > 0 ? -k : 1 - k;
            }
            boolean fixed = false;
            if (destinationBlock != null) {
                for (Direction dir : Direction.values()) {
                    if (fixed || !this.m_9236_().m_46859_(destinationBlock.m_121945_(dir)) && !this.m_9236_().m_8055_(destinationBlock.m_121945_(dir)).m_204336_(BlockTags.f_13035_)) continue;
                    destinationBlock = destinationBlock.m_121945_(dir);
                    fixed = true;
                }
            }
            if (fixed) {
                this.m_6021_(destinationBlock.m_123341_(), destinationBlock.m_123342_(), destinationBlock.m_123343_());
            }
        }
        if (!this.m_9236_().m_5776_()) {
            if (this.m_9236_().m_46461_() && this.m_9236_().m_45517_(LightLayer.SKY, this.m_20183_()) > 10) {
                this.setHiding(2);
            } else if (this.getHidingInt() == 2) {
                this.setHiding(1);
            }
            if (!this.isBeingViewed() && this.getHidingInt() == 1) {
                this.setHiding(false);
            }
        }
        float atkTicks = this.attackSequenceTicks();
        if (this.m_5448_() != null && this.m_5448_().m_20280_((Entity)this) < 5.0 && atkTicks == 0.0f && !this.getHiding() && this.isEntityAttackable(this.m_5448_()) && (bp = this.m_5448_()) instanceof Player) {
            Player player = (Player)bp;
            if (!this.m_9236_().f_46443_ && this.m_217043_().m_188503_(20) == 0) {
                if ((double)player.m_21223_() > this.m_21051_(Attributes.f_22281_).m_22135_()) {
                    this.m_7327_((Entity)player);
                } else {
                    this.setAttackSequenceTicks(40);
                    this.setSequenceTarget(player);
                }
            }
        }
        if (atkTicks > 0.0f) {
            if (!this.getOpen()) {
                this.setOpen(true);
            }
            ServerPlayer target = null;
            if (this.m_5448_() instanceof ServerPlayer) {
                target = (ServerPlayer)this.m_5448_();
            } else if (Platform.getEnvironment() == Env.CLIENT) {
                Supplier<Supplier> s = () -> ClientSafeLogic::getTargetClient;
                target = (Player)s.get().get();
            }
            if (this.isSequenceTarget((Player)target)) {
                target.m_20334_(0.0, 0.0, 0.0);
                double d0 = this.m_20185_() - target.m_20185_();
                double d1 = this.m_20189_() - target.m_20189_();
                float angle = (float)(Mth.m_14136_((double)d1, (double)d0) * 57.2957763671875) - 90.0f;
                target.m_19890_(target.m_20185_(), target.m_20186_(), target.m_20189_(), angle, 0.0f);
                double e0 = target.m_20185_() - this.m_20185_();
                double e1 = target.m_20189_() - this.m_20189_();
                float angle1 = (float)(Mth.m_14136_((double)e1, (double)e0) * 57.2957763671875) - 90.0f;
                this.m_19890_(this.m_20185_(), this.m_20186_(), this.m_20189_(), angle1, 0.0f);
                this.m_146922_(angle1);
                if (this.attackSequenceTicks() == 40) {
                    target.m_5496_((SoundEvent)ModSounds.HIDEBEHIND_SCARE.get(), 2.0f, 1.0f);
                }
                this.m_21563_().m_24960_((Entity)target, 360.0f, 360.0f);
            }
            this.attackSequenceTicksDecrement();
            if (atkTicks - 1.0f == 0.0f && !this.m_9236_().m_5776_()) {
                this.setOpen(false);
                if (this.m_5448_() != null) {
                    this.m_7327_((Entity)target);
                    this.m_6710_(null);
                    this.m_20088_().m_135381_(TARGET_UUID, Optional.empty());
                }
            }
        }
        if (atkTicks == 0.0f && this.getOpen()) {
            this.setOpen(false);
        }
    }

    public boolean isEntityAttackable(LivingEntity target) {
        Item mainItem = target.m_21120_(InteractionHand.MAIN_HAND).m_41720_();
        Item offItem = target.m_21120_(InteractionHand.OFF_HAND).m_41720_();
        return !(this.m_9236_().m_46803_(target.m_20183_()) >= 8 || mainItem instanceof BlockItem && ((BlockItem)mainItem).m_40614_() instanceof TorchBlock || offItem instanceof BlockItem && ((BlockItem)offItem).m_40614_() instanceof TorchBlock);
    }

    protected float m_6108_() {
        return 1.0f;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean getHiding() {
        return this.getHidingInt() != 0;
    }

    public int getHidingInt() {
        return (Integer)this.m_20088_().m_135370_(HIDING);
    }

    public void setHiding(boolean hiding) {
        this.m_20088_().m_135381_(HIDING, (Object)(hiding ? 1 : 0));
    }

    public void setHiding(int hiding) {
        this.m_20088_().m_135381_(HIDING, (Object)hiding);
    }

    public boolean getOpen() {
        return (Boolean)this.m_20088_().m_135370_(OPEN);
    }

    public void setOpen(boolean open) {
        this.m_20088_().m_135381_(OPEN, (Object)open);
    }

    public boolean isBeingViewed() {
        return Math.abs(this.getTargetViewingAngle()) <= 50.0;
    }

    public double getTargetViewingAngle() {
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return -1000.0;
        }
        return Mth.m_14175_((double)(this.getRequiredViewingAngle() - (double)Mth.m_14177_((float)this.m_5448_().m_146908_())));
    }

    public double getRequiredViewingAngle() {
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return -1000.0;
        }
        return Mth.m_14175_((double)(90.0 + Math.toDegrees(Math.atan2(target.m_20189_() - this.m_20189_(), target.m_20185_() - this.m_20185_()))));
    }

    public boolean m_7327_(Entity entity) {
        boolean flag;
        int i;
        float f = (float)this.m_21051_(Attributes.f_22281_).m_22135_();
        float f1 = (float)this.m_21051_(Attributes.f_22282_).m_22135_();
        if (entity instanceof LivingEntity) {
            f += EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)((LivingEntity)entity).m_6336_());
            f1 += (float)EnchantmentHelper.m_44894_((LivingEntity)this);
        }
        if ((i = EnchantmentHelper.m_44914_((LivingEntity)this)) > 0) {
            entity.m_20254_(i * 4);
        }
        if (flag = entity.m_6469_(this.hideBehindDamageSource(), f)) {
            if (f1 > 0.0f && entity instanceof LivingEntity) {
                ((LivingEntity)entity).m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            this.m_19970_((LivingEntity)this, entity);
            this.m_21335_(entity);
        }
        return flag;
    }

    public boolean m_5830_() {
        return this.insideOpaque();
    }

    @Override
    public boolean canPassThrough(BlockState state) {
        return state.m_204336_(BlockTags.f_13035_);
    }

    @Override
    public boolean preventSuffocation(BlockState state) {
        return state.m_204336_(BlockTags.f_13106_) || this.canPassThrough(state);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HIDING, (Object)0);
        this.f_19804_.m_135372_(OPEN, (Object)false);
        this.f_19804_.m_135372_(ATTACK_SEQUENCE_TICKS, (Object)0);
        this.f_19804_.m_135372_(TARGET_UUID, Optional.empty());
    }

    @Override
    public boolean m_6785_(double range) {
        return this.m_9236_().m_46461_() && super.m_6785_(range);
    }

    protected PathNavigation m_6037_(Level world) {
        return new HidebehindGroundNavigator((Mob)this, world);
    }

    @Override
    public EntityTypeContainer<EntityHidebehind> getContainer() {
        return ModEntities.HIDEBEHIND;
    }

    @Override
    public String[] getTypesFor(ResourceKey<Biome> biomeKey, Biome biome, Set<BiomeTypes.Type> types, MobSpawnType reason) {
        if (biomeKey == Biomes.f_186764_) {
            return new String[]{"mega_taiga", "mega_taiga", "mega_taiga", "darkforest"};
        }
        if (types.contains(BiomeTypes.CONIFEROUS)) {
            return new String[]{"coniferous", "coniferous", "coniferous", "coniferous", "black", "darkforest"};
        }
        if (types.contains(BiomeTypes.FOREST)) {
            return new String[]{"forest", "black", "darkforest"};
        }
        return new String[]{"black", "coniferous", "darkforest", "forest", "mega_taiga"};
    }

    public static class HideFromTargetGoal
    extends Goal {
        private final EntityHidebehind hidebehind;

        public HideFromTargetGoal(EntityHidebehind hb) {
            this.hidebehind = hb;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return this.hidebehind.m_5448_() != null && (this.hidebehind.isBeingViewed() || !this.hidebehind.isEntityAttackable(this.hidebehind.m_5448_())) && this.hidebehind.attackSequenceTicks() == 0;
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8041_() {
            if (this.hidebehind.getHidingInt() == 1) {
                this.hidebehind.setHiding(false);
            }
        }

        public void m_8056_() {
            if (!this.hidebehind.getHiding()) {
                this.hidebehind.setHiding(true);
            }
            this.hidebehind.m_21573_().m_26573_();
        }

        public void m_8037_() {
            HideFromTargetGoal.doTreeTick(this.hidebehind);
        }

        public static void doTreeTick(EntityHidebehind hidebehind) {
            hidebehind.m_21573_().m_26573_();
            boolean nearTree = false;
            for (Direction dir : Direction.values()) {
                if (nearTree) continue;
                if (hidebehind.m_9236_().m_8055_(hidebehind.m_20183_().m_121945_(dir)).m_204336_(BlockTags.f_13106_)) {
                    nearTree = true;
                }
                if (!hidebehind.m_9236_().m_8055_(hidebehind.m_20183_().m_6630_(3).m_121945_(dir)).m_204336_(BlockTags.f_13035_)) continue;
                nearTree = true;
            }
            if (!nearTree && hidebehind.m_217043_().m_188503_(5) == 0) {
                int i = 12;
                int j = 2;
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                BlockPos destinationBlock = null;
                int k = 0;
                while (k <= j) {
                    for (int l = 0; l < i; ++l) {
                        int i1 = 0;
                        while (i1 <= l) {
                            int j1;
                            int n = j1 = i1 < l && i1 > -l ? l : 0;
                            while (j1 <= l) {
                                blockpos$mutableblockpos.m_122190_((Vec3i)hidebehind.m_20183_()).m_122184_(i1, k - 1, j1);
                                if (hidebehind.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos).m_204336_(BlockTags.f_13106_)) {
                                    destinationBlock = blockpos$mutableblockpos.m_7949_();
                                }
                                j1 = j1 > 0 ? -j1 : 1 - j1;
                            }
                            i1 = i1 > 0 ? -i1 : 1 - i1;
                        }
                    }
                    k = k > 0 ? -k : 1 - k;
                }
                boolean fixed = false;
                if (destinationBlock != null) {
                    for (Direction dir : Direction.values()) {
                        if (fixed || !hidebehind.m_9236_().m_46859_(destinationBlock.m_121945_(dir)) && !hidebehind.m_9236_().m_8055_(destinationBlock.m_121945_(dir)).m_204336_(BlockTags.f_13035_)) continue;
                        destinationBlock = destinationBlock.m_121945_(dir);
                        fixed = true;
                    }
                }
                if (fixed) {
                    hidebehind.m_6021_(destinationBlock.m_123341_(), destinationBlock.m_123342_(), destinationBlock.m_123343_());
                }
            }
        }
    }

    public static class StalkTargetGoal
    extends Goal {
        private final EntityHidebehind hidebehind;
        private LivingEntity target;
        private final double speed;
        private final float maxTargetDistance;

        public StalkTargetGoal(EntityHidebehind creature, double speedIn, float targetMaxDistance) {
            this.hidebehind = creature;
            this.speed = speedIn;
            this.maxTargetDistance = targetMaxDistance;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            this.target = this.hidebehind.m_5448_();
            if (this.target == null || this.target.m_20280_((Entity)this.hidebehind) > (double)(this.maxTargetDistance * this.maxTargetDistance)) {
                return false;
            }
            Vec3 vec3d = DefaultRandomPos.m_148412_((PathfinderMob)this.hidebehind, (int)16, (int)7, (Vec3)new Vec3(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_()), (double)1.5707963267948966);
            return vec3d != null && this.hidebehind.isEntityAttackable(this.target) && this.hidebehind.attackSequenceTicks() <= 0 && !this.hidebehind.getHiding();
        }

        public boolean m_8045_() {
            return !this.hidebehind.getHiding() && !this.hidebehind.m_21573_().m_26571_() && this.target.m_6084_() && this.target.m_20280_((Entity)this.hidebehind) < (double)(this.maxTargetDistance * this.maxTargetDistance) && this.hidebehind.attackSequenceTicks() == 0 && this.hidebehind.isEntityAttackable(this.target);
        }

        public void m_8041_() {
            this.target = null;
            this.hidebehind.m_21573_().m_26573_();
        }

        public void m_8056_() {
            this.hidebehind.f_21365_.m_24960_((Entity)this.target, 1000.0f, 1000.0f);
            this.hidebehind.m_21573_().m_5624_((Entity)this.hidebehind.m_5448_(), this.speed);
        }
    }

    public static class HidebehindGroundNavigator
    extends GroundPathNavigation {
        public HidebehindGroundNavigator(Mob entityliving, Level world) {
            super(entityliving, world);
        }

        protected PathFinder m_5532_(int i1) {
            this.f_26508_ = new HidebehindNodeProcessor();
            this.f_26508_.m_77351_(true);
            return new PathFinder(this.f_26508_, i1);
        }

        public static class HidebehindNodeProcessor
        extends WalkNodeEvaluator {
            protected BlockPathTypes m_264405_(BlockGetter reader, BlockPos pos, BlockPathTypes typeIn) {
                return typeIn == BlockPathTypes.LEAVES ? BlockPathTypes.OPEN : super.m_264405_(reader, pos, typeIn);
            }
        }
    }

    public static class HidebehindVariant
    extends EntityVariant {
        private final ResourceLocation openTexture;

        public HidebehindVariant(String nameTexture) {
            super("whisperwoods", nameTexture, "hidebehind_" + nameTexture);
            this.openTexture = new ResourceLocation("whisperwoods", "textures/entity/hidebehind_" + nameTexture + "_open.png");
        }

        @Override
        public ResourceLocation getTexture(Entity entity) {
            if (entity instanceof EntityHidebehind) {
                return ((EntityHidebehind)entity).getOpen() ? this.openTexture : this.texture;
            }
            return this.texture;
        }
    }

    public static class ClientSafeLogic {
        public static Player getTargetClient() {
            return Minecraft.m_91087_().f_91074_;
        }
    }
}

