/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.client.init;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.architectury.event.events.client.ClientReloadShadersEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.itsmeow.whisperwoods.WhisperwoodsMod;
import dev.itsmeow.whisperwoods.client.particle.FlameParticle;
import dev.itsmeow.whisperwoods.client.particle.WispParticle;
import dev.itsmeow.whisperwoods.client.renderer.entity.RenderHirschgeist;
import dev.itsmeow.whisperwoods.client.renderer.entity.RenderWisp;
import dev.itsmeow.whisperwoods.client.renderer.entity.layer.LayerEyesSwitching;
import dev.itsmeow.whisperwoods.client.renderer.entity.model.ModelHidebehind;
import dev.itsmeow.whisperwoods.client.renderer.entity.model.ModelHirschgeist;
import dev.itsmeow.whisperwoods.client.renderer.entity.model.ModelMoth;
import dev.itsmeow.whisperwoods.client.renderer.entity.model.ModelZotzpyre;
import dev.itsmeow.whisperwoods.client.renderer.tile.RenderHGSkull;
import dev.itsmeow.whisperwoods.client.renderer.tile.RenderTileGhostLight;
import dev.itsmeow.whisperwoods.client.renderer.tile.RenderTileHandOfFate;
import dev.itsmeow.whisperwoods.client.renderer.tile.model.ModelHGSkull;
import dev.itsmeow.whisperwoods.client.renderer.tile.model.ModelHGSkullMask;
import dev.itsmeow.whisperwoods.client.renderer.tile.model.ModelHandOfFate;
import dev.itsmeow.whisperwoods.entity.EntityHidebehind;
import dev.itsmeow.whisperwoods.entity.projectile.EntityHirschgeistFireball;
import dev.itsmeow.whisperwoods.imdlib.client.IMDLibClient;
import dev.itsmeow.whisperwoods.imdlib.client.render.RenderFactory;
import dev.itsmeow.whisperwoods.init.ModBlockEntities;
import dev.itsmeow.whisperwoods.init.ModBlocks;
import dev.itsmeow.whisperwoods.init.ModEntities;
import dev.itsmeow.whisperwoods.init.ModParticles;
import dev.itsmeow.whisperwoods.init.ModResources;
import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.apache.logging.log4j.LogManager;

public class ClientLifecycleHandler {
    public static RenderFactory R = IMDLibClient.getRenderRegistry("whisperwoods");

    public static void clientInit() {
        ClientReloadShadersEvent.EVENT.register((resourceManager, shadersSink) -> {
            try {
                shadersSink.registerShader(new ShaderInstance(resourceManager, "ww_rendertype_eyes_custom", DefaultVertexFormat.f_85812_), shaderInstance -> {
                    RenderTypeAddition.eyesCustomShader = shaderInstance;
                });
            }
            catch (IOException e) {
                WhisperwoodsMod.LOGGER.error((Object)e);
            }
        });
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)ModBlockEntities.GHOST_LIGHT.get()), RenderTileGhostLight::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)ModBlockEntities.HG_SKULL.get()), RenderHGSkull::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)ModBlockEntities.HAND_OF_FATE.get()), RenderTileHandOfFate::new);
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)ModBlocks.WISP_LANTERN_BLUE.get(), (Block)ModBlocks.WISP_LANTERN_GREEN.get(), (Block)ModBlocks.WISP_LANTERN_ORANGE.get(), (Block)ModBlocks.WISP_LANTERN_PURPLE.get(), (Block)ModBlocks.WISP_LANTERN_YELLOW.get()});
        if (Platform.isFabric()) {
            ClientLifecycleHandler.registerEntityRenders();
        }
        LogManager.getLogger().info("Increasing wispiness of wisps...");
    }

    public static void registerEntityRenders() {
        R.addRender(ModEntities.MOTH::getEntityType, 0.1f, r -> r.tVariant().mSingle(ModelMoth::new, "moth").simpleScale(e -> Float.valueOf(e.m_6972_((Pose)Pose.STANDING).f_20377_)));
        R.addRender(ModEntities.HIDEBEHIND::getEntityType, 0.75f, r -> r.tVariant().mSingle(ModelHidebehind::new, "hidebehind").renderLayer((e, a, b, c, t) -> RenderType.m_110454_((ResourceLocation)t, (boolean)true)).layer(t -> new LayerEyesSwitching(t, EntityHidebehind::getOpen, ModResources.HIDEBEHIND_OPEN_GLOW, ModResources.HIDEBEHIND_GLOW)));
        RenderFactory.addRender(ModEntities.WISP::getEntityType, RenderWisp::new);
        RenderFactory.addRender(ModEntities.HIRSCHGEIST::getEntityType, RenderHirschgeist::new);
        RenderFactory.addRender(() -> ModEntities.PROJECTILE_HIRSCHGEIST_FIREBALL.get(), t -> new EntityRenderer<EntityHirschgeistFireball>(t){

            public void render(EntityHirschgeistFireball entity, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
                if (!Minecraft.m_91087_().m_91104_() && System.nanoTime() - entity.lastSpawn >= 10000000L) {
                    entity.lastSpawn = System.nanoTime();
                    for (int j = 0; j < 5; ++j) {
                        double xO = entity.m_9236_().m_213780_().m_188501_() * 2.0f - 1.0f;
                        double yO = entity.m_9236_().m_213780_().m_188501_() * 2.0f - 1.0f;
                        double zO = entity.m_9236_().m_213780_().m_188501_() * 2.0f - 1.0f;
                        entity.m_9236_().m_7106_((ParticleOptions)ModParticles.SOUL_FLAME.get(), entity.m_20185_() + xO, entity.m_20186_() + yO, entity.m_20189_() + zO, 0.0, (double)0.005f, 0.0);
                    }
                }
            }

            public ResourceLocation getTextureLocation(EntityHirschgeistFireball entity) {
                return null;
            }
        });
        R.addRender(ModEntities.ZOTZPYRE::getEntityType, 0.4f, r -> r.tVariant().mSingle(ModelZotzpyre::new, "zotzpyre").layer(t -> new LayerEyesSwitching(t, e -> "6".equals(e.getVariantNameOrEmpty()), ModResources.ZOTZPYRE_6_EYES, ModResources.ZOTZPYRE_EYES)));
    }

    public static void layerDefinitions(ImmutableMap.Builder<ModelLayerLocation, LayerDefinition> b) {
        BiConsumer<String, LayerDefinition> r = (k, l) -> b.put((Object)new ModelLayerLocation(new ResourceLocation("whisperwoods", k), "main"), l);
        r.accept("moth", ModelMoth.createBodyLayer());
        r.accept("hidebehind", ModelHidebehind.createBodyLayer());
        r.accept("hirschgeist", ModelHirschgeist.createBodyLayer());
        r.accept("zotzpyre", ModelZotzpyre.createBodyLayer());
        r.accept("hirschgeist_skull", ModelHGSkull.createBodyLayer());
        r.accept("hand_of_fate", ModelHandOfFate.createBodyLayer());
        r.accept("hirschgeist_skull_mask", ModelHGSkullMask.createBodyLayer());
    }

    public static void registerParticles(BiConsumer<ParticleType<?>, Function<SpriteSet, ParticleProvider<?>>> register) {
        register.accept((ParticleType)ModParticles.WISP.get(), WispParticle.WispFactory::new);
        register.accept((ParticleType)ModParticles.FLAME.get(), FlameParticle.FlameFactory::new);
        register.accept((ParticleType)ModParticles.SOUL_FLAME.get(), FlameParticle.FlameFactory::new);
    }

    public static class RenderTypeAddition
    extends RenderType {
        private static ShaderInstance eyesCustomShader;
        private static final RenderStateShard.ShaderStateShard RENDERTYPE_WW_EYES_ENTITY_CUTOUT_NO_CULL_DEPTH_MASK_OFF;
        private static final Function<ResourceLocation, RenderType> WW_EYES_ENTITY_CUTOUT_NO_CULL_DEPTH_MASK_OFF;

        private RenderTypeAddition() {
            super(null, null, VertexFormat.Mode.QUADS, 0, false, false, null, null);
        }

        public static RenderType getEyesEntityCutoutNoCullDepthMaskOff(ResourceLocation l) {
            return WW_EYES_ENTITY_CUTOUT_NO_CULL_DEPTH_MASK_OFF.apply(l);
        }

        static {
            RENDERTYPE_WW_EYES_ENTITY_CUTOUT_NO_CULL_DEPTH_MASK_OFF = new RenderStateShard.ShaderStateShard(() -> eyesCustomShader);
            WW_EYES_ENTITY_CUTOUT_NO_CULL_DEPTH_MASK_OFF = Util.m_143827_(resourceLocation -> RenderTypeAddition.m_173215_((String)"ww_eyes_entity_cutout_no_cull_depth_mask_off", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RENDERTYPE_WW_EYES_ENTITY_CUTOUT_NO_CULL_DEPTH_MASK_OFF).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(resourceLocation, false, false)).m_110661_(f_110110_).m_110685_(f_110135_).m_110687_(f_110115_).m_110671_(f_110153_).m_110677_(f_110154_).m_110691_(false)));
        }
    }
}

