/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.block;

import dev.itsmeow.whisperwoods.block.GhostLightBlock;
import dev.itsmeow.whisperwoods.blockentity.HandOfFateBlockEntity;
import dev.itsmeow.whisperwoods.init.ModBlockEntities;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HandOfFateBlock
extends Block
implements EntityBlock {
    public static final EnumProperty<Orientation> ROTATION = EnumProperty.m_61587_((String)"rotation", Orientation.class);
    private static final VoxelShape SHAPE;

    public HandOfFateBlock(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(ROTATION, (Comparable)((Object)Orientation.NORTH))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public boolean isLit(Level world, BlockPos pos) {
        return world.m_8055_(pos).m_60734_() == this && world.m_8055_(pos.m_7494_()).m_60734_() instanceof GhostLightBlock;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity te = worldIn.m_7702_(pos);
            if (te instanceof HandOfFateBlockEntity) {
                ((HandOfFateBlockEntity)te).dropItems(worldIn, pos);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity te;
        ItemStack held = player.m_21120_(hand);
        boolean lit = this.isLit(worldIn, pos);
        if (held.m_41720_() instanceof BlockItem && ((BlockItem)held.m_41720_()).m_40614_() instanceof GhostLightBlock && !lit) {
            BlockItem i = (BlockItem)held.m_41720_();
            if (worldIn.m_46859_(pos.m_7494_())) {
                if (!player.m_7500_()) {
                    held.m_41774_(1);
                }
                worldIn.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11859_, SoundSource.BLOCKS, 1.0f, 1.0f);
                worldIn.m_46597_(pos.m_7494_(), i.m_40614_().m_49966_());
                return InteractionResult.CONSUME;
            }
            return InteractionResult.FAIL;
        }
        if (worldIn.m_7702_(pos) != null && (te = worldIn.m_7702_(pos)) instanceof HandOfFateBlockEntity) {
            HandOfFateBlockEntity tehof = (HandOfFateBlockEntity)te;
            return tehof.onBlockActivated(state, worldIn, pos, player, hand, hit);
        }
        return InteractionResult.PASS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ROTATION, BlockStateProperties.f_61362_});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return Block.m_49863_((LevelReader)worldIn, (BlockPos)pos.m_7495_(), (Direction)Direction.UP) && (!worldIn.m_8055_(pos.m_7494_()).m_60815_() || worldIn.m_8055_(pos.m_7494_()).m_60734_() instanceof GhostLightBlock);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_(ROTATION, (Comparable)((Object)Orientation.fromAngle((360.0f + context.m_7074_() % 360.0f) % 360.0f)))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new HandOfFateBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.m_5776_() ? null : (blockEntityType == ModBlockEntities.HAND_OF_FATE.get() ? new BlockEntityTicker<T>(){

            public void m_155252_(Level level, BlockPos blockPos, BlockState blockState, T blockEntity) {
                if (blockEntity instanceof HandOfFateBlockEntity) {
                    HandOfFateBlockEntity b = (HandOfFateBlockEntity)((Object)blockEntity);
                    HandOfFateBlockEntity.serverTick(level, blockPos, blockState, b);
                }
            }
        } : null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        Style gIS = Style.f_131099_.m_131157_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(true));
        String tooltipPrefix = "block.whisperwoods.hand_of_fate.tooltip.";
        String recipePrefix = tooltipPrefix + "recipe.";
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)(tooltipPrefix + "recipehint")).m_6270_(gIS));
            for (String recipeKey : HandOfFateBlockEntity.RECIPES.keySet()) {
                HandOfFateBlockEntity.HOFRecipe recipe = (HandOfFateBlockEntity.HOFRecipe)HandOfFateBlockEntity.RECIPES.get((Object)recipeKey);
                tooltip.add((Component)Component.m_237110_((String)("block.whisperwoods.hand_of_fate.tooltip.recipe_format" + (I18n.m_118936_((String)(recipePrefix + recipeKey + ".hint")) ? "_hint" : "")), (Object[])new Object[]{Component.m_237115_((String)(recipePrefix + recipeKey)).m_6270_(Style.f_131099_.m_131157_(recipe.getColor()).m_131136_(Boolean.valueOf(recipe.isBold()))), Component.m_237115_((String)recipe.getFirst().m_5524_()).m_130940_(ChatFormatting.WHITE), Component.m_237115_((String)(recipePrefix + recipeKey + ".hint")).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.GRAY));
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)(tooltipPrefix + "shiftdown")).m_6270_(gIS));
        }
    }

    static {
        double d = 0.1875;
        SHAPE = Shapes.m_83048_((double)d, (double)0.0, (double)d, (double)(1.0 - d), (double)1.55, (double)(1.0 - d));
    }

    public static enum Orientation implements StringRepresentable
    {
        SOUTH(Direction.SOUTH),
        SOUTHWEST(Direction.SOUTH, Direction.WEST),
        WEST(Direction.WEST),
        NORTHWEST(Direction.NORTH, Direction.WEST),
        NORTH(Direction.NORTH),
        NORTHEAST(Direction.NORTH, Direction.EAST),
        EAST(Direction.EAST),
        SOUTHEAST(Direction.SOUTH, Direction.EAST);

        Direction[] directions;

        private Orientation(Direction ... directions) {
            this.directions = directions;
        }

        public static Orientation nearestYaw(float yaw) {
            return null;
        }

        public static Orientation fromAngle(double angle) {
            return Orientation.byIndex(Mth.m_14107_((double)(angle / 45.0 + 0.5)));
        }

        public static Orientation byIndex(int index) {
            return Orientation.values()[Mth.m_14040_((int)(index % 8))];
        }

        public String m_7912_() {
            return this.name().toLowerCase();
        }

        public float getHorizontalAngle() {
            return (float)this.ordinal() * 45.0f;
        }
    }
}

