/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.ai.poi;

import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import me.jellysquid.mods.lithium.common.util.Distances;
import me.jellysquid.mods.lithium.common.world.interests.PointOfInterestSetExtended;
import me.jellysquid.mods.lithium.common.world.interests.PointOfInterestStorageExtended;
import me.jellysquid.mods.lithium.common.world.interests.RegionBasedStorageSectionExtended;
import me.jellysquid.mods.lithium.common.world.interests.iterator.NearbyPointOfInterestStream;
import me.jellysquid.mods.lithium.common.world.interests.iterator.SinglePointOfInterestTypeFilter;
import me.jellysquid.mods.lithium.common.world.interests.iterator.SphereChunkOrderedPoiSetSpliterator;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2784;
import net.minecraft.class_2826;
import net.minecraft.class_4076;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_4157;
import net.minecraft.class_4158;
import net.minecraft.class_4180;
import net.minecraft.class_4284;
import net.minecraft.class_5455;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_5996;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={class_4153.class})
public abstract class PointOfInterestStorageMixin
extends class_4180<class_4157>
implements PointOfInterestStorageExtended {
    public PointOfInterestStorageMixin(Path path, Function<Runnable, Codec<class_4157>> codecFactory, Function<Runnable, class_4157> factory, DataFixer dataFixer, class_4284 dataFixTypes, boolean dsync, class_5455 dynamicRegistryManager, class_5539 world) {
        super(path, codecFactory, factory, dataFixer, dataFixTypes, dsync, dynamicRegistryManager, world);
    }

    @Overwrite
    @class_5996
    public Stream<class_4156> method_19123(Predicate<class_6880<class_4158>> predicate, class_1923 pos, class_4153.class_4155 status) {
        return ((RegionBasedStorageSectionExtended)((Object)this)).getWithinChunkColumn(pos.field_9181, pos.field_9180).flatMap(set -> set.method_19150(predicate, status));
    }

    @Overwrite
    public Optional<class_2338> method_20005(Predicate<class_6880<class_4158>> typePredicate, Predicate<class_2338> posPredicate, class_4153.class_4155 status, class_2338 pos, int radius, class_5819 rand) {
        ArrayList<class_4156> list = this.withinSphereChunkSectionSorted(typePredicate, pos, radius, status);
        for (int i = list.size() - 1; i >= 0; --i) {
            class_4156 currentPOI = list.set(rand.method_43048(i + 1), list.get(i));
            list.set(i, currentPOI);
            if (!posPredicate.test(currentPOI.method_19141())) continue;
            return Optional.of(currentPOI.method_19141());
        }
        return Optional.empty();
    }

    @Overwrite
    public Optional<class_2338> method_20006(Predicate<class_6880<class_4158>> predicate, class_2338 pos, int radius, class_4153.class_4155 status) {
        return this.method_34712(predicate, null, pos, radius, status);
    }

    @Overwrite
    public Optional<class_2338> method_34712(Predicate<class_6880<class_4158>> predicate, Predicate<class_2338> posPredicate, class_2338 pos, int radius, class_4153.class_4155 status) {
        Stream<class_4156> pointOfInterestStream = this.streamOutwards(pos, radius, status, true, false, predicate, posPredicate == null ? null : poi -> posPredicate.test(poi.method_19141()));
        return pointOfInterestStream.map(class_4156::method_19141).findFirst();
    }

    @Overwrite
    public long method_20252(Predicate<class_6880<class_4158>> predicate, class_2338 pos, int radius, class_4153.class_4155 status) {
        return this.withinSphereChunkSectionSorted(predicate, pos, radius, status).size();
    }

    @Overwrite
    public Stream<class_4156> method_19125(Predicate<class_6880<class_4158>> predicate, class_2338 sphereOrigin, int radius, class_4153.class_4155 status) {
        return this.withinSphereChunkSectionSortedStream(predicate, sphereOrigin, radius, status);
    }

    @Override
    public Optional<class_4156> findNearestForPortalLogic(class_2338 origin, int radius, class_6880<class_4158> type, class_4153.class_4155 status, Predicate<class_4156> afterSortPredicate, class_2784 worldBorder) {
        boolean worldBorderIsFarAway = worldBorder == null || worldBorder.method_11961((double)origin.method_10263(), (double)origin.method_10260()) > (double)(radius + 3);
        Predicate<class_4156> poiPredicateAfterSorting = worldBorderIsFarAway ? afterSortPredicate : poi -> worldBorder.method_11952(poi.method_19141()) && afterSortPredicate.test((class_4156)poi);
        return this.streamOutwards(origin, radius, status, true, true, new SinglePointOfInterestTypeFilter(type), poiPredicateAfterSorting).findFirst();
    }

    private Stream<class_4156> withinSphereChunkSectionSortedStream(Predicate<class_6880<class_4158>> predicate, class_2338 origin, int radius, class_4153.class_4155 status) {
        double radiusSq = radius * radius;
        RegionBasedStorageSectionExtended storage = (RegionBasedStorageSectionExtended)((Object)this);
        Stream<Stream<class_4157>> stream = StreamSupport.stream(new SphereChunkOrderedPoiSetSpliterator(radius, origin, storage), false);
        return stream.flatMap(setStream -> setStream.flatMap(set -> set.method_19150(predicate, status).filter(point -> Distances.isWithinCircleRadius(origin, radiusSq, point.method_19141()))));
    }

    private ArrayList<class_4156> withinSphereChunkSectionSorted(Predicate<class_6880<class_4158>> predicate, class_2338 origin, int radius, class_4153.class_4155 status) {
        double radiusSq = radius * radius;
        int minChunkX = origin.method_10263() - radius - 1 >> 4;
        int minChunkZ = origin.method_10260() - radius - 1 >> 4;
        int maxChunkX = origin.method_10263() + radius + 1 >> 4;
        int maxChunkZ = origin.method_10260() + radius + 1 >> 4;
        RegionBasedStorageSectionExtended storage = (RegionBasedStorageSectionExtended)((Object)this);
        ArrayList<class_4156> points = new ArrayList<class_4156>();
        Consumer<class_4156> collector = point -> {
            if (Distances.isWithinCircleRadius(origin, radiusSq, point.method_19141())) {
                points.add((class_4156)point);
            }
        };
        for (int x = minChunkX; x <= maxChunkX; ++x) {
            for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                for (class_4157 set : storage.getInChunkColumn(x, z)) {
                    ((PointOfInterestSetExtended)set).collectMatchingPoints(predicate, status, collector);
                }
            }
        }
        return points;
    }

    private Stream<class_4156> streamOutwards(class_2338 origin, int radius, class_4153.class_4155 status, boolean useSquareDistanceLimit, boolean preferNegativeY, Predicate<class_6880<class_4158>> typePredicate, @Nullable Predicate<class_4156> afterSortingPredicate) {
        RegionBasedStorageSectionExtended storage = (RegionBasedStorageSectionExtended)((Object)this);
        return StreamSupport.stream(new NearbyPointOfInterestStream(typePredicate, status, useSquareDistanceLimit, preferNegativeY, afterSortingPredicate, origin, radius, storage), false);
    }

    @Shadow
    protected abstract void method_20348(class_2826 var1, class_4076 var2, BiConsumer<class_2338, class_4158> var3);
}

