/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommand;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.turtle.core.MoveDirection;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import dan200.computercraft.shared.util.WorldUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3619;

public class TurtleMoveCommand
implements TurtleCommand {
    private final MoveDirection direction;

    public TurtleMoveCommand(MoveDirection direction) {
        this.direction = direction;
    }

    @Override
    public TurtleCommandResult execute(ITurtleAccess turtle) {
        class_2350 direction = this.direction.toWorldDir(turtle);
        class_3218 level = (class_3218)turtle.getLevel();
        class_2338 oldPosition = turtle.getPosition();
        class_2338 newPosition = oldPosition.method_10093(direction);
        TurtlePlayer turtlePlayer = TurtlePlayer.getWithPosition(turtle, oldPosition, direction);
        TurtleCommandResult canEnterResult = TurtleMoveCommand.canEnter(turtlePlayer, level, newPosition);
        if (!canEnterResult.isSuccess()) {
            return canEnterResult;
        }
        class_2680 existingState = level.method_8320(newPosition);
        if (!WorldUtil.isEmptyBlock(existingState) && !existingState.method_45474()) {
            return TurtleCommandResult.failure("Movement obstructed");
        }
        class_265 turtleShape = level.method_8320(oldPosition).method_26220((class_1922)level, oldPosition).method_1096((double)newPosition.method_10263(), (double)newPosition.method_10264(), (double)newPosition.method_10260());
        if (!level.method_8611(null, turtleShape) && !this.canPushEntities((class_1937)level, turtleShape.method_1107())) {
            return TurtleCommandResult.failure("Movement obstructed");
        }
        if (turtle.isFuelNeeded() && turtle.getFuelLevel() < 1) {
            return TurtleCommandResult.failure("Out of fuel");
        }
        if (!turtle.teleportTo((class_1937)level, newPosition)) {
            return TurtleCommandResult.failure("Movement failed");
        }
        turtle.consumeFuel(1);
        switch (this.direction) {
            case FORWARD: {
                turtle.playAnimation(TurtleAnimation.MOVE_FORWARD);
                break;
            }
            case BACK: {
                turtle.playAnimation(TurtleAnimation.MOVE_BACK);
                break;
            }
            case UP: {
                turtle.playAnimation(TurtleAnimation.MOVE_UP);
                break;
            }
            case DOWN: {
                turtle.playAnimation(TurtleAnimation.MOVE_DOWN);
            }
        }
        return TurtleCommandResult.success();
    }

    private static TurtleCommandResult canEnter(TurtlePlayer turtlePlayer, class_3218 world, class_2338 position) {
        if (world.method_31606(position)) {
            return TurtleCommandResult.failure(position.method_10264() < 0 ? "Too low to move" : "Too high to move");
        }
        if (!world.method_24794(position)) {
            return TurtleCommandResult.failure("Cannot leave the world");
        }
        if (turtlePlayer.isBlockProtected(world, position)) {
            return TurtleCommandResult.failure("Cannot enter protected area");
        }
        if (!world.method_8477(position)) {
            return TurtleCommandResult.failure("Cannot leave loaded world");
        }
        if (!world.method_8621().method_11952(position)) {
            return TurtleCommandResult.failure("Cannot pass the world border");
        }
        return TurtleCommandResult.success();
    }

    private boolean canPushEntities(class_1937 level, class_238 bounds) {
        if (!Config.turtlesCanPush) {
            return false;
        }
        return level.method_8333((class_1297)null, bounds, e -> e.method_5805() && !e.method_7325() && e.field_23807 && e.method_5657() == class_3619.field_15975).isEmpty();
    }
}

