/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.items;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.impl.PocketUpgrades;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerComputerRegistry;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.computer.inventory.AbstractComputerMenu;
import dan200.computercraft.shared.computer.inventory.ComputerMenuWithoutInventory;
import dan200.computercraft.shared.computer.items.IComputerItem;
import dan200.computercraft.shared.lectern.CustomLecternBlock;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.pocket.core.PocketBrain;
import dan200.computercraft.shared.pocket.core.PocketHolder;
import dan200.computercraft.shared.pocket.core.PocketServerComputer;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.NBTUtil;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.server.MinecraftServer;
import org.jspecify.annotations.Nullable;

public class PocketComputerItem
extends class_1792
implements IComputerItem,
IColouredItem {
    private static final String NBT_UPGRADE = "Upgrade";
    private static final String NBT_UPGRADE_INFO = "UpgradeInfo";
    public static final String NBT_ON = "On";
    private static final String NBT_INSTANCE = "InstanceId";
    private static final String NBT_SESSION = "SessionId";
    private final ComputerFamily family;

    public PocketComputerItem(class_1792.class_1793 settings, ComputerFamily family) {
        super(settings);
        this.family = family;
    }

    public class_1799 create(int id, @Nullable String label, int colour, @Nullable UpgradeData<IPocketUpgrade> upgrade) {
        class_1799 result = new class_1799((class_1935)this);
        if (id >= 0) {
            result.method_7948().method_10569("ComputerId", id);
        }
        if (label != null) {
            result.method_7977((class_2561)class_2561.method_43470((String)label));
        }
        if (upgrade != null) {
            result.method_7948().method_10582(NBT_UPGRADE, upgrade.upgrade().getUpgradeID().toString());
            if (!upgrade.data().method_33133()) {
                result.method_7948().method_10566(NBT_UPGRADE_INFO, (class_2520)upgrade.data().method_10553());
            }
        }
        if (colour != -1) {
            result.method_7948().method_10569("Color", colour);
        }
        return result;
    }

    public void tick(class_1799 stack, PocketHolder holder, boolean passive) {
        PocketBrain brain;
        if (passive) {
            PocketServerComputer computer = PocketComputerItem.getServerComputer(holder.level().method_8503(), stack);
            if (computer == null) {
                return;
            }
            brain = computer.getBrain();
        } else {
            brain = this.getOrCreateBrain(holder.level(), holder, stack);
            brain.computer().keepAlive();
        }
        UpgradeData<IPocketUpgrade> upgrade = brain.getUpgrade();
        if (upgrade != null) {
            upgrade.upgrade().update(brain, brain.computer().getPeripheral(ComputerSide.BACK));
        }
        if (this.updateItem(stack, brain)) {
            holder.setChanged();
        }
    }

    private boolean updateItem(class_1799 stack, PocketBrain brain) {
        boolean on;
        String label;
        boolean changed = brain.updateItem(stack);
        PocketServerComputer computer = brain.computer();
        int id = computer.getID();
        if (id != this.getComputerID(stack)) {
            changed = true;
            PocketComputerItem.setComputerID(stack, id);
        }
        if (!Objects.equals(label = computer.getLabel(), this.getLabel(stack))) {
            changed = true;
            if (label != null) {
                stack.method_7977((class_2561)class_2561.method_43470((String)label));
            } else {
                stack.method_7925();
            }
        }
        if ((on = computer.isOn()) != PocketComputerItem.isMarkedOn(stack)) {
            changed = true;
            stack.method_7948().method_10556(NBT_ON, on);
        }
        return changed;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int compartmentSlot, boolean selected) {
        if (world.field_9236 || !(entity instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)entity;
        int slot = InventoryUtil.getInventorySlotFromCompartment((class_1657)player, compartmentSlot, stack);
        if (slot < 0) {
            return;
        }
        this.tick(stack, new PocketHolder.PlayerHolder(player, slot), false);
    }

    public boolean onEntityItemUpdate(class_1799 stack, class_1542 entity) {
        class_1937 level = entity.method_37908();
        if (level.field_9236 || level.method_8503() == null) {
            return false;
        }
        this.tick(stack, new PocketHolder.ItemEntityHolder(entity), true);
        return false;
    }

    public class_1269 method_7884(class_1838 context) {
        return CustomLecternBlock.defaultUseItemOn(context);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!world.field_9236) {
            PocketHolder.PlayerHolder holder = new PocketHolder.PlayerHolder((class_3222)player, InventoryUtil.getHandSlot(player, hand));
            PocketBrain brain = this.getOrCreateBrain((class_3218)world, holder, stack);
            PocketServerComputer computer = brain.computer();
            computer.turnOn();
            boolean stop = false;
            IPocketUpgrade upgrade = PocketComputerItem.getUpgrade(stack);
            if (upgrade != null) {
                stop = upgrade.onRightClick(world, brain, computer.getPeripheral(ComputerSide.BACK));
                this.updateItem(stack, brain);
            }
            if (!stop) {
                PocketComputerItem.openImpl(player, stack, holder, hand == class_1268.field_5810, computer);
            }
        }
        return new class_1271(class_1269.method_29236((boolean)world.field_9236), (Object)stack);
    }

    public void open(class_1657 player, class_1799 stack, PocketHolder holder, boolean isTypingOnly) {
        PocketBrain brain = this.getOrCreateBrain(holder.level(), holder, stack);
        PocketServerComputer computer = brain.computer();
        computer.turnOn();
        PocketComputerItem.openImpl(player, stack, holder, isTypingOnly, computer);
    }

    private static void openImpl(class_1657 player, class_1799 stack, PocketHolder holder, boolean isTypingOnly, ServerComputer computer) {
        PlatformHelper.get().openMenu(player, stack.method_7964(), (id, inventory, entity) -> new ComputerMenuWithoutInventory((class_3917<? extends AbstractComputerMenu>)(isTypingOnly ? (class_3917)ModRegistry.Menus.POCKET_COMPUTER_NO_TERM.get() : (class_3917)ModRegistry.Menus.COMPUTER.get()), id, inventory, p -> holder.isValid(computer), computer), new ComputerContainerData(computer, stack));
    }

    public class_2561 method_7864(class_1799 stack) {
        String baseString = this.method_7866(stack);
        IPocketUpgrade upgrade = PocketComputerItem.getUpgrade(stack);
        if (upgrade != null) {
            return class_2561.method_43469((String)(baseString + ".upgraded"), (Object[])new Object[]{class_2561.method_43471((String)upgrade.getUnlocalisedAdjective())});
        }
        return super.method_7864(stack);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> list, class_1836 flag) {
        int id;
        if ((flag.method_8035() || this.getLabel(stack) == null) && (id = this.getComputerID(stack)) >= 0) {
            list.add((class_2561)class_2561.method_43469((String)"gui.computercraft.tooltip.computer_id", (Object[])new Object[]{id}).method_27692(class_124.field_1080));
        }
    }

    public @Nullable String getCreatorModId(class_1799 stack) {
        String mod;
        IPocketUpgrade upgrade = PocketComputerItem.getUpgrade(stack);
        if (upgrade != null && (mod = PocketUpgrades.instance().getOwner(upgrade)) != null && !mod.equals("computercraft")) {
            return mod;
        }
        return "computercraft";
    }

    private PocketBrain getOrCreateBrain(class_3218 level, PocketHolder holder, class_1799 stack) {
        ServerComputerRegistry registry = ServerContext.get(level.method_8503()).registry();
        PocketServerComputer computer = PocketComputerItem.getServerComputer(registry, stack);
        if (computer != null) {
            PocketBrain brain = computer.getBrain();
            brain.updateHolder(holder);
            return brain;
        }
        int computerID = this.getComputerID(stack);
        if (computerID < 0) {
            computerID = ComputerCraftAPI.createUniqueNumberedSaveDir(level.method_8503(), "computer");
            PocketComputerItem.setComputerID(stack, computerID);
        }
        PocketBrain brain = new PocketBrain(holder, PocketComputerItem.getUpgradeWithData(stack), ServerComputer.properties(this.getComputerID(stack), this.getFamily()).label(this.getLabel(stack)));
        PocketServerComputer computer2 = brain.computer();
        class_2487 tag = stack.method_7948();
        tag.method_10569(NBT_SESSION, registry.getSessionID());
        tag.method_25927(NBT_INSTANCE, computer2.register());
        if (PocketComputerItem.isMarkedOn(stack)) {
            computer2.turnOn();
        }
        this.updateItem(stack, brain);
        holder.setChanged();
        return brain;
    }

    public static boolean isServerComputer(ServerComputer computer, class_1799 stack) {
        return stack.method_7909() instanceof PocketComputerItem && PocketComputerItem.getServerComputer(computer.getLevel().method_8503(), stack) == computer;
    }

    public static @Nullable PocketServerComputer getServerComputer(ServerComputerRegistry registry, class_1799 stack) {
        return (PocketServerComputer)registry.get(PocketComputerItem.getSessionID(stack), PocketComputerItem.getInstanceID(stack));
    }

    public static @Nullable PocketServerComputer getServerComputer(MinecraftServer server, class_1799 stack) {
        return PocketComputerItem.getServerComputer(ServerContext.get(server).registry(), stack);
    }

    public void method_7843(class_1799 stack, class_1937 level, class_1657 player) {
        PocketServerComputer computer;
        class_2487 tag = stack.method_7969();
        if (tag == null) {
            return;
        }
        MinecraftServer server = level.method_8503();
        if (server != null && (computer = PocketComputerItem.getServerComputer(server, stack)) != null) {
            computer.getBrain().setUpgrade(PocketComputerItem.getUpgradeWithData(stack));
        }
    }

    private static void setComputerID(class_1799 stack, int computerID) {
        stack.method_7948().method_10569("ComputerId", computerID);
    }

    @Override
    public @Nullable String getLabel(class_1799 stack) {
        return IComputerItem.super.getLabel(stack);
    }

    public ComputerFamily getFamily() {
        return this.family;
    }

    @Override
    public class_1799 changeItem(class_1799 stack, class_1792 newItem) {
        class_1799 class_17992;
        if (newItem instanceof PocketComputerItem) {
            PocketComputerItem pocket = (PocketComputerItem)newItem;
            class_17992 = pocket.create(this.getComputerID(stack), this.getLabel(stack), this.getColour(stack), PocketComputerItem.getUpgradeWithData(stack));
        } else {
            class_17992 = class_1799.field_8037;
        }
        return class_17992;
    }

    public static @Nullable UUID getInstanceID(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        return nbt != null && nbt.method_25928(NBT_INSTANCE) ? nbt.method_25926(NBT_INSTANCE) : null;
    }

    private static int getSessionID(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        return nbt != null && nbt.method_10545(NBT_SESSION) ? nbt.method_10550(NBT_SESSION) : -1;
    }

    private static boolean isMarkedOn(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        return nbt != null && nbt.method_10577(NBT_ON);
    }

    public static @Nullable IPocketUpgrade getUpgrade(class_1799 stack) {
        class_2487 compound = stack.method_7969();
        if (compound == null || !compound.method_10545(NBT_UPGRADE)) {
            return null;
        }
        return PocketUpgrades.instance().get(compound.method_10558(NBT_UPGRADE));
    }

    public static @Nullable UpgradeData<IPocketUpgrade> getUpgradeWithData(class_1799 stack) {
        class_2487 compound = stack.method_7969();
        if (compound == null || !compound.method_10545(NBT_UPGRADE)) {
            return null;
        }
        IPocketUpgrade upgrade = PocketUpgrades.instance().get(compound.method_10558(NBT_UPGRADE));
        return upgrade == null ? null : UpgradeData.of(upgrade, NBTUtil.getCompoundOrEmpty(compound, NBT_UPGRADE_INFO));
    }

    public static void setUpgrade(class_1799 stack, @Nullable UpgradeData<IPocketUpgrade> upgrade) {
        class_2487 compound = stack.method_7948();
        if (upgrade == null) {
            compound.method_10551(NBT_UPGRADE);
            compound.method_10551(NBT_UPGRADE_INFO);
        } else {
            compound.method_10582(NBT_UPGRADE, upgrade.upgrade().getUpgradeID().toString());
            compound.method_10566(NBT_UPGRADE_INFO, (class_2520)upgrade.data().method_10553());
        }
    }

    public static class_2487 getUpgradeInfo(class_1799 stack) {
        return stack.method_7911(NBT_UPGRADE_INFO);
    }
}

