/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.shared.computer.items.IComputerItem;
import dan200.computercraft.shared.config.ConfigSpec;
import dan200.computercraft.shared.media.items.DiskItem;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3218;

public final class MountMedia
implements IMedia {
    public static final IMedia COMPUTER = new MountMedia("computer", s -> ((IComputerItem)s.method_7909()).getComputerID((class_1799)s), null, ConfigSpec.computerSpaceLimit);
    public static final IMedia DISK = new MountMedia("disk", DiskItem::getDiskID, DiskItem::setDiskID, ConfigSpec.floppySpaceLimit);
    private final String subPath;
    private final ToIntFunction<class_1799> getId;
    @Nullable
    private final IdSetter setId;
    private final Supplier<Integer> defaultCapacity;

    public MountMedia(String subPath, ToIntFunction<class_1799> getId, @Nullable IdSetter setId, Supplier<Integer> defaultCapacity) {
        this.subPath = subPath;
        this.getId = getId;
        this.setId = setId;
        this.defaultCapacity = defaultCapacity;
    }

    @Override
    @Nullable
    public String getLabel(class_1799 stack) {
        return stack.method_7938() ? stack.method_7964().getString() : null;
    }

    @Override
    public boolean setLabel(class_1799 stack, @Nullable String label) {
        if (label != null) {
            stack.method_7977((class_2561)class_2561.method_43470((String)label));
        } else {
            stack.method_7925();
        }
        return true;
    }

    @Override
    @Nullable
    public Mount createDataMount(class_1799 stack, class_3218 level) {
        int id = this.getId.applyAsInt(stack);
        if (id < 0) {
            if (this.setId == null) {
                return null;
            }
            id = ComputerCraftAPI.createUniqueNumberedSaveDir(level.method_8503(), this.subPath);
            this.setId.set(stack, id);
        }
        return ComputerCraftAPI.createSaveDirMount(level.method_8503(), this.subPath + "/" + id, this.defaultCapacity.get().intValue());
    }

    public static interface IdSetter {
        public void set(class_1799 var1, int var2);
    }
}

