/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis;

import dan200.computercraft.api.lua.LuaException;
import java.lang.constant.Constable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;
import java.time.temporal.WeekFields;
import java.util.HashMap;
import java.util.Map;
import java.util.function.LongUnaryOperator;
import org.jspecify.annotations.Nullable;

final class LuaDateTime {
    private static final TemporalField CENTURY = LuaDateTime.map(ChronoField.YEAR, ValueRange.of(0L, 99L), x -> x / 100L % 100L);
    private static final TemporalField ZERO_WEEK = LuaDateTime.map(WeekFields.SUNDAY_START.dayOfWeek(), ValueRange.of(0L, 6L), x -> x - 1L);

    private LuaDateTime() {
    }

    static void format(DateTimeFormatterBuilder formatter, String format) throws LuaException {
        int i = 0;
        block40: while (i < format.length()) {
            char c = format.charAt(i++);
            switch (c) {
                case '\n': {
                    formatter.appendLiteral('\n');
                    continue block40;
                }
                default: {
                    formatter.appendLiteral(c);
                    continue block40;
                }
                case '%': 
            }
            if (i >= format.length()) continue;
            c = format.charAt(i++);
            switch (c) {
                default: {
                    throw new LuaException("bad argument #1: invalid conversion specifier '%" + c + "'");
                }
                case '%': {
                    formatter.appendLiteral('%');
                    continue block40;
                }
                case 'a': {
                    formatter.appendText((TemporalField)ChronoField.DAY_OF_WEEK, TextStyle.SHORT);
                    continue block40;
                }
                case 'A': {
                    formatter.appendText((TemporalField)ChronoField.DAY_OF_WEEK, TextStyle.FULL);
                    continue block40;
                }
                case 'b': 
                case 'h': {
                    formatter.appendText((TemporalField)ChronoField.MONTH_OF_YEAR, TextStyle.SHORT);
                    continue block40;
                }
                case 'B': {
                    formatter.appendText((TemporalField)ChronoField.MONTH_OF_YEAR, TextStyle.FULL);
                    continue block40;
                }
                case 'c': {
                    LuaDateTime.format(formatter, "%a %b %e %H:%M:%S %Y");
                    continue block40;
                }
                case 'C': {
                    formatter.appendValueReduced(CENTURY, 2, 2, 0);
                    continue block40;
                }
                case 'd': {
                    formatter.appendValue(ChronoField.DAY_OF_MONTH, 2);
                    continue block40;
                }
                case 'D': 
                case 'x': {
                    LuaDateTime.format(formatter, "%m/%d/%y");
                    continue block40;
                }
                case 'e': {
                    formatter.padNext(2).appendValue(ChronoField.DAY_OF_MONTH);
                    continue block40;
                }
                case 'F': {
                    LuaDateTime.format(formatter, "%Y-%m-%d");
                    continue block40;
                }
                case 'g': {
                    formatter.appendValueReduced(IsoFields.WEEK_BASED_YEAR, 2, 2, 0);
                    continue block40;
                }
                case 'G': {
                    formatter.appendValue(IsoFields.WEEK_BASED_YEAR);
                    continue block40;
                }
                case 'H': {
                    formatter.appendValue(ChronoField.HOUR_OF_DAY, 2);
                    continue block40;
                }
                case 'I': {
                    formatter.appendValue(ChronoField.CLOCK_HOUR_OF_AMPM, 2);
                    continue block40;
                }
                case 'j': {
                    formatter.appendValue(ChronoField.DAY_OF_YEAR, 3);
                    continue block40;
                }
                case 'm': {
                    formatter.appendValue(ChronoField.MONTH_OF_YEAR, 2);
                    continue block40;
                }
                case 'M': {
                    formatter.appendValue(ChronoField.MINUTE_OF_HOUR, 2);
                    continue block40;
                }
                case 'n': {
                    formatter.appendLiteral('\n');
                    continue block40;
                }
                case 'p': {
                    formatter.appendText(ChronoField.AMPM_OF_DAY);
                    continue block40;
                }
                case 'r': {
                    LuaDateTime.format(formatter, "%I:%M:%S %p");
                    continue block40;
                }
                case 'R': {
                    LuaDateTime.format(formatter, "%H:%M");
                    continue block40;
                }
                case 'S': {
                    formatter.appendValue(ChronoField.SECOND_OF_MINUTE, 2);
                    continue block40;
                }
                case 't': {
                    formatter.appendLiteral('\t');
                    continue block40;
                }
                case 'T': 
                case 'X': {
                    LuaDateTime.format(formatter, "%H:%M:%S");
                    continue block40;
                }
                case 'u': {
                    formatter.appendValue(ChronoField.DAY_OF_WEEK);
                    continue block40;
                }
                case 'U': {
                    formatter.appendValue(ChronoField.ALIGNED_WEEK_OF_YEAR, 2);
                    continue block40;
                }
                case 'V': {
                    formatter.appendValue(IsoFields.WEEK_OF_WEEK_BASED_YEAR, 2);
                    continue block40;
                }
                case 'w': {
                    formatter.appendValue(ZERO_WEEK);
                    continue block40;
                }
                case 'W': {
                    formatter.appendValue(WeekFields.ISO.weekOfYear(), 2);
                    continue block40;
                }
                case 'y': {
                    formatter.appendValueReduced((TemporalField)ChronoField.YEAR, 2, 2, 0);
                    continue block40;
                }
                case 'Y': {
                    formatter.appendValue(ChronoField.YEAR);
                    continue block40;
                }
                case 'z': {
                    formatter.appendOffset("+HHMM", "+0000");
                    continue block40;
                }
                case 'Z': 
            }
            formatter.appendChronologyId();
        }
    }

    static long fromTable(Map<?, ?> table) throws LuaException {
        int year = LuaDateTime.getField(table, "year", -1);
        int month = LuaDateTime.getField(table, "month", -1);
        int day = LuaDateTime.getField(table, "day", -1);
        int hour = LuaDateTime.getField(table, "hour", 12);
        int minute = LuaDateTime.getField(table, "min", 12);
        int second = LuaDateTime.getField(table, "sec", 12);
        LocalDateTime time = LocalDateTime.of(year, month, day, hour, minute, second);
        Boolean isDst = LuaDateTime.getBoolField(table, "isdst");
        if (isDst != null) {
            boolean requireDst = isDst;
            for (ZoneOffset possibleOffset : ZoneOffset.systemDefault().getRules().getValidOffsets(time)) {
                Instant instant = time.toInstant(possibleOffset);
                if (possibleOffset.getRules().getDaylightSavings(instant).isZero() != requireDst) continue;
                return instant.getEpochSecond();
            }
        }
        ZoneOffset offset = ZoneOffset.systemDefault().getRules().getOffset(time);
        return time.toInstant(offset).getEpochSecond();
    }

    static Map<String, ?> toTable(TemporalAccessor date, ZoneId offset, Instant instant) {
        HashMap<String, Constable> table = new HashMap<String, Constable>(9);
        table.put("year", Long.valueOf(date.getLong(ChronoField.YEAR)));
        table.put("month", Long.valueOf(date.getLong(ChronoField.MONTH_OF_YEAR)));
        table.put("day", Long.valueOf(date.getLong(ChronoField.DAY_OF_MONTH)));
        table.put("hour", Long.valueOf(date.getLong(ChronoField.HOUR_OF_DAY)));
        table.put("min", Long.valueOf(date.getLong(ChronoField.MINUTE_OF_HOUR)));
        table.put("sec", Long.valueOf(date.getLong(ChronoField.SECOND_OF_MINUTE)));
        table.put("wday", Long.valueOf(date.getLong(WeekFields.SUNDAY_START.dayOfWeek())));
        table.put("yday", Long.valueOf(date.getLong(ChronoField.DAY_OF_YEAR)));
        table.put("isdst", Boolean.valueOf(offset.getRules().isDaylightSavings(instant)));
        return table;
    }

    private static int getField(Map<?, ?> table, String field, int def) throws LuaException {
        Object value = table.get(field);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (def < 0) {
            throw new LuaException("field \"" + field + "\" missing in date table");
        }
        return def;
    }

    private static @Nullable Boolean getBoolField(Map<?, ?> table, String field) throws LuaException {
        Object value = table.get(field);
        if (value instanceof Boolean || value == null) {
            return (Boolean)value;
        }
        throw new LuaException("field \"" + field + "\" missing in date table");
    }

    private static TemporalField map(final TemporalField field, final ValueRange range, final LongUnaryOperator convert) {
        return new TemporalField(){

            @Override
            public TemporalUnit getBaseUnit() {
                return field.getBaseUnit();
            }

            @Override
            public TemporalUnit getRangeUnit() {
                return field.getRangeUnit();
            }

            @Override
            public ValueRange range() {
                return range;
            }

            @Override
            public boolean isDateBased() {
                return field.isDateBased();
            }

            @Override
            public boolean isTimeBased() {
                return field.isTimeBased();
            }

            @Override
            public boolean isSupportedBy(TemporalAccessor temporal) {
                return field.isSupportedBy(temporal);
            }

            @Override
            public ValueRange rangeRefinedBy(TemporalAccessor temporal) {
                return range;
            }

            @Override
            public long getFrom(TemporalAccessor temporal) {
                return convert.applyAsLong(temporal.getLong(field));
            }

            @Override
            public <R extends Temporal> R adjustInto(R temporal, long newValue) {
                return (R)temporal.with(field, newValue);
            }
        };
    }
}

