/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import dan200.computercraft.client.model.turtle.ModelTransformer;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2382;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_777;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.jspecify.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class ModelRenderer {
    private ModelRenderer() {
    }

    public static void renderQuads(class_4587 transform, class_4588 buffer, List<class_777> quads, int lightmapCoord, int overlayLight, int @Nullable [] tints) {
        class_4587.class_4665 matrix = transform.method_23760();
        boolean inverted = matrix.method_23761().determinant() < 0.0f;
        for (class_777 bakedquad : quads) {
            int idx;
            int tint = -1;
            if (tints != null && bakedquad.method_3360() && (idx = bakedquad.method_3359()) >= 0 && idx < tints.length) {
                tint = tints[bakedquad.method_3359()];
            }
            float r = (float)(tint >> 16 & 0xFF) / 255.0f;
            float g = (float)(tint >> 8 & 0xFF) / 255.0f;
            float b = (float)(tint & 0xFF) / 255.0f;
            ModelRenderer.putBulkQuad(buffer, matrix, bakedquad, r, g, b, lightmapCoord, overlayLight, inverted);
        }
    }

    private static void putBulkQuad(class_4588 buffer, class_4587.class_4665 pose, class_777 quad, float red, float green, float blue, int lightmapCoord, int overlayLight, boolean invert) {
        Matrix4f matrix = pose.method_23761();
        class_2382 dirNormal = quad.method_3358().method_10163();
        Vector4f vector = new Vector4f();
        matrix.transform((float)dirNormal.method_10263(), (float)dirNormal.method_10264(), (float)dirNormal.method_10260(), 0.0f, vector).normalize();
        float normalX = vector.x();
        float normalY = vector.y();
        float normalZ = vector.z();
        int[] vertices = quad.method_3357();
        for (int vertex = 0; vertex < 4; ++vertex) {
            int i = ModelTransformer.getVertexOffset(vertex, invert);
            float x = Float.intBitsToFloat(vertices[i]);
            float y = Float.intBitsToFloat(vertices[i + 1]);
            float z = Float.intBitsToFloat(vertices[i + 2]);
            matrix.transform(x, y, z, 1.0f, vector);
            float u = Float.intBitsToFloat(vertices[i + 4]);
            float v = Float.intBitsToFloat(vertices[i + 5]);
            buffer.method_23919(vector.x(), vector.y(), vector.z(), red, green, blue, 1.0f, u, v, overlayLight, lightmapCoord, normalX, normalY, normalZ);
        }
    }
}

