/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import dan200.computercraft.client.gui.ClientInputHandler;
import dan200.computercraft.client.gui.ItemToast;
import dan200.computercraft.client.gui.OptionScreen;
import dan200.computercraft.client.gui.widgets.ComputerSidebar;
import dan200.computercraft.client.gui.widgets.DynamicImageButton;
import dan200.computercraft.client.gui.widgets.TerminalWidget;
import dan200.computercraft.client.network.ClientNetworking;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.util.Nullability;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.InputHandler;
import dan200.computercraft.shared.computer.inventory.AbstractComputerMenu;
import dan200.computercraft.shared.computer.upload.FileUpload;
import dan200.computercraft.shared.computer.upload.UploadResult;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.network.server.UploadFileMessage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_465;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractComputerScreen<T extends AbstractComputerMenu>
extends class_465<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractComputerScreen.class);
    private static final class_2561 OK = class_2561.method_43471((String)"gui.ok");
    private static final class_2561 NO_RESPONSE_TITLE = class_2561.method_43471((String)"gui.computercraft.upload.no_response");
    private static final class_2561 NO_RESPONSE_MSG = class_2561.method_43469((String)"gui.computercraft.upload.no_response.msg", (Object[])new Object[]{class_2561.method_43470((String)"import").method_27692(class_124.field_1063)});
    protected @Nullable TerminalWidget terminal;
    protected Terminal terminalData;
    protected final ComputerFamily family;
    protected final InputHandler input;
    protected final int sidebarYOffset;
    private long uploadNagDeadline = Long.MAX_VALUE;
    private final int uploadMaxSize;
    private final class_1799 displayStack;

    public AbstractComputerScreen(T container, class_1661 player, class_2561 title, int sidebarYOffset) {
        super(container, player, title);
        this.terminalData = ((AbstractComputerMenu)container).getTerminal();
        this.family = ((AbstractComputerMenu)container).getFamily();
        this.displayStack = ((AbstractComputerMenu)container).getDisplayStack();
        this.uploadMaxSize = ((AbstractComputerMenu)container).getUploadMaxSize();
        this.input = new ClientInputHandler(this.field_2797);
        this.sidebarYOffset = sidebarYOffset;
    }

    protected abstract TerminalWidget createTerminal();

    protected final TerminalWidget getTerminal() {
        if (this.terminal == null) {
            throw new IllegalStateException("Screen has not been initialised yet");
        }
        return this.terminal;
    }

    protected void method_25426() {
        super.method_25426();
        this.terminal = (TerminalWidget)this.method_37063((class_364)this.createTerminal());
        ComputerSidebar.addButtons(((AbstractComputerMenu)this.field_2797)::isOn, this.input, x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        }, this.field_2776, this.field_2800 + this.sidebarYOffset);
        this.method_25395((class_364)this.terminal);
    }

    public void method_37432() {
        super.method_37432();
        this.getTerminal().update();
        if (this.uploadNagDeadline != Long.MAX_VALUE && class_156.method_648() >= this.uploadNagDeadline) {
            new ItemToast(this.minecraft(), this.displayStack, NO_RESPONSE_TITLE, NO_RESPONSE_MSG, ItemToast.TRANSFER_NO_RESPONSE_TOKEN).showOrReplace(this.minecraft().method_1566());
            this.uploadNagDeadline = Long.MAX_VALUE;
        }
    }

    public boolean method_25404(int key, int scancode, int modifiers) {
        if (key == 258 && this.method_25399() != null && this.method_25399() == this.terminal) {
            return this.method_25399().method_25404(key, scancode, modifiers);
        }
        return super.method_25404(key, scancode, modifiers);
    }

    public boolean method_25406(double x, double y, int button) {
        this.method_25398(false);
        Optional child = this.method_19355(x, y);
        if (child.isPresent() && ((class_364)child.get()).method_25406(x, y, button)) {
            return true;
        }
        return super.method_25406(x, y, button);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(graphics);
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        this.method_2380(graphics, mouseX, mouseY);
    }

    public boolean method_25402(double x, double y, int button) {
        boolean changed = super.method_25402(x, y, button);
        if (this.method_25399() instanceof DynamicImageButton) {
            this.method_25395((class_364)this.terminal);
        }
        return changed;
    }

    public boolean method_25403(double x, double y, int button, double deltaX, double deltaY) {
        return this.method_25399() != null && this.method_25399().method_25403(x, y, button, deltaX, deltaY) || super.method_25403(x, y, button, deltaX, deltaY);
    }

    public void method_25395(@Nullable class_364 listener) {
        if (listener != this.method_25399()) {
            super.method_25395(listener);
        }
    }

    protected void method_2388(class_332 graphics, int mouseX, int mouseY) {
    }

    public void method_29638(List<Path> files) {
        if (files.isEmpty()) {
            return;
        }
        if (!((AbstractComputerMenu)this.field_2797).isOn()) {
            this.alert(UploadResult.FAILED_TITLE, UploadResult.COMPUTER_OFF_MSG);
            return;
        }
        long size = 0L;
        ArrayList<FileUpload> toUpload = new ArrayList<FileUpload>();
        for (Path file : files) {
            if (!Files.isRegularFile(file, new LinkOption[0])) continue;
            try {
                SeekableByteChannel sbc = Files.newByteChannel(file, new OpenOption[0]);
                try {
                    long fileSize = sbc.size();
                    if (fileSize > (long)this.uploadMaxSize || (size += fileSize) >= (long)this.uploadMaxSize) {
                        this.alert(UploadResult.FAILED_TITLE, UploadResult.TOO_MUCH_MSG);
                        return;
                    }
                    String name = file.getFileName().toString();
                    if (name.length() > 128) {
                        this.alert(UploadResult.FAILED_TITLE, (class_2561)class_2561.method_43471((String)"gui.computercraft.upload.failed.name_too_long"));
                        return;
                    }
                    ByteBuffer buffer = ByteBuffer.allocateDirect((int)fileSize);
                    sbc.read(buffer);
                    buffer.flip();
                    byte[] digest = FileUpload.getDigest(buffer);
                    if (digest == null) {
                        this.alert(UploadResult.FAILED_TITLE, (class_2561)class_2561.method_43471((String)"gui.computercraft.upload.failed.corrupted"));
                        return;
                    }
                    toUpload.add(new FileUpload(name, buffer, digest));
                }
                finally {
                    if (sbc == null) continue;
                    sbc.close();
                }
            }
            catch (IOException e) {
                LOG.error("Failed uploading files", (Throwable)e);
                this.alert(UploadResult.FAILED_TITLE, (class_2561)class_2561.method_43469((String)"gui.computercraft.upload.failed.generic", (Object[])new Object[]{"Cannot compute checksum"}));
            }
        }
        if (toUpload.size() > 32) {
            this.alert(UploadResult.FAILED_TITLE, (class_2561)class_2561.method_43471((String)"gui.computercraft.upload.failed.too_many_files"));
            return;
        }
        if (!toUpload.isEmpty()) {
            UploadFileMessage.send(this.field_2797, toUpload, ClientNetworking::sendToServer);
        }
    }

    public void uploadResult(UploadResult result, @Nullable class_2561 message) {
        switch (result) {
            case QUEUED: {
                if (Config.uploadNagDelay <= 0) break;
                this.uploadNagDeadline = class_156.method_648() + TimeUnit.SECONDS.toNanos(Config.uploadNagDelay);
                break;
            }
            case CONSUMED: {
                this.uploadNagDeadline = Long.MAX_VALUE;
                break;
            }
            case ERROR: {
                this.alert(UploadResult.FAILED_TITLE, Nullability.assertNonNull(message));
            }
        }
    }

    private void alert(class_2561 title, class_2561 message) {
        OptionScreen.show(this.minecraft(), title, message, List.of(OptionScreen.newButton(OK, b -> this.minecraft().method_1507((class_437)this))), () -> this.minecraft().method_1507((class_437)this));
    }

    private class_310 minecraft() {
        return Nullability.assertNonNull(this.field_22787);
    }
}

