/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.util;

import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.satisfy.vinery.platform.PlatformHelper;

public class WineYears {
    public static final int YEARS_START = 0;
    public static final int MAX_LEVEL = PlatformHelper.getWineMaxLevel();
    public static final int START_DURATION = PlatformHelper.getWineStartDuration();
    public static final int DURATION_PER_YEAR = PlatformHelper.getWineDurationPerYear();
    public static final int DAYS_PER_YEAR = PlatformHelper.getWineDaysPerYear();
    public static final int YEARS_PER_EFFECT_LEVEL = PlatformHelper.getWineYearsPerEffectLevel();
    public static final int MAX_DURATION = PlatformHelper.getWineMaxDuration();

    public static int getYear(class_1937 world) {
        return world != null ? 0 + (int)(world.method_8532() / 24000L / (long)DAYS_PER_YEAR) : 0;
    }

    public static int getEffectLevel(class_1799 wine, class_1937 world) {
        return Math.max(0, Math.min(MAX_LEVEL, WineYears.getWineAge(wine, world) / YEARS_PER_EFFECT_LEVEL));
    }

    public static int getWineAge(class_1799 wine, class_1937 world) {
        if (WineYears.hasWineYear(wine)) {
            return 0;
        }
        return WineYears.getYear(world) - WineYears.getWineYear(wine);
    }

    public static void setWineYear(class_1799 wine, class_1937 world) {
        if (world != null) {
            wine.method_7948().method_10569("Year", WineYears.getYear(world));
        } else {
            wine.method_7948().method_10569("Year", 0);
        }
    }

    public static int getWineYear(class_1799 wine) {
        class_2487 nbt = wine.method_7948();
        return nbt.method_10550("Year");
    }

    public static int getEffectDuration(class_1799 wine, class_1937 world) {
        int age = WineYears.getWineAge(wine, world);
        int duration = START_DURATION + DURATION_PER_YEAR * age;
        return Math.min(duration, MAX_DURATION);
    }

    public static boolean hasWineYear(class_1799 wine) {
        return !wine.method_7948().method_10545("Year");
    }
}

