/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.mob_container;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.api.ICatchableMob;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.BucketHelper;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.DataDefinedCatchableMob;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncCapturedMobsPacket;
import net.mehvahdjukaar.supplementaries.common.network.ModNetwork;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class CapturedMobHandler
extends class_4309 {
    private static final Set<String> COMMAND_MOBS = new HashSet<String>();
    private static final Map<class_1299<?>, DataDefinedCatchableMob> CUSTOM_MOB_PROPERTIES = new IdentityHashMap();
    private static DataDefinedCatchableMob moddedFishProperty;
    protected static final Gson GSON;
    public static final CapturedMobHandler RELOAD_INSTANCE;

    private CapturedMobHandler() {
        super(GSON, "catchable_mobs_properties");
    }

    protected void apply(Map<class_2960, JsonElement> jsons, class_3300 resourceManager, class_3695 profiler) {
        CUSTOM_MOB_PROPERTIES.clear();
        ArrayList list = new ArrayList();
        jsons.forEach((key, json) -> {
            DataResult v = DataDefinedCatchableMob.CODEC.parse((DynamicOps)JsonOps.INSTANCE, json);
            DataDefinedCatchableMob data = (DataDefinedCatchableMob)v.getOrThrow(false, e -> Supplementaries.LOGGER.error("failed to parse captured mob properties: {}", e));
            if (key.method_12832().equals("generic_fish")) {
                moddedFishProperty = data;
            } else {
                list.add(data);
            }
        });
        for (DataDefinedCatchableMob c : list) {
            for (class_2960 o : c.getOwners()) {
                class_7923.field_41177.method_17966(o).ifPresent(e -> CUSTOM_MOB_PROPERTIES.put((class_1299<?>)e, c));
            }
        }
        if (moddedFishProperty == null) {
            Supplementaries.LOGGER.error("Failed to find json for 'generic_fish'. How? Found jsons were : {}", jsons.keySet());
        }
    }

    public static void sendDataToClient(class_3222 player) {
        HashSet<DataDefinedCatchableMob> set = new HashSet<DataDefinedCatchableMob>(CUSTOM_MOB_PROPERTIES.values());
        ModNetwork.CHANNEL.sendToClientPlayer(player, (Message)new ClientBoundSyncCapturedMobsPacket(set, moddedFishProperty));
    }

    public static void acceptClientData(Set<DataDefinedCatchableMob> list, @Nullable DataDefinedCatchableMob defaultFish) {
        if (defaultFish != null) {
            moddedFishProperty = defaultFish;
        }
        CUSTOM_MOB_PROPERTIES.clear();
        for (DataDefinedCatchableMob c : list) {
            for (class_2960 o : c.getOwners()) {
                class_7923.field_41177.method_17966(o).ifPresent(e -> CUSTOM_MOB_PROPERTIES.put((class_1299<?>)e, c));
            }
        }
    }

    public static ICatchableMob getDataCap(class_1299<?> type, boolean isFish) {
        DataDefinedCatchableMob c = CUSTOM_MOB_PROPERTIES.get(type);
        if (c == null && isFish) {
            return moddedFishProperty;
        }
        return c;
    }

    public static ICatchableMob getCatchableMobCapOrDefault(class_1297 entity) {
        if (entity instanceof ICatchableMob) {
            ICatchableMob cap = (ICatchableMob)entity;
            return cap;
        }
        ICatchableMob forgeCap = SuppPlatformStuff.getForgeCap(entity, ICatchableMob.class);
        if (forgeCap != null) {
            return forgeCap;
        }
        ICatchableMob prop = CapturedMobHandler.getDataCap(entity.method_5864(), BucketHelper.isModdedFish(entity));
        if (prop != null) {
            return prop;
        }
        return ICatchableMob.DEFAULT;
    }

    public static boolean isCommandMob(String entity) {
        return COMMAND_MOBS.contains(entity);
    }

    public static void addCommandMob(String name) {
        COMMAND_MOBS.add(name);
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        RELOAD_INSTANCE = new CapturedMobHandler();
    }
}

