/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities;

import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.client.util.ParticleUtil;
import net.mehvahdjukaar.moonlight.api.entity.IExtraClientSpawnData;
import net.mehvahdjukaar.moonlight.api.entity.ImprovedProjectileEntity;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.ProjectileStats;
import net.mehvahdjukaar.supplementaries.common.misc.explosion.BombExplosion;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundExplosionPacket;
import net.mehvahdjukaar.supplementaries.common.network.ModNetwork;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.CompatObjects;
import net.mehvahdjukaar.supplementaries.integration.FlanCompat;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1674;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2530;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5362;
import net.minecraft.class_5819;

public class BombEntity
extends ImprovedProjectileEntity
implements IExtraClientSpawnData {
    private final boolean hasFuse = CommonConfigs.Tools.BOMB_FUSE.get() != 0;
    private BombType type = BombType.NORMAL;
    private boolean active = true;
    private int changeTimer = -1;
    private boolean superCharged = false;

    public BombEntity(class_1299<? extends BombEntity> type, class_1937 world) {
        super(type, world);
        this.maxAge = this.hasFuse ? CommonConfigs.Tools.BOMB_FUSE.get() : 200;
    }

    public BombEntity(class_1937 worldIn, class_1309 throwerIn, BombType type) {
        super(ModEntities.BOMB.get(), throwerIn, worldIn);
        this.type = type;
        this.maxAge = this.hasFuse ? CommonConfigs.Tools.BOMB_FUSE.get() : 300;
    }

    public BombEntity(class_1937 worldIn, double x, double y, double z, BombType type) {
        super(ModEntities.BOMB.get(), x, y, z, worldIn);
        this.type = type;
        this.maxAge = this.hasFuse ? CommonConfigs.Tools.BOMB_FUSE.get() : 300;
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("Active", this.active);
        compound.method_10569("Type", this.type.ordinal());
        compound.method_10569("Timer", this.changeTimer);
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.active = compound.method_10577("Active");
        this.type = BombType.values()[compound.method_10550("Type")];
        this.changeTimer = compound.method_10550("Timer");
    }

    public void readSpawnData(class_2540 buffer) {
        this.type = (BombType)buffer.method_10818(BombType.class);
    }

    public void writeSpawnData(class_2540 buffer) {
        buffer.method_10817((Enum)this.type);
    }

    public class_2596<class_2602> method_18002() {
        return PlatHelper.getEntitySpawnPacket((class_1297)this);
    }

    protected class_1792 method_16942() {
        return ModRegistry.BOMB_ITEM_ON.get();
    }

    public class_1799 method_7495() {
        return this.type.getDisplayStack(this.active);
    }

    private void spawnBreakParticles() {
        for (int i = 0; i < 8; ++i) {
            this.method_37908().method_8406((class_2394)new class_2392(class_2398.field_11218, this.method_7495()), this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
        }
    }

    public void method_5711(byte id) {
        switch (id) {
            case 3: {
                this.spawnBreakParticles();
                this.method_31472();
                break;
            }
            case 10: {
                this.spawnBreakParticles();
                this.method_31472();
                break;
            }
            case 68: {
                this.method_37908().method_8406((class_2394)class_2398.field_38908, this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
                break;
            }
            case 67: {
                class_5819 random = this.method_37908().method_8409();
                for (int i = 0; i < 10; ++i) {
                    this.method_37908().method_8406((class_2394)class_2398.field_11251, this.method_23317() + 0.25 - (double)(random.method_43057() * 0.5f), this.method_23318() + (double)0.45f - (double)(random.method_43057() * 0.5f), this.method_23321() + 0.25 - (double)(random.method_43057() * 0.5f), 0.0, 0.005, 0.0);
                }
                this.active = false;
                break;
            }
            default: {
                super.method_5711(id);
            }
        }
    }

    public boolean hasReachedEndOfLife() {
        return super.hasReachedEndOfLife() || this.changeTimer == 0;
    }

    public void method_5773() {
        if (this.active && this.method_5799() && this.type != BombType.BLUE) {
            this.turnOff();
        }
        super.method_5773();
    }

    public void spawnTrailParticles() {
        class_243 newPos = this.method_19538();
        if (this.active && this.field_6012 > 1) {
            double dx = newPos.field_1352 - this.field_6014;
            double dy = newPos.field_1351 - this.field_6036;
            double dz = newPos.field_1350 - this.field_5969;
            int s = 4;
            for (int i = 0; i < s; ++i) {
                double j = (double)i / (double)s;
                this.method_37908().method_8406((class_2394)class_2398.field_11251, this.field_6014 - dx * j, 0.25 + this.field_6036 - dy * j, this.field_5969 - dz * j, 0.0, 0.02, 0.0);
            }
        }
    }

    public void turnOff() {
        class_1937 level = this.method_37908();
        if (!level.method_8608()) {
            level.method_8421((class_1297)this, (byte)67);
            level.method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_15222, class_3419.field_15245, 0.5f, 1.5f);
        }
        this.active = false;
    }

    public void method_5694(class_1657 entityIn) {
        if (!this.method_37908().field_9236 && !this.active && entityIn.method_31548().method_7394(this.method_7495())) {
            entityIn.method_6103((class_1297)this, 1);
            this.method_5650(class_1297.class_5529.field_26999);
        }
    }

    protected void method_7454(class_3966 hit) {
        super.method_7454(hit);
        hit.method_17782().method_5643(this.method_37908().method_48963().method_48811((class_1297)this, this.method_24921()), 1.0f);
        if (hit.method_17782() instanceof class_1674) {
            this.superCharged = true;
            hit.method_17782().method_5650(class_1297.class_5529.field_26999);
        }
        this.activateBomb();
    }

    protected void method_24920(class_3965 hit) {
        super.method_24920(hit);
        class_2680 state = this.method_37908().method_8320(hit.method_17777());
        if (!state.method_26164(ModTags.BOUNCY_BLOCKS) || hit.method_17780() != class_2350.field_11036) {
            this.method_18799(class_243.field_1353);
            this.method_24830(true);
            this.activateBomb();
        }
    }

    private void activateBomb() {
        class_1937 level = this.method_37908();
        if (!level.field_9236 && !this.hasFuse) {
            boolean isInstantlyActivated = this.type.isInstantlyActivated();
            if (!isInstantlyActivated && this.changeTimer == -1) {
                this.changeTimer = 5;
                level.method_8421((class_1297)this, (byte)68);
                level.method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_15145, class_3419.field_15254, 1.5f, 1.3f);
            }
            if (!this.method_31481() && (isInstantlyActivated || this.superCharged)) {
                this.reachedEndOfLife();
            }
        }
    }

    protected void method_26962() {
    }

    public float getDefaultShootVelocity() {
        return ProjectileStats.BOMB_SPEED;
    }

    public float method_7490() {
        return ProjectileStats.BOMB_GRAVITY;
    }

    public void reachedEndOfLife() {
        class_1937 level = this.method_37908();
        level.method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_21919, class_3419.field_15254, 1.5f, 1.5f);
        if (!level.field_9236) {
            if (this.active) {
                this.createExplosion();
                level.method_8421((class_1297)this, (byte)10);
            } else {
                level.method_8421((class_1297)this, (byte)3);
            }
            this.method_31472();
        }
    }

    private void createExplosion() {
        class_1657 p;
        Object object;
        boolean breaks;
        boolean bl = breaks = this.method_24921() instanceof class_1657 || PlatHelper.isMobGriefingOn((class_1937)this.method_37908(), (class_1297)this.method_24921());
        if (CompatHandler.FLAN && (object = this.method_24921()) instanceof class_1657 && !FlanCompat.canBreak(p = (class_1657)object, class_2338.method_49638((class_2374)this.method_19538()))) {
            breaks = false;
        }
        if (this.superCharged) {
            this.method_37908().method_8537((class_1297)this, this.method_23317(), this.method_23318(), this.method_23321(), 6.0f, breaks, this.method_24921() instanceof class_1657 ? class_1937.class_7867.field_40891 : class_1937.class_7867.field_40890);
        }
        BombExplosion explosion = new BombExplosion(this.method_37908(), (class_1297)this, new BombExplosionDamageCalculator(this.type), this.method_23317(), this.method_23318() + 0.25, this.method_23321(), this.type, breaks ? class_1927.class_4179.field_18687 : class_1927.class_4179.field_40878);
        explosion.method_8348();
        explosion.method_8350(true);
        for (class_1657 p2 : this.method_37908().method_18456()) {
            if (!(p2.method_5858((class_1297)this) < 4096.0) || !(p2 instanceof class_3222)) continue;
            class_3222 sp = (class_3222)p2;
            ClientBoundExplosionPacket message = ClientBoundExplosionPacket.bomb(explosion, p2);
            ModNetwork.CHANNEL.sendToClientPlayer(sp, (Message)message);
        }
    }

    public static enum BombType {
        NORMAL(ModRegistry.BOMB_ITEM, ModRegistry.BOMB_ITEM_ON),
        BLUE(ModRegistry.BOMB_BLUE_ITEM, ModRegistry.BOMB_BLUE_ITEM_ON),
        SPIKY(ModRegistry.BOMB_SPIKY_ITEM, ModRegistry.BOMB_SPIKY_ITEM_ON);

        public final Supplier<class_1792> item;
        public final Supplier<class_1792> itemOn;

        private BombType(Supplier<class_1792> item, Supplier<class_1792> itemOn) {
            this.item = item;
            this.itemOn = itemOn;
        }

        public class_1799 getDisplayStack(boolean active) {
            return (active ? this.itemOn : this.item).get().method_7854();
        }

        public double getRadius() {
            return this == BLUE ? CommonConfigs.Tools.BOMB_BLUE_RADIUS.get() : CommonConfigs.Tools.BOMB_RADIUS.get();
        }

        public BreakingMode breakMode() {
            return this == BLUE ? CommonConfigs.Tools.BOMB_BLUE_BREAKS.get() : CommonConfigs.Tools.BOMB_BREAKS.get();
        }

        public float volume() {
            return this == BLUE ? 5.0f : 3.0f;
        }

        public void applyStatusEffects(class_1309 entity, double distSq) {
            switch (this.ordinal()) {
                case 1: {
                    entity.method_6092(new class_1293(class_1294.field_5911, 600));
                    entity.method_5639(10);
                    break;
                }
            }
        }

        public boolean isInstantlyActivated() {
            return this != BLUE;
        }

        public void spawnExtraParticles(double x, double y, double z, class_1937 level) {
            switch (this.ordinal()) {
                case 1: {
                    ParticleUtil.spawnParticleInASphere((class_1937)level, (double)x, (double)y, (double)z, () -> class_2398.field_11240, (int)40, (float)0.4f, (float)0.01f, (float)0.15f);
                    break;
                }
                case 2: {
                    class_5819 random = level.method_8409();
                    class_2396<?> particle = CompatObjects.SHARPNEL.get();
                    if (particle instanceof class_2394) {
                        class_2394 p = (class_2394)particle;
                        for (int i = 0; i < 80; ++i) {
                            float dx = (float)(random.method_43059() * 2.0);
                            float dy = (float)(random.method_43059() * 2.0);
                            float dz = (float)(random.method_43059() * 2.0);
                            level.method_8406(p, x, y, z, (double)dx, (double)dy, (double)dz);
                        }
                        break;
                    }
                    ParticleUtil.spawnParticleInASphere((class_1937)level, (double)x, (double)y, (double)z, () -> class_2398.field_11205, (int)100, (float)5.0f, (float)0.01f, (float)0.15f);
                }
            }
        }

        public void afterExploded(BombExplosion exp, class_1937 level) {
            if (this == SPIKY) {
                class_243 pos = exp.method_8349().method_5510();
                class_1309 e = exp.method_8347();
                if (e == null) {
                    return;
                }
                for (class_1297 entity : level.method_8335((class_1297)e, new class_238(pos.field_1352 - 30.0, pos.field_1351 - 4.0, pos.field_1350 - 30.0, pos.field_1352 + 30.0, pos.field_1351 + 4.0, pos.field_1350 + 30.0))) {
                    int random = level.field_9229.method_43054() * 100;
                    boolean shouldPoison = false;
                    if (entity.method_5858((class_1297)e) <= 16.0) {
                        shouldPoison = true;
                    } else if (entity.method_5858((class_1297)e) <= 64.0) {
                        if (random < 60) {
                            shouldPoison = true;
                        }
                    } else if (entity.method_5858((class_1297)e) <= 225.0) {
                        if (random < 30) {
                            shouldPoison = true;
                        }
                    } else if (entity.method_5858((class_1297)e) <= 900.0 && random < 5) {
                        shouldPoison = true;
                    }
                    if (!shouldPoison || !(entity instanceof class_1309)) continue;
                    class_1309 livingEntity = (class_1309)entity;
                    livingEntity.method_5643(level.method_48963().method_48831(), 2.0f);
                    livingEntity.method_6092(new class_1293(class_1294.field_5899, 130));
                    class_1291 effect = CompatObjects.STUNNED_EFFECT.get();
                    if (effect == null) continue;
                    livingEntity.method_6092(new class_1293(effect, 400));
                }
            }
        }
    }

    private static class BombExplosionDamageCalculator
    extends class_5362 {
        private final BombType type;

        public BombExplosionDamageCalculator(BombType type) {
            this.type = type;
        }

        public boolean method_29554(class_1927 explosion, class_1922 reader, class_2338 pos, class_2680 state, float power) {
            return switch (this.type.breakMode().ordinal()) {
                case 0 -> true;
                case 1 -> {
                    if (state.method_26188((class_3611)class_3612.field_15910) || state.method_26164(ModTags.BOMB_BREAKABLE) || state.method_26204() instanceof class_2530) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
    }

    public static enum BreakingMode {
        ALL,
        WEAK,
        NONE;

    }
}

